/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.markers;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.builder.BaseErrorMarkerRule;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.osgi.framework.Version;

public class PomSemanticVersioningRule
extends BaseErrorMarkerRule {
    private IProject project;
    private PomMuleProjectModel pomMuleProjectModel;

    public PomSemanticVersioningRule(PomMuleProjectModel pomMuleProjectModel) {
        this.pomMuleProjectModel = pomMuleProjectModel;
    }

    @Override
    protected boolean evaluate(IProject project) throws CoreException {
        this.project = project;
        String version = this.pomMuleProjectModel.getVersion();
        version = version.indexOf(45) != -1 ? version.substring(0, version.indexOf(45)) : version;
        version = version.replaceAll("0", "9");
        try {
            Version parsedVersion = Version.parseVersion((String)version);
            return parsedVersion != null && parsedVersion != Version.emptyVersion && parsedVersion.getMicro() != 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    protected String getMarkerType() {
        return "org.mule.tooling.core.invalid_project_model_file";
    }

    @Override
    protected String getMessage() {
        return MessageFormat.format("Project {0}''s version does not comply with semantic versioning specifications (major.minor.patch).", this.project.getName()) + " The project dependencies, execution and other actions will be unavailable until corrected.";
    }

    @Override
    protected IResource getTargetResource(IProject project) {
        return project.getFile("pom.xml");
    }
}

