/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.markers;

import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.builder.BaseErrorMarkerRule;
import org.mule.tooling.core.m2.internal.PomFileHandler;

public class PomFileValidRule
extends BaseErrorMarkerRule {
    private IProject project;
    private PomFileHandler pomFileHandler;

    public PomFileValidRule(PomFileHandler pomFileHandler) {
        this.pomFileHandler = pomFileHandler;
    }

    @Override
    protected boolean evaluate(IProject project) throws CoreException {
        this.project = project;
        return PomFileHandler.PomState.RESOLVED.equals((Object)this.pomFileHandler.getPomState());
    }

    @Override
    protected String getMarkerType() {
        return "org.mule.tooling.core.invalid_project_model_file";
    }

    @Override
    protected String getMessage() {
        return MessageFormat.format("Project {0}''s pom.xml file has invalid content.", this.project.getName()) + " The project dependencies, execution and other actions will be unavailable until corrected.";
    }

    @Override
    protected IResource getTargetResource(IProject project) {
        return project.getFile("pom.xml");
    }
}

