/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.markers;

import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.builder.BaseErrorMarkerRule;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.model.project.MuleExtension;

public class ExtensionResolutionRule
extends BaseErrorMarkerRule {
    private static final String MARKER_ATT_EXTENSION = "_extension";
    private MuleExtension muleExtension;
    private Map<MavenDependency, List<Exception>> exceptionsMap;

    public static ExtensionResolutionRule withErrors(MuleExtension muleExtension, Map<MavenDependency, List<Exception>> exceptionsMap) {
        return new ExtensionResolutionRule(muleExtension, exceptionsMap);
    }

    public static ExtensionResolutionRule withValidResult(MuleExtension muleExtension) {
        return new ExtensionResolutionRule(muleExtension, null);
    }

    private ExtensionResolutionRule(MuleExtension muleExtension, Map<MavenDependency, List<Exception>> exceptionsMap) {
        this.muleExtension = muleExtension;
        this.exceptionsMap = exceptionsMap;
    }

    @Override
    protected String getMarkerType() {
        return "org.mule.tooling.core.m2.extensions_marker";
    }

    @Override
    protected boolean evaluate(IProject project) throws CoreException {
        return this.exceptionsMap == null;
    }

    @Override
    protected String getMessage() {
        StringBuilder messageBuilder = new StringBuilder("Failed to resolve module ");
        messageBuilder.append(this.muleExtension.getQualifier());
        messageBuilder.append(" ");
        messageBuilder.append("(hover for more details or open this problem's Properties)");
        messageBuilder.append(System.lineSeparator());
        MavenCore.appendExceptions(messageBuilder, this.exceptionsMap);
        return messageBuilder.toString();
    }

    @Override
    protected void configure(IMarker marker) throws CoreException {
        super.configure(marker);
        marker.setAttribute(this.getMarkerType() + MARKER_ATT_EXTENSION, (Object)this.muleExtension.getQualifier());
    }

    @Override
    protected boolean matches(IMarker marker) throws CoreException {
        return this.muleExtension.getQualifier().equals(marker.getAttribute(this.getMarkerType() + MARKER_ATT_EXTENSION));
    }
}

