/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal.markers;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.builder.BaseErrorMarkerRule;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;

public class DependencyResolutionRule
extends BaseErrorMarkerRule {
    private Map<MavenDependency, List<Exception>> exceptionsMap;

    public static DependencyResolutionRule withValidResult() {
        return new DependencyResolutionRule(null);
    }

    public static DependencyResolutionRule withFailedDependencies(List<MavenDependency> dependencies) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        dependencies.forEach(dependency2 -> {
            ImmutableMap.Builder builder2 = builder.put(dependency2, Collections.emptyList());
        });
        return new DependencyResolutionRule((Map<MavenDependency, List<Exception>>)builder.build());
    }

    public static DependencyResolutionRule withErrors(Map<MavenDependency, List<Exception>> errors) {
        return new DependencyResolutionRule(errors);
    }

    private DependencyResolutionRule(Map<MavenDependency, List<Exception>> errorsMap) {
        this.exceptionsMap = errorsMap;
    }

    @Override
    protected boolean evaluate(IProject project) throws CoreException {
        return this.exceptionsMap == null;
    }

    @Override
    protected String getMarkerType() {
        return "org.mule.tooling.core.m2.project_libs_marker";
    }

    @Override
    protected String getMessage() {
        StringBuilder stringBuilder = new StringBuilder("Failed to resolve ");
        String failedDependencies = this.exceptionsMap.keySet().stream().map(dep1 -> MavenUtils.getGAV(dep1)).collect(Collectors.joining(", "));
        stringBuilder.append(failedDependencies);
        stringBuilder.append(" ");
        stringBuilder.append("(hover for more details or open this problem's Properties)");
        stringBuilder.append(System.lineSeparator());
        MavenCore.appendExceptions(stringBuilder, this.exceptionsMap);
        return stringBuilder.toString();
    }

    @Override
    protected boolean matches(IMarker marker) throws CoreException {
        return true;
    }

    public Map<MavenDependency, List<Exception>> getExceptionsMap() {
        return this.exceptionsMap;
    }
}

