/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.File;
import javax.xml.xpath.XPathExpressionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.Resource;
import org.mule.tooling.core.m2.IMavenPropertyResolver;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.XmlEditingHelper;
import org.mule.tooling.core.m2.internal.PomFileHandler;

public class WriteSafeDecoratorHandler
implements PomFileHandler {
    private PomFileHandler decorated;

    public WriteSafeDecoratorHandler(PomFileHandler decorated) {
        this.decorated = decorated;
    }

    protected void preWriteCheck() {
        this.decorated.ensureSync();
        if (!this.decorated.isPomWellFormed()) {
            throw new IllegalStateException("Trying to write pom.xml file while in an invalid state");
        }
    }

    @Override
    public MavenModelHelper getMavenModelHelper() {
        return this.decorated.getMavenModelHelper();
    }

    @Override
    public File getPomFile() {
        return this.decorated.getPomFile();
    }

    @Override
    public boolean isPomWellFormed() {
        return this.decorated.isPomWellFormed();
    }

    @Override
    public void ensureSync() {
        this.decorated.ensureSync();
    }

    @Override
    public void removeDependency(Dependency dependency2) {
        this.preWriteCheck();
        this.decorated.removeDependency(dependency2);
    }

    @Override
    public void addDependency(Dependency newDependency) {
        this.preWriteCheck();
        this.decorated.addDependency(newDependency);
    }

    @Override
    public void addRepository(Repository repository) {
        this.preWriteCheck();
        this.decorated.addRepository(repository);
    }

    @Override
    public void addRepositoryBefore(Repository repositoryToAdd, Repository existingRepository) {
        this.preWriteCheck();
        this.decorated.addRepositoryBefore(repositoryToAdd, existingRepository);
    }

    @Override
    public void addTestResource(Resource resource) {
        this.preWriteCheck();
        this.decorated.addTestResource(resource);
    }

    @Override
    public void addResource(Resource resource) {
        this.preWriteCheck();
        this.decorated.addResource(resource);
    }

    @Override
    public void writeChanges() {
        this.preWriteCheck();
        this.decorated.writeChanges();
    }

    @Override
    public void loadPom() {
        this.decorated.loadPom();
    }

    @Override
    public void addProperty(String name, String value) {
        this.preWriteCheck();
        this.decorated.addProperty(name, value);
    }

    @Override
    public XmlEditingHelper editExecutionConfigurationForPlugin(String pluginGroupId, String pluginArtifactId, String executionId) {
        this.preWriteCheck();
        return this.decorated.editExecutionConfigurationForPlugin(pluginGroupId, pluginArtifactId, executionId);
    }

    @Override
    public XmlEditingHelper editConfigurationForPlugin(String pluginGroupId, String pluginArtifactId) {
        this.preWriteCheck();
        return this.decorated.editConfigurationForPlugin(pluginGroupId, pluginArtifactId);
    }

    @Override
    public XmlEditingHelper getOrCreatePlugin(String pluginGroupId, String pluginArtifactId, String version) {
        this.preWriteCheck();
        return this.decorated.getOrCreatePlugin(pluginGroupId, pluginArtifactId, version);
    }

    @Override
    public XmlEditingHelper edit(String xpathExpression) throws XPathExpressionException {
        this.preWriteCheck();
        return this.decorated.edit(xpathExpression);
    }

    @Override
    public void removePlugin(String pluginGroupId, String pluginArtifactId) {
        this.preWriteCheck();
        this.decorated.removePlugin(pluginGroupId, pluginArtifactId);
    }

    @Override
    public void removeProperty(String name) {
        this.preWriteCheck();
        this.decorated.removeProperty(name);
    }

    @Override
    public Model getRawModel() {
        return this.decorated.getRawModel();
    }

    @Override
    public Model getMavenModel() {
        return this.decorated.getMavenModel();
    }

    @Override
    public IMavenPropertyResolver getPropertyResolver() {
        return this.decorated.getPropertyResolver();
    }

    @Override
    public PomFileHandler.PomState getPomState() {
        return this.decorated.getPomState();
    }
}

