/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.graph.selector.ScopeDependencySelector;
import org.mule.tooling.core.m2.internal.Booter;
import org.mule.tooling.core.m2.internal.ConsoleRepositoryListener;
import org.mule.tooling.core.m2.internal.ConsoleTransferListener;
import org.mule.tooling.core.m2.internal.MavenCore;

public class RepositorySystemSessionBuilder {
    private Booter.UpdatePolicy updatePolicy;
    private RepositorySystem repositorySystem;
    private String localRepository;
    private TransferListener transferListener;
    private RepositoryListener repositoryListener;
    private DependencySelector dependencySelector;
    private boolean offline;

    public static RepositorySystemSessionBuilder newInstance() {
        return new RepositorySystemSessionBuilder();
    }

    private RepositorySystemSessionBuilder() {
    }

    public RepositorySystemSessionBuilder withUpdatePolicy(Booter.UpdatePolicy updatePolicy) {
        this.updatePolicy = updatePolicy;
        return this;
    }

    public RepositorySystemSessionBuilder withRepositorySystem(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
        return this;
    }

    public RepositorySystemSessionBuilder withLocalRepository(String localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    public RepositorySystemSessionBuilder withTransferListener(TransferListener transferListener) {
        this.transferListener = transferListener;
        return this;
    }

    public RepositorySystemSessionBuilder withRepositoryListener(RepositoryListener repositoryListener) {
        this.repositoryListener = repositoryListener;
        return this;
    }

    public RepositorySystemSessionBuilder withDependencySelector(DependencySelector dependencySelector) {
        this.dependencySelector = dependencySelector;
        return this;
    }

    public RepositorySystemSessionBuilder offline(boolean offline) {
        this.offline = offline;
        return this;
    }

    public RepositorySystemSession build() {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        String repo = StringUtils.isNotBlank((CharSequence)this.localRepository) ? this.localRepository : MavenCore.getM2repoPath();
        LocalRepository localRepo = new LocalRepository(repo);
        session.setLocalRepositoryManager(this.repositorySystem.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)(this.transferListener != null ? this.transferListener : new ConsoleTransferListener()));
        session.setRepositoryListener((RepositoryListener)(this.repositoryListener != null ? this.repositoryListener : new ConsoleRepositoryListener()));
        session.setDependencySelector(this.dependencySelector != null ? this.dependencySelector : RepositorySystemSessionBuilder.getDefaultSelector());
        session.setUpdatePolicy(this.updatePolicy == null ? Booter.UpdatePolicy.NEVER.getValue() : this.updatePolicy.getValue());
        session.setOffline(this.offline);
        return session;
    }

    public static DependencySelector getDefaultSelector() {
        return new AndDependencySelector(new DependencySelector[]{new ScopeDependencySelector(new String[]{"system", "runtime"}), new OptionalDependencySelector(), new ExclusionDependencySelector()});
    }
}

