/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.apache.maven.model.Dependency;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.SubMonitor;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.internal.MuleMavenClient;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;
import org.mule.maven.pom.parser.api.model.BundleScope;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.DependencyResolutionException;
import org.mule.tooling.core.m2.IDependencyResolver;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilderBase;
import org.mule.tooling.core.m2.internal.DefaultPomFileHandler;
import org.mule.tooling.core.m2.internal.DependencyResolutionResult;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.MavenClientFactory;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.collection.ListView;

public class MuleMavenClientResolver
implements IDependencyResolver {
    private static final MavenDependency AUX_MAVEN_MODEL = MavenModelHelper.mavenDependency("com", "auxiliary", "1.0");
    private static final String ROOT_NODE_EXPRESSION = "/pom:project";
    private static final String REPOSITORIES_TAG_NAME = "repositories";
    private static final int TASK_SIZE = 100;
    private final Settings settings;
    private final MavenConfiguration baseConfiguration;
    private final Consumer<DefaultRepositorySystemSession> sessionConfigurator;

    public MuleMavenClientResolver(Settings settings, MavenConfiguration configuration, Consumer<DefaultRepositorySystemSession> sessionConfigurator) {
        this.settings = settings;
        this.baseConfiguration = configuration;
        this.sessionConfigurator = sessionConfigurator;
    }

    @Override
    public List<DependencyResolutionResult> resolvePluginDependencies(IMuleProject muleProject, Collection<MavenDependency> dependencies, IProgressMonitor monitor) throws DependencyResolutionException {
        SubMonitor submonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        int stepSize = 50;
        MavenClient mavenClient = this.getMavenClient(muleProject);
        List requestDescriptors = dependencies.stream().map(MavenUtils::getBundleDescriptor).collect(Collectors.toList());
        List pluginDescriptorsResult = Collections.emptyList();
        try {
            try {
                pluginDescriptorsResult = mavenClient.resolvePluginBundleDescriptorsDependencies(requestDescriptors);
            }
            catch (Exception e) {
                if (e.getCause() instanceof DependencyResolutionException) {
                    DependencyResolutionException exc = (DependencyResolutionException)e.getCause();
                    throw exc;
                }
                List<DependencyResolutionResult> list = dependencies.stream().map(dep -> DependencyResolutionResult.builder().withDependency((MavenDependency)dep).withException(e).build()).collect(Collectors.toList());
                submonitor.split(stepSize);
                return list;
            }
        }
        finally {
            submonitor.split(stepSize);
        }
        return pluginDescriptorsResult.stream().map(descriptor -> this.getResult((BundleDependency)descriptor, dependencies)).collect(Collectors.toList());
    }

    @Override
    public List<DependencyResolutionResult> resolveDependencies(IMuleProject muleProject, Collection<MavenDependency> dependencies, DependencyResolutionConfiguration configuration, IProgressMonitor monitor) throws DependencyResolutionException {
        MavenClient mavenClient = this.getMavenClient(muleProject);
        List<DependencyResolutionResult> dependenciesResults = this.doResolveDependencies(muleProject, dependencies, configuration, mavenClient);
        List<DependencyResolutionResult> mulePluginResults = this.doResolvePluginDependencies(muleProject, dependencies, configuration, mavenClient);
        return ListView.of(dependenciesResults, mulePluginResults);
    }

    private List<DependencyResolutionResult> doResolvePluginDependencies(IMuleProject muleProject, Collection<MavenDependency> dependencies, DependencyResolutionConfiguration configuration, MavenClient mavenClient) throws DependencyResolutionException {
        List mulePluginDependencies = dependencies.stream().filter(MavenUtils::isMulePlugin).collect(Collectors.toList());
        LinkedList<DependencyResolutionResult> results = new LinkedList<DependencyResolutionResult>();
        for (MavenDependency mulePluginDependency : mulePluginDependencies) {
            LinkedList bundleDependencies;
            block7: {
                bundleDependencies = new LinkedList();
                IFile pomFile = null;
                try {
                    try {
                        pomFile = this.getPomFileToResolve(muleProject, Arrays.asList(mulePluginDependency));
                        List resolveArtifactDependencies = mavenClient.resolveArtifactDependencies(pomFile.getLocation().toFile(), configuration.isWithTests(), configuration.isWithProvided(), Optional.empty(), Optional.empty());
                        resolveArtifactDependencies.stream().flatMap(dependency2 -> {
                            if (this.dependencyMatches(mulePluginDependency, (BundleDependency)dependency2)) {
                                Stream<BundleDependency> original = Stream.of(dependency2);
                                Stream<BundleDependency> noneMulePluginTransitiveDeps = this.getNoneMulePluginTransitiveDependencies((BundleDependency)dependency2);
                                return Stream.concat(original, noneMulePluginTransitiveDeps);
                            }
                            return Stream.of(dependency2);
                        }).map(artifact -> this.resolveProvidedBundleDescriptor(mavenClient, (BundleDependency)artifact)).collect(Collectors.toCollection(() -> bundleDependencies));
                    }
                    catch (Exception e) {
                        if (e.getCause() instanceof DependencyResolutionException) {
                            DependencyResolutionException exc = (DependencyResolutionException)e.getCause();
                            throw exc;
                        }
                        results.add(DependencyResolutionResult.builder().withDependency(mulePluginDependency).withException(e).build());
                        this.safeDelete(pomFile);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    this.safeDelete(pomFile);
                    throw throwable;
                }
                this.safeDelete(pomFile);
            }
            bundleDependencies.stream().map(descriptor -> this.getResult((BundleDependency)descriptor, mulePluginDependencies)).forEach(results::add);
        }
        return results;
    }

    private Stream<BundleDependency> getNoneMulePluginTransitiveDependencies(BundleDependency item) {
        return item.getTransitiveDependencies().stream().filter(dep -> dep.getDescriptor().getClassifier().map("mule-plugin"::equals).orElse(false) == false);
    }

    private boolean dependencyMatches(MavenDependency mavenDependency, BundleDependency item) {
        BundleDescriptor descriptor = item.getDescriptor();
        return descriptor.getArtifactId().equals(mavenDependency.getArtifactId()) && descriptor.getGroupId().equals(mavenDependency.getGroupId()) && descriptor.getVersion().equals(mavenDependency.getVersion());
    }

    private List<DependencyResolutionResult> doResolveDependencies(IMuleProject muleProject, Collection<MavenDependency> dependencies, DependencyResolutionConfiguration configuration, MavenClient mavenClient) throws DependencyResolutionException {
        List<MavenDependency> notPluginDependencies = dependencies.stream().filter(dep -> !MavenUtils.isMulePlugin(dep)).collect(Collectors.toList());
        if (notPluginDependencies.isEmpty()) {
            return Collections.emptyList();
        }
        IFile pomFile = null;
        try {
            pomFile = this.getPomFileToResolve(muleProject, notPluginDependencies);
            List resolveArtifactDependencies = mavenClient.resolveArtifactDependencies(pomFile.getLocation().toFile(), configuration.isWithTests(), configuration.isWithProvided(), Optional.empty(), Optional.empty());
            List<DependencyResolutionResult> list = resolveArtifactDependencies.stream().map(artifact -> this.resolveProvidedBundleDescriptor(mavenClient, (BundleDependency)artifact)).filter(descriptor -> descriptor.getBundleUri() != null).map(descriptor -> this.getResult((BundleDependency)descriptor, (Collection<MavenDependency>)notPluginDependencies)).collect(Collectors.toList());
            return list;
        }
        catch (IOException | CoreException e) {
            String message = "Could not create a temporary pom.xml file to resolve dependencies for project " + muleProject.getName();
            IllegalStateException exception = new IllegalStateException(message, e);
            List<DependencyResolutionResult> list = notPluginDependencies.stream().map(d -> DependencyResolutionResult.builder().withDependency((MavenDependency)d).withException(exception).build()).collect(Collectors.toList());
            return list;
        }
        catch (Exception e) {
            if (e.getCause() instanceof org.eclipse.aether.resolution.DependencyResolutionException) {
                org.eclipse.aether.resolution.DependencyResolutionException exc = (org.eclipse.aether.resolution.DependencyResolutionException)e.getCause();
                throw new DependencyResolutionException(exc.getMessage(), (Throwable)exc);
            }
            String message = "Could not create a temporary pom.xml file to resolve dependencies for project " + muleProject.getName();
            IllegalStateException exception = new IllegalStateException(message, e);
            List<DependencyResolutionResult> list = notPluginDependencies.stream().map(d -> DependencyResolutionResult.builder().withDependency((MavenDependency)d).withException(exception).build()).collect(Collectors.toList());
            return list;
        }
        finally {
            this.safeDelete(pomFile);
        }
    }

    private void safeDelete(IFile pomFile) {
        if (pomFile != null) {
            SafeRunner.run(() -> pomFile.delete(true, null));
        }
    }

    private IFile getPomFileToResolve(IMuleProject muleProject, Collection<MavenDependency> dependencies) throws CoreException, IOException {
        byte[] newPomFileContents = MavenResourceUtils.getNewPomFileContents(false, MuleProjectKind.APPLICATION, muleProject.getServerDefinition(), AUX_MAVEN_MODEL);
        IFile pomFileToResolve = InMemoryFile.createInMemoryFile((File)this.createTempPomFile(muleProject));
        pomFileToResolve.setContents((InputStream)new ByteArrayInputStream(newPomFileContents), true, false, null);
        DefaultPomFileHandler pomFileHandler = new DefaultPomFileHandler(pomFileToResolve);
        pomFileHandler.loadPom();
        dependencies.stream().map(MavenCore::convert).forEach(dep -> pomFileHandler.addDependency((Dependency)dep));
        this.deleteRepositories(pomFileHandler);
        pomFileHandler.writeChanges();
        return pomFileToResolve;
    }

    private File createTempPomFile(IMuleProject muleProject) throws IOException {
        File tempPomFile = new File(muleProject.getLocation().toFile(), this.getTempPomFileName());
        tempPomFile.createNewFile();
        return tempPomFile;
    }

    private void deleteRepositories(DefaultPomFileHandler pomFileHandler) {
        try {
            pomFileHandler.edit(ROOT_NODE_EXPRESSION).getOrCreateElement(REPOSITORIES_TAG_NAME).remove();
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new RuntimeException("Unexpected xpath expression trying to remove repositories from temporary pom.xml file");
        }
    }

    private String getTempPomFileName() {
        return "." + String.valueOf(UUID.randomUUID()) + ".pom";
    }

    private BundleDependency resolveProvidedBundleDescriptor(MavenClient mavenClient, BundleDependency artifact) {
        if (artifact.getScope().equals((Object)BundleScope.PROVIDED)) {
            BundleDependency res = mavenClient.resolveBundleDescriptor(artifact.getDescriptor());
            Optional classifier = artifact.getDescriptor().getClassifier();
            if (classifier.isPresent() && ((String)classifier.get()).equals("mule-domain")) {
                mavenClient.resolveBundleDescriptorDependencies(false, artifact.getDescriptor());
            }
            return res;
        }
        return artifact;
    }

    @Override
    public List<DependencyResolutionResult> resolveDependencies(IMuleProject muleProject, Collection<MavenDependency> dependencies, IProgressMonitor monitor) throws DependencyResolutionException {
        return this.resolveDependencies(muleProject, dependencies, DependencyResolutionConfiguration.createDefault(), monitor);
    }

    protected MavenClient getMavenClient(IMuleProject muleProject) {
        MavenConfiguration configuration = this.getConfiguration(muleProject);
        MuleMavenClient mavenClient = new MuleMavenClient(configuration);
        mavenClient.setSessionConfigurator(this.sessionConfigurator);
        return mavenClient;
    }

    private DependencyResolutionResult getResult(BundleDependency result, Collection<MavenDependency> requestDependencies) {
        return DependencyResolutionResult.builder().withDependency(this.getDependency(result, requestDependencies)).withResult(new File(result.getBundleUri())).build();
    }

    private MavenDependency getDependency(BundleDependency result, Collection<MavenDependency> originalDependencies) {
        BundleDescriptor descriptor = result.getDescriptor();
        return this.getMavenDependency(result, originalDependencies).orElseGet(() -> {
            PojoMavenDependencyBuilder builder = (PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(descriptor.getGroupId())).withArtifactId(descriptor.getArtifactId())).withVersion(Optional.ofNullable(descriptor.getBaseVersion()).orElse(descriptor.getVersion()))).withType(descriptor.getType())).withScope(MavenDependency.Scope.value(result.getScope().name()));
            descriptor.getClassifier().ifPresent(classifier -> {
                PojoMavenDependencyBuilderBase pojoMavenDependencyBuilderBase = builder.withClassifier((String)classifier);
            });
            return builder.build();
        });
    }

    private Optional<MavenDependency> getMavenDependency(BundleDependency result, Collection<MavenDependency> originalDependencies) {
        Map originalDependenciesMap = originalDependencies.stream().collect(Collectors.toMap(MavenUtils::getGAT, Function.identity()));
        return Optional.ofNullable((MavenDependency)originalDependenciesMap.get(result.getDescriptor().getGroupId() + ":" + result.getDescriptor().getArtifactId() + ":" + result.getDescriptor().getType()));
    }

    private MavenConfiguration getConfiguration(IMuleProject muleProject) {
        return MavenClientFactory.getConfiguration(muleProject, this.baseConfiguration, this.settings);
    }
}

