/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.maven.model.building.DefaultModelBuilderFactory;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.building.ModelSource;
import org.apache.maven.model.building.StringModelSource;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectModelResolver;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.tooling.core.m2.internal.Booter;
import org.mule.tooling.core.m2.internal.IMavenModelReader;
import org.mule.tooling.core.m2.internal.MavenCore;

public class MavenModelReader
implements IMavenModelReader {
    static final String PROPERTY_JAVA_VERSION = "java.version";
    public static final String SYSTEM_PROPERTY_BASE = "org.mule.tooling.core.m2.internal.modelcache";
    public static final String CACHE_SIZE_SYSTEM_PROPERTY = "org.mule.tooling.core.m2.internal.modelcache.size";
    public static final String ENTRY_TIMEOUT_SYSTEM_PROPERTY = "org.mule.tooling.core.m2.internal.modelcache.timeout";
    public static final String DEFAULT_CACHE_SIZE = "512";
    public static final String DEFAULT_ENTRY_TIMEOUT = "1";
    private static final DefaultModelBuilderFactory FACTORY = new DefaultModelBuilderFactory();
    private static final RemoteRepositoryManager REMOTE_REPOSITORY_MANAGER = (RemoteRepositoryManager)MavenRepositorySystemUtils.newServiceLocator().getService(RemoteRepositoryManager.class);
    private final ModelCache modelCache;

    @Inject
    public MavenModelReader(ModelCache modelCache) {
        this.modelCache = modelCache;
    }

    @Override
    public ModelBuildingResult readModel(InputStream pomFileContents, List<RemoteRepository> remoteRepos, Properties properties) throws ModelBuildingException, IOException {
        RepositorySystem system = Booter.newRepositorySystem();
        ModelBuildingRequest buildingModelRequest = this.getRequest(remoteRepos, system, properties);
        buildingModelRequest.setModelSource((ModelSource)new StringModelSource((CharSequence)IOUtils.toString((InputStream)pomFileContents)));
        try {
            ModelBuildingResult modelBuildingResult = this.readModel(buildingModelRequest);
            return modelBuildingResult;
        }
        finally {
            system.shutdown();
        }
    }

    @Override
    public ModelBuildingResult readModel(File pomFile, List<RemoteRepository> remoteRepos, Properties properties) throws ModelBuildingException, IOException {
        RepositorySystem system = Booter.newRepositorySystem();
        ModelBuildingRequest buildingModelRequest = this.getRequest(remoteRepos, system, properties);
        buildingModelRequest.setPomFile(pomFile);
        try {
            ModelBuildingResult modelBuildingResult = this.readModel(buildingModelRequest);
            return modelBuildingResult;
        }
        finally {
            system.shutdown();
        }
    }

    private ModelBuildingResult readModel(ModelBuildingRequest buildingModelRequest) throws ModelBuildingException {
        ModelBuildingResult result = FACTORY.newInstance().build(buildingModelRequest);
        if (result.getEffectiveModel() != null) {
            return result;
        }
        throw new ModelBuildingException(result);
    }

    private ModelBuildingRequest getRequest(List<RemoteRepository> remoteRepos, RepositorySystem system, Properties properties) {
        DefaultRepositorySystemSession session = Booter.newRepositorySystemSession(system, MavenCore.getM2repoPath());
        Properties systemProperties = (Properties)System.getProperties().clone();
        Object javaVersion = properties.remove(PROPERTY_JAVA_VERSION);
        if (javaVersion != null) {
            systemProperties.put(PROPERTY_JAVA_VERSION, javaVersion);
        }
        DefaultModelBuildingRequest buildingModelRequest = new DefaultModelBuildingRequest();
        buildingModelRequest.setProcessPlugins(false);
        buildingModelRequest.setTwoPhaseBuilding(false);
        buildingModelRequest.setModelCache(this.modelCache);
        buildingModelRequest.setUserProperties(properties);
        buildingModelRequest.setSystemProperties(systemProperties);
        buildingModelRequest.setModelResolver((ModelResolver)this.createModelResolver(system, session, remoteRepos));
        return buildingModelRequest;
    }

    private ProjectModelResolver createModelResolver(RepositorySystem system, DefaultRepositorySystemSession session, List<RemoteRepository> remoteRepos) {
        return new ProjectModelResolver((RepositorySystemSession)session, new RequestTrace(null), system, REMOTE_REPOSITORY_MANAGER, remoteRepos, ProjectBuildingRequest.RepositoryMerging.REQUEST_DOMINANT, null);
    }
}

