/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Activation;
import org.apache.maven.model.ActivationFile;
import org.apache.maven.model.ActivationOS;
import org.apache.maven.model.ActivationProperty;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.profile.DefaultProfileActivationContext;
import org.apache.maven.model.profile.DefaultProfileSelector;
import org.apache.maven.model.profile.ProfileActivationContext;
import org.apache.maven.model.profile.activation.FileProfileActivator;
import org.apache.maven.model.profile.activation.JdkVersionProfileActivator;
import org.apache.maven.model.profile.activation.OperatingSystemProfileActivator;
import org.apache.maven.model.profile.activation.ProfileActivator;
import org.apache.maven.model.profile.activation.PropertyProfileActivator;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.crypto.DefaultSettingsDecrypter;
import org.apache.maven.settings.crypto.DefaultSettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionRequest;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.JavaCore;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.client.api.model.RemoteRepository;
import org.mule.maven.client.internal.DefaultSettingsSupplierFactory;
import org.mule.maven.client.internal.MavenEnvironmentVariables;
import org.mule.tooling.core.CorruptedInstallationException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.m2.M2RepoNotFoundException;
import org.mule.tooling.core.m2.MavenCorePreferences;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.MavenResourceUtils;
import org.mule.tooling.core.m2.PomDefaultsHandlerManager;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.RepositoryFactory;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.Booter;
import org.mule.tooling.core.m2.internal.IMavenModelReader;
import org.mule.tooling.core.m2.internal.MavenModelReaderFactory;
import org.mule.tooling.core.m2.internal.repo.MavenRepositoryExtension;
import org.mule.tooling.core.m2.internal.settings.LoginSettingsFileTransformer;
import org.mule.tooling.core.m2.internal.settings.MavenSettingsHelper;
import org.mule.tooling.core.m2.internal.settings.ProxySettingsFileTransformer;
import org.mule.tooling.core.m2.internal.settings.SettingsFileTransformer;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.utils.EclipseContextHelper;
import org.mule.tooling.utils.Pair;
import org.mule.tooling.utils.value.AbstractEvaluationContext;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.EvaluationDebugger;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.caching.CachePolicy;
import org.mule.tooling.utils.value.caching.FileBasedCachePolicy;
import org.mule.tooling.utils.value.caching.FileValueCachePolicy;
import org.mule.tooling.utils.value.caching.FileValueReferenceCachePolicy;
import org.mule.tooling.utils.value.caching.ValueBasedCachePolicy;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.xml.sax.SAXException;

public class MavenCore {
    private static final String SYS_PROP_IGNORE_ARTIFACT_DESCRIPTOR_REPOSITORIES = "org.mule.tooling.ignore_artifact_descriptor_repositories";
    private static final String SYS_PROP_ONLINE_MODE = "org.mule.tooling.online_mode";
    private static final String SYS_PROP_M2_REPO = "org.mule.tooling.m2_repo";
    public static final String M2_REPO = "M2_REPO";
    private static final String DEBUG_VALUES = "/debug/maven-values";
    private static volatile boolean repositoryPopulated = false;
    private static volatile Object repositoryPopulationLock = new Object();
    private static final EvaluationDebugger.Factory debuggerFactory = EvaluationDebugger.tracerBasedFactory(MuleCorePlugin::debugTracer, (String)"org.mule.tooling.core", (String)"/debug/maven-values");
    private static final Values values = (Values)new Values(new Values.Requests(){}).debugging(debuggerFactory);

    public static IMavenModelReader getMavenModelReader() {
        return EclipseContextHelper.createFromStudioContext(MavenModelReaderFactory.class).getMavenModelReader();
    }

    public static String getM2repoPath() {
        return values.getM2RepoPath();
    }

    public static Settings getUserSettings() {
        return values.getTransformedUserSettings();
    }

    public static File getUserSettingsFile() {
        return values.getTransformedUserSettingsFile();
    }

    public static Optional<File> getOriginalUserSettingsFile() {
        return values.getOriginalUserSettingsFile();
    }

    public static Settings getGlobalSettings() {
        return values.getGlobalSettings();
    }

    public static Optional<File> getGlobalSettingsFile() {
        return values.getGlobalSettingsFile();
    }

    private static File generateM2RepoDir(java.nio.file.Path basePath) {
        return MavenCore.ensureDirectoryExists(basePath.resolve(Paths.get(".m2", "repository")).toFile());
    }

    private static File ensureDirectoryExists(File potentialDir) {
        if (!potentialDir.exists()) {
            potentialDir.mkdirs();
            if (!potentialDir.exists()) {
                throw new M2RepoNotFoundException(String.valueOf(potentialDir) + " does not exist and could not be created");
            }
        } else if (!potentialDir.isDirectory()) {
            throw new M2RepoNotFoundException(String.valueOf(potentialDir) + " exists but is not a directory");
        }
        return potentialDir;
    }

    private static boolean isValidPath(String path) {
        return path == null || path.isEmpty() ? false : new File(path).exists();
    }

    public static MavenConfiguration newUserMavenConfiguration() {
        return MavenCore.newUserMavenConfiguration(Collections.emptyList(), MavenCore.getUserSettingsFile(), MavenCore.getMavenSettingsSecurity());
    }

    public static MavenConfiguration newLocalRepositoryMavenConfiguration() {
        MavenConfiguration.MavenConfigurationBuilder builder = MavenConfiguration.newMavenConfigurationBuilder();
        MavenCore.setLocation(builder, Optional.empty());
        MavenCore.setIgnoreArtifactDescriptorRepositories(builder, true);
        return builder.build();
    }

    public static MavenConfiguration newUserMavenConfiguration(File settingsFile) {
        return MavenCore.newUserMavenConfiguration(Collections.emptyList(), settingsFile, MavenCore.getMavenSettingsSecurity());
    }

    public static MavenConfiguration newUserMavenConfiguration(List<Repository> repositories) {
        MavenConfiguration.MavenConfigurationBuilder builder = MavenCore.defaultMavenConfigurationBuilder();
        MavenCore.setRepositories(builder, repositories);
        MavenCore.setLocation(builder, Optional.empty());
        return builder.build();
    }

    public static MavenConfiguration newUserMavenConfiguration(List<Repository> repositories, File settingsFile, Optional<File> settingsSecurityFile) {
        MavenConfiguration.MavenConfigurationBuilder builder = MavenConfiguration.newMavenConfigurationBuilder();
        MavenCore.setIgnoreArtifactDescriptorRepositories(builder, MavenCore.isIgnoringProjectRepositories());
        MavenCore.setSettingFiles(builder, MavenCore.getGlobalSettingsFile(), Optional.of(settingsFile), settingsSecurityFile);
        MavenCore.setRepositories(builder, repositories);
        MavenCore.setLocation(builder, Optional.empty());
        return builder.build();
    }

    public static MavenConfiguration newUserMavenConfigurationSnapshotUpdates(boolean forceUpdate, Optional<File> repositoryLocation) {
        MavenConfiguration.MavenConfigurationBuilder builder = MavenCore.defaultMavenConfigurationBuilder();
        MavenCore.setLocation(builder, repositoryLocation);
        MavenCore.setGlobalPolicies(builder, false, forceUpdate);
        return builder.build();
    }

    private static MavenConfiguration.MavenConfigurationBuilder defaultMavenConfigurationBuilder() {
        MavenConfiguration.MavenConfigurationBuilder builder = MavenConfiguration.newMavenConfigurationBuilder();
        MavenCore.setIgnoreArtifactDescriptorRepositories(builder, MavenCore.isIgnoringProjectRepositories());
        MavenCore.setSettingFiles(builder, MavenCore.getGlobalSettingsFile(), Optional.of(MavenCore.getUserSettingsFile()), MavenCore.getMavenSettingsSecurity());
        return builder;
    }

    private static void setLocation(MavenConfiguration.MavenConfigurationBuilder builder, Optional<File> repositoryLocation) {
        builder.localMavenRepositoryLocation(repositoryLocation.orElse(MavenCore.getM2RepoFile()));
    }

    private static void setSettingFiles(MavenConfiguration.MavenConfigurationBuilder builder, Optional<File> globalSettingsFile, Optional<File> settingsFile, Optional<File> settingsSecurityFile) {
        globalSettingsFile.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).globalSettingsLocation(arg_0));
        settingsFile.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).userSettingsLocation(arg_0));
        settingsSecurityFile.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)builder).settingsSecurityLocation(arg_0));
    }

    private static void setGlobalPolicies(MavenConfiguration.MavenConfigurationBuilder builder, boolean forcePolicyUpdateNever, boolean forcePolicyUpdateAlways) {
        builder.forcePolicyUpdateNever(forcePolicyUpdateNever);
        builder.forcePolicyUpdateAlways(forcePolicyUpdateAlways);
    }

    private static void setIgnoreArtifactDescriptorRepositories(MavenConfiguration.MavenConfigurationBuilder builder, boolean ignoreArtifactDescriptorRepositories) {
        builder.ignoreArtifactDescriptorRepositories(ignoreArtifactDescriptorRepositories);
    }

    private static void setRepositories(MavenConfiguration.MavenConfigurationBuilder builder, List<Repository> repositories) {
        for (Repository repository : repositories) {
            try {
                URL repoUrl = new URL(repository.getUrl());
                builder.remoteRepository(new RemoteRepository.RemoteRepositoryBuilder().id(repository.getId()).url(repoUrl).releasePolicy(Optional.ofNullable(repository.getReleasesPolicy()).orElse(RepositoryFactory.getDefaultReleasePolicy())).snapshotPolicy(Optional.ofNullable(repository.getSnapshotsPolicy()).orElse(RepositoryFactory.getDefaultSnapshotPolicy())).build());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
    }

    public static Optional<File> getMavenSettingsSecurity() {
        DefaultSettingsSupplierFactory settingsSupplierFactory = new DefaultSettingsSupplierFactory(new MavenEnvironmentVariables());
        boolean settingsSecurityOverride = MavenCorePreferences.isSettingsSecurityOverriden();
        if (settingsSecurityOverride) {
            System.setProperty("settings.security", MavenCorePreferences.getSettingsSecurityPath());
        }
        return settingsSupplierFactory.environmentSettingsSecuritySupplier();
    }

    public static File getM2RepoFile() {
        return new File(MavenCore.getM2repoPath());
    }

    public static boolean isOfflineMode() {
        return System.getProperty(SYS_PROP_ONLINE_MODE) == null || !Boolean.getBoolean(SYS_PROP_ONLINE_MODE);
    }

    public static boolean isIgnoringProjectRepositories() {
        return Boolean.getBoolean(SYS_PROP_IGNORE_ARTIFACT_DESCRIPTOR_REPOSITORIES);
    }

    public static String getGA(org.eclipse.aether.artifact.Artifact dependency2) {
        return dependency2.getGroupId() + ":" + dependency2.getArtifactId();
    }

    public static String getGA(Artifact dependency2) {
        return dependency2.getGroupId() + ":" + dependency2.getArtifactId();
    }

    public static String getGA(Dependency dependency2) {
        return dependency2.getGroupId() + ":" + dependency2.getArtifactId();
    }

    public static String getCoords(MavenDependency dep) {
        return MavenUtils.getGA(dep) + ":" + dep.getVersion();
    }

    public static Model getPomModel(IFile pomFile) throws FileNotFoundException, IOException {
        return MavenCore.getPomModel(pomFile.getLocation().toFile());
    }

    public static Model getPomModel(File pomFile) throws FileNotFoundException, IOException {
        Model model = null;
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream pomStream = new FileInputStream(pomFile);){
            try {
                model = new MavenXpp3Reader().read((InputStream)pomStream);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException("Parse error reading " + pomFile.getAbsolutePath(), e);
            }
            model.setPomFile(pomFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return model;
    }

    public static RemoteRepository getRemoteRepository(Settings settings, Repository repository) {
        return MavenCore.buildRepository(settings, repository.getId(), null, repository.getUrl());
    }

    public static RemoteRepository getRemoteRepository(Settings settings, org.apache.maven.settings.Repository x, ProxySelector proxySelector) {
        return MavenCore.buildRepository(settings, x.getId(), x.getLayout(), x.getUrl(), proxySelector);
    }

    public static RemoteRepository getRemoteRepository(Settings settings, org.apache.maven.model.Repository repository) {
        return MavenCore.buildRepository(settings, repository.getId(), repository.getLayout(), repository.getUrl());
    }

    private static RemoteRepository getRemoteRepository(Settings settings, RemoteRepository repository, ProxySelector proxySelector) {
        return MavenCore.buildRepository(settings, repository.getId(), repository.getContentType(), repository.getUrl(), proxySelector);
    }

    private static RemoteRepository getRemoteRepository(Settings settings, RemoteRepository repository) {
        return MavenCore.buildRepository(settings, repository.getId(), repository.getContentType(), repository.getUrl());
    }

    private static RemoteRepository buildRepository(Settings settings, String id, String layout, String url) {
        return MavenCore.buildRepository(settings, id, layout, url, null);
    }

    private static RemoteRepository buildRepository(Settings settings, String id, String layout, String url, ProxySelector proxySelector) {
        Server server;
        RemoteRepository.Builder builder = new RemoteRepository.Builder(id, layout, url);
        if (settings != null && (server = settings.getServer(id)) != null) {
            builder.setAuthentication(new AuthenticationBuilder().addUsername(server.getUsername()).addPassword(server.getPassword()).build());
        }
        builder.setReleasePolicy(Booter.getReleasePolicy());
        builder.setSnapshotPolicy(Booter.getSnapshotPolicy());
        RemoteRepository remoteRepository = builder.build();
        if (proxySelector != null) {
            builder.setProxy(proxySelector.getProxy(remoteRepository));
            remoteRepository = builder.build();
        }
        return remoteRepository;
    }

    public static Settings decryptIfNecessary(Settings settings) {
        Optional<File> securitySettings = MavenCore.getMavenSettingsSecurity();
        if (securitySettings.isPresent()) {
            DefaultSecDispatcher secDispatcher = null;
            secDispatcher = new DefaultSecDispatcher((PlexusCipher)new DefaultPlexusCipher());
            secDispatcher.setConfigurationFile(securitySettings.get().getAbsolutePath());
            DefaultSettingsDecryptionRequest defaultSettingsDecryptionRequest = new DefaultSettingsDecryptionRequest();
            defaultSettingsDecryptionRequest.setProxies(settings.getProxies());
            defaultSettingsDecryptionRequest.setServers(settings.getServers());
            SettingsDecryptionResult result = new DefaultSettingsDecrypter((SecDispatcher)secDispatcher).decrypt((SettingsDecryptionRequest)defaultSettingsDecryptionRequest);
            settings.setProxies(result.getProxies());
            settings.setServers(result.getServers());
        }
        return settings;
    }

    private static Activation createModelActivation(org.apache.maven.settings.Activation activation) {
        Activation modelActivation = new Activation();
        modelActivation.setActiveByDefault(activation.isActiveByDefault());
        if (activation.getFile() != null) {
            ActivationFile activationFile = new ActivationFile();
            activationFile.setExists(activation.getFile().getExists());
            activationFile.setMissing(activation.getFile().getMissing());
            modelActivation.setFile(activationFile);
        }
        modelActivation.setJdk(activation.getJdk());
        if (activation.getOs() != null) {
            ActivationOS os = new ActivationOS();
            os.setArch(activation.getOs().getArch());
            os.setFamily(activation.getOs().getFamily());
            os.setName(activation.getOs().getName());
            os.setVersion(activation.getOs().getVersion());
            modelActivation.setOs(os);
        }
        if (activation.getProperty() != null) {
            ActivationProperty property = new ActivationProperty();
            property.setName(activation.getProperty().getName());
            property.setValue(activation.getProperty().getValue());
            modelActivation.setProperty(property);
        }
        return modelActivation;
    }

    private static List<org.apache.maven.model.Profile> createModelProfiles(List<Profile> profiles) {
        ArrayList<org.apache.maven.model.Profile> modelProfiles = new ArrayList<org.apache.maven.model.Profile>();
        for (Profile profile : profiles) {
            org.apache.maven.model.Profile modelProfile = new org.apache.maven.model.Profile();
            modelProfile.setId(profile.getId());
            if (profile.getActivation() != null) {
                modelProfile.setActivation(MavenCore.createModelActivation(profile.getActivation()));
            }
            modelProfiles.add(modelProfile);
        }
        return modelProfiles;
    }

    public static List<RemoteRepository> getRepositories(Settings settings) {
        return MavenCore.getRepositories(settings, null);
    }

    public static List<RemoteRepository> getRepositories(Settings originalSettings, File rootProject) {
        Settings settings = MavenCore.decryptIfNecessary(originalSettings);
        ArrayList<RemoteRepository> repos = new ArrayList<RemoteRepository>();
        List activeProfiles = settings.getActiveProfiles();
        DefaultProfileSelector selector = new DefaultProfileSelector();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(activeProfiles);
        context.setSystemProperties(System.getProperties());
        if (rootProject != null) {
            context.setProjectDirectory(rootProject);
        }
        selector.addProfileActivator((ProfileActivator)new JdkVersionProfileActivator());
        selector.addProfileActivator((ProfileActivator)new OperatingSystemProfileActivator());
        selector.addProfileActivator((ProfileActivator)new PropertyProfileActivator());
        selector.addProfileActivator((ProfileActivator)new FileProfileActivator());
        List profiles = selector.getActiveProfiles(MavenCore.createModelProfiles(settings.getProfiles()), (ProfileActivationContext)context, request -> MuleCorePlugin.logError(request.getMessage()));
        DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
        DefaultProxySelector proxySelector = MavenCore.getProxySelector(settings);
        List mirrors = settings.getMirrors();
        mirrors.stream().forEach(mirror -> {
            DefaultMirrorSelector defaultMirrorSelector2 = mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.isBlocked(), mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        });
        profiles.forEach(activeProfile -> {
            Profile profile = (Profile)settings.getProfilesAsMap().get(activeProfile.getId());
            if (profile != null) {
                profile.getRepositories().stream().forEach(x -> {
                    RemoteRepository remoteRepository = MavenCore.getRemoteRepository(settings, x, (ProxySelector)proxySelector);
                    RemoteRepository mirror = mirrorSelector.getMirror(remoteRepository);
                    if (mirror != null) {
                        RemoteRepository mirrorRepository = MavenCore.getRemoteRepository(settings, mirror);
                        if (mirrorRepository != null) {
                            repos.add(MavenCore.getRemoteRepository(settings, mirrorRepository, (ProxySelector)proxySelector));
                        } else {
                            repos.add(remoteRepository);
                        }
                    } else {
                        repos.add(remoteRepository);
                    }
                });
            }
        });
        return repos;
    }

    public static Properties getPropertiesSetting(Settings settings) {
        Properties properties = new Properties();
        List activeProfiles = settings.getActiveProfiles();
        DefaultProfileSelector selector = new DefaultProfileSelector();
        DefaultProfileActivationContext context = new DefaultProfileActivationContext();
        context.setActiveProfileIds(activeProfiles);
        context.setSystemProperties(System.getProperties());
        selector.addProfileActivator((ProfileActivator)new FileProfileActivator());
        List profiles = selector.getActiveProfiles(MavenCore.createModelProfiles(settings.getProfiles()), (ProfileActivationContext)context, request -> MuleCorePlugin.logError(request.getMessage()));
        profiles.forEach(activeProfile -> {
            Profile profile = (Profile)settings.getProfilesAsMap().get(activeProfile.getId());
            if (profile != null) {
                properties.putAll((Map<?, ?>)profile.getProperties());
            }
        });
        return properties;
    }

    private static DefaultProxySelector getProxySelector(Settings settings) {
        DefaultProxySelector selector = new DefaultProxySelector();
        settings.getProxies().stream().forEach(p -> {
            if (p.isActive()) {
                Authentication authentication = new AuthenticationBuilder().addUsername(p.getUsername()).addPassword(p.getPassword()).build();
                Proxy proxy = new Proxy(p.getProtocol(), p.getHost(), p.getPort(), authentication);
                selector.add(proxy, p.getNonProxyHosts());
            }
        });
        return selector;
    }

    private static File applySettingsTransformers(MavenSettingsHelper settingsHelper, List<SettingsFileTransformer<?>> transformers) throws IOException {
        List<SettingsFileTransformer<?>> enabledTransformers = MavenCore.getEnabledSettingsTransformers(settingsHelper, transformers);
        if (!enabledTransformers.isEmpty()) {
            return MavenCore.getTransformedSettingsFile(settingsHelper, enabledTransformers);
        }
        return settingsHelper.getSourceFile();
    }

    private static List<SettingsFileTransformer<?>> getEnabledSettingsTransformers(MavenSettingsHelper settingsHelper, List<SettingsFileTransformer<?>> settingsTransformers) {
        return settingsTransformers.stream().filter(t -> t.shouldTransform(settingsHelper)).collect(Collectors.toList());
    }

    private static File getTransformedSettingsFile(MavenSettingsHelper transformingHelper, List<SettingsFileTransformer<?>> transformers) throws IOException {
        for (SettingsFileTransformer<?> transformer : transformers) {
            transformingHelper = transformer.transform(transformingHelper);
        }
        File tempSettingsFile = MavenSettingsHelper.createTempFile();
        tempSettingsFile.deleteOnExit();
        transformingHelper.write(tempSettingsFile);
        return tempSettingsFile;
    }

    private static List<SettingsFileTransformer<?>> getSettingsTransformers() {
        return Arrays.asList(new LoginSettingsFileTransformer(), new ProxySettingsFileTransformer());
    }

    private static void handleSettingsTransformationError(File settingsFile, Exception e) {
        MuleCorePlugin.logError("There was an error adding information to base settings file at: " + String.valueOf(settingsFile) + ".\nUsing base settings file.", e);
    }

    public static Pair<File, Settings> getSettingsWithFile(File settingsFile) {
        return Pair.of((Object)settingsFile, (Object)MavenCore.getSettings(settingsFile));
    }

    public static Settings getSettings(File userSettings) {
        Settings settings = null;
        DefaultSettingsBuilderFactory settingsFactory = new DefaultSettingsBuilderFactory();
        DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
        if (userSettings.exists()) {
            try {
                settingsRequest.setUserSettingsFile(userSettings);
                SettingsBuildingResult result = settingsFactory.newInstance().build((SettingsBuildingRequest)settingsRequest);
                if (result.getEffectiveSettings() != null) {
                    settings = result.getEffectiveSettings();
                } else {
                    MuleCorePlugin.logWarning("There was a problem loading the user settings.xml file", new SettingsBuildingException(result.getProblems()));
                }
            }
            catch (SettingsBuildingException e) {
                MuleCorePlugin.logWarning("There was a problem loading the user settings.xml file", e);
            }
        }
        return settings;
    }

    public static void appendExceptions(StringBuilder stringBuilder, Map<MavenDependency, List<Exception>> exceptionsMap) {
        Set<Map.Entry<MavenDependency, List<Exception>>> entrySet = exceptionsMap.entrySet();
        for (Map.Entry<MavenDependency, List<Exception>> entry : entrySet) {
            MavenDependency dep = entry.getKey();
            StringWriter errorsWriter = new StringWriter();
            entry.getValue().forEach(e -> e.printStackTrace(new PrintWriter(errorsWriter)));
            stringBuilder.append("Resolving dependency ").append(MavenUtils.getGA(dep));
            stringBuilder.append(" found the following exceptions:").append(System.lineSeparator());
            stringBuilder.append(errorsWriter.toString());
        }
    }

    private static Optional<String> getValidLocalRepository(Settings userSettings) {
        String userSettingsRepositoryPath = userSettings.getLocalRepository();
        if (userSettingsRepositoryPath != null && !userSettingsRepositoryPath.isEmpty() && new File(userSettingsRepositoryPath).exists()) {
            return Optional.of(userSettingsRepositoryPath);
        }
        return Optional.empty();
    }

    public static File getFileInLocalRepo(MavenDependency dependency2) {
        return new File(MavenCore.getM2repoPath() + File.separator + MavenResourceUtils.getRepositoryPath(dependency2, File.separator));
    }

    public static <T> T runWithPopulatedLocalRepository(Supplier<T> callable) {
        try {
            return MavenCore.doRunWithPopulatedLocalRepository(callable);
        }
        catch (CorruptedInstallationException corruptedInstallationException) {
            MavenRepositoryExtension.getExtensions().forEach(t -> {
                try {
                    t.clearInstallationInfo();
                }
                catch (IOException e) {
                    MuleCorePlugin.logError("An error ocurred while trying to fix a corrupted installation. If the problem persist try reseting the installation from the Preferences > Anypoint Studio > Installation page.", e);
                }
            });
            repositoryPopulated = false;
            return MavenCore.doRunWithPopulatedLocalRepository(callable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T doRunWithPopulatedLocalRepository(Supplier<T> callable) {
        if (!repositoryPopulated) {
            Object object = repositoryPopulationLock;
            synchronized (object) {
                if (!repositoryPopulated) {
                    long ini = System.currentTimeMillis();
                    MavenRepositoryExtension.getExtensions().forEach(MavenCore::safeInstall);
                    long durationInMillis = System.currentTimeMillis() - ini;
                    long seconds = durationInMillis / 1000L;
                    AnalyticsRecordsFactory.single(Events.MAVEN_REPOSITORY_POPULATED, "timeInMillis", String.valueOf(durationInMillis)).track();
                    System.out.println("Installed all m2 repository entries in " + seconds + " secs");
                    repositoryPopulated = true;
                }
            }
        }
        return callable.get();
    }

    private static void safeInstall(MavenRepositoryExtension ext) {
        File mavenRepository = MavenCore.getM2RepoFile();
        try {
            ext.installIntoIfRequired(mavenRepository);
        }
        catch (Exception e) {
            MuleCorePlugin.logError("A problem occurred copying Maven repository entries packaged with Studio into " + String.valueOf(mavenRepository), e);
        }
    }

    public static List<RemoteRepository> getUserRepositories() {
        return MavenCore.getUserRepositories(null);
    }

    public static List<RemoteRepository> getUserRepositories(File rootProject) {
        return MavenCore.getRepositories(MavenCore.getUserSettings(), rootProject);
    }

    public static List<RemoteRepository> getGlobalRepositories() {
        return MavenCore.getRepositories(MavenCore.getGlobalSettings());
    }

    public static PomDefaultsHandlerManager getPomDefaultsHandlerManager() {
        return (PomDefaultsHandlerManager)MuleCorePlugin.getStudioContext().get(PomDefaultsHandlerManager.class);
    }

    public static Dependency convert(MavenDependency dependency2) {
        Dependency newDependency = MavenModelHelper.dependency(dependency2.getGroupId(), dependency2.getArtifactId(), dependency2.getVersion());
        MavenDependency.Scope scope = dependency2.getScope();
        newDependency.setScope(scope != null ? scope.asString() : MavenDependency.Scope.COMPILE.asString());
        if (dependency2.getClassifier().isPresent()) {
            newDependency.setClassifier(dependency2.getClassifier().get());
        }
        if (dependency2.getType().isPresent()) {
            newDependency.setType(dependency2.getType().get());
        }
        if (dependency2.isOptional().isPresent()) {
            newDependency.setOptional(dependency2.isOptional().get().booleanValue());
        }
        if (dependency2.getSystemPath().isPresent()) {
            newDependency.setSystemPath(dependency2.getSystemPath().get());
        }
        return newDependency;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markRepoPopulateFlagWith(boolean value) {
        Object object = repositoryPopulationLock;
        synchronized (object) {
            repositoryPopulated = value;
        }
    }

    static /* synthetic */ void access$0(File file, Exception exception) {
        MavenCore.handleSettingsTransformationError(file, exception);
    }

    static /* synthetic */ File access$1(MavenSettingsHelper mavenSettingsHelper, List list) throws IOException {
        return MavenCore.applySettingsTransformers(mavenSettingsHelper, list);
    }

    static /* synthetic */ Optional access$2(Settings settings) {
        return MavenCore.getValidLocalRepository(settings);
    }

    static /* synthetic */ boolean access$3(String string) {
        return MavenCore.isValidPath(string);
    }

    static /* synthetic */ File access$4(java.nio.file.Path path) {
        return MavenCore.generateM2RepoDir(path);
    }

    public static class Values
    extends AbstractEvaluationContext<Requests> {
        private final Value<File> globalSettingsFile = Values.globalSettingsFile();
        private final Value<File> originalUserSettingsFile = Values.originalUserSettingsFile();
        private final Value<File> emptySettingsFile = Values.emptySettingsFile();
        private final Value<File> userSettingsFile = Values.userSettingsFile(this.originalUserSettingsFile, this.emptySettingsFile);
        private final Value<File> transformedUserSettingsFile = this.transformedUserSettingsFile(this.userSettingsFile);
        private final Value<Settings> globalSettings = Values.globalSettings(this.globalSettingsFile);
        private final Value<Settings> originalUserSettings = Values.originalUserSettings(this.originalUserSettingsFile);
        private final Value<Settings> transformedUserSettings = Values.transformedUserSettings(this.transformedUserSettingsFile);
        private final Value<String> localRepositoryFromSettings = Values.localRepositoryFromSettings(this.originalUserSettings, this.globalSettings);
        private final Value<String> m2RepoPath = Values.m2RepoPath(this.localRepositoryFromSettings);

        public Values(Requests outbound) {
            super((EvaluationContext.OutboundRequests)outbound);
        }

        private static Value<File> userSettingsFile(Value<File> originalUserSettingsFile, Value<File> emptySettingsFile) {
            return Value.options((Value[])new Value[]{originalUserSettingsFile, emptySettingsFile});
        }

        private static Value<File> originalUserSettingsFile() {
            return Value.options((Value[])new Value[]{Value.trivial(Requests::getUserSettingsPathFromPreference).required(Requests::isUserSettingsOverriden).mapped(File::new), Value.trivial(Requests::getUserHome).mapped(base -> Path.fromOSString((String)base).append(".m2").append("settings.xml").toFile())}).provided(File::isFile).described();
        }

        private Value<File> transformedUserSettingsFile(Value<File> originalUserSettingsFile) {
            Value cachedOriginalUserSettingsFile = originalUserSettingsFile.cached((CachePolicy)new FileValueCachePolicy());
            return cachedOriginalUserSettingsFile.mapped(Value.unchecked(MavenSettingsHelper::new)).combined(Value.blocking(Requests::getSettingsTransformers), Value.unchecked(MavenCore::access$1)).cached(Arrays.asList(new ValueBasedCachePolicy(Requests::getSettingsTransformerLatestConfigs), new FileValueCachePolicy(), new FileValueReferenceCachePolicy(cachedOriginalUserSettingsFile))).catching(Value.instanceOf(Arrays.asList(IOException.class, SAXException.class)), (exception, context) -> MavenCore.handleSettingsTransformationError((File)context.evaluate(originalUserSettingsFile).get(), exception), originalUserSettingsFile).described();
        }

        private static Value<File> emptySettingsFile() {
            return Value.blocking(MavenResourceUtils::getEmptySettingsFile);
        }

        private static Value<File> globalSettingsFile() {
            return Value.options((Value[])new Value[]{Value.trivial(Requests::getGlobalSettingsPathFromPreference).required(Requests::isGlobalSettingsOverriden).mapped(File::new), Value.trivial(Requests::getMavenPathFromPreference).required(Requests::isEmbeddedMaven).not().provided(String::isEmpty).not().mapped(File::new).provided(File::isDirectory).mapped(baseDir -> new File((File)baseDir, "conf/settings.xml"))}).provided(File::isFile).described();
        }

        private static Value<Settings> originalUserSettings(Value<File> originalUserSettingsFile) {
            return Values.mavenSettings(originalUserSettingsFile).described();
        }

        private static Value<Settings> globalSettings(Value<File> globalSettingsFile) {
            return Values.mavenSettings(globalSettingsFile).described();
        }

        private static Value<Settings> transformedUserSettings(Value<File> transformedUserSettingsFile) {
            return Values.mavenSettings(transformedUserSettingsFile).described();
        }

        private static Value<Settings> mavenSettings(Value<File> settingsFile) {
            return Value.options((Value[])new Value[]{settingsFile, Values.emptySettingsFile()}).mapped(MavenCore::getSettingsWithFile).cached((CachePolicy)new FileBasedCachePolicy(Pair::getLeft)).mapped(Pair::getRight);
        }

        private static Value<String> localRepositoryFromSettings(Value<Settings> originalUserSettings, Value<Settings> globalSettings) {
            return Value.options((Value[])new Value[]{originalUserSettings.mapped(MavenCore::access$2).provided(Optional::isPresent), globalSettings.mapped(MavenCore::access$2).provided(Optional::isPresent)}).mapped(Optional::get).described();
        }

        private static Value<String> m2RepoPath(Value<String> localRepositoryFromSettings) {
            return Value.options((Value[])new Value[]{Value.trivial(Requests::getM2RepoFromSystemProperty).provided(MavenCore::access$3), Value.trivial(Requests::getM2RepoPathFromPreference).required(Requests::isM2RepoOverriden).provided(MavenCore::access$3), localRepositoryFromSettings.provided(String::isEmpty).not(), Value.trivial(Requests::getM2RepoFromClasspathVariable).provided(IPath::isEmpty).not().mapped(IPath::toOSString), Value.trivial(Requests::getM2RepoFromEnvironmentVariable).provided(String::isEmpty).not().mapped(File::new).mapped(File::getPath), Value.trivial(Requests::getUserHome).provided(Objects::nonNull).mapped(File::new).mapped(File::getAbsoluteFile).mapped(File::toPath).mapped(MavenCore::access$4).cached((CachePolicy)new FileValueCachePolicy()).mapped(File::toString), Value.invalid(() -> "Could not compute a M2 repo path")}).cached(Duration.ofSeconds(60L)).described();
        }

        public String getM2RepoPath() {
            return (String)this.evaluate(MavenCore.values.m2RepoPath).get();
        }

        public Optional<File> getOriginalUserSettingsFile() {
            return this.evaluate(MavenCore.values.originalUserSettingsFile);
        }

        public Settings getGlobalSettings() {
            return (Settings)this.evaluate(MavenCore.values.globalSettings).get();
        }

        public Optional<File> getGlobalSettingsFile() {
            return this.evaluate(MavenCore.values.globalSettingsFile);
        }

        public File getTransformedUserSettingsFile() {
            return (File)this.evaluate(MavenCore.values.transformedUserSettingsFile).get();
        }

        public Settings getTransformedUserSettings() {
            return (Settings)this.evaluate(MavenCore.values.transformedUserSettings).get();
        }

        public static interface Requests
        extends EvaluationContext.OutboundRequests {
            default public boolean isUserSettingsOverriden() {
                return MavenCorePreferences.isUserSettingsOverriden();
            }

            default public boolean isGlobalSettingsOverriden() {
                return MavenCorePreferences.isGlobalSettingsOverriden();
            }

            default public String getUserHome() {
                return System.getProperty("user.home");
            }

            default public String getUserSettingsPathFromPreference() {
                return MavenCorePreferences.getUserSettingsPath();
            }

            default public String getGlobalSettingsPathFromPreference() {
                return MavenCorePreferences.getGlobalSettingsPath();
            }

            default public boolean isEmbeddedMaven() {
                return MavenCorePreferences.isEmbeddedMaven();
            }

            default public String getMavenPathFromPreference() {
                return MavenCorePreferences.getMavenPath();
            }

            default public boolean isM2RepoOverriden() {
                return MavenCorePreferences.isM2RepoOverriden();
            }

            default public String getM2RepoPathFromPreference() {
                return MavenCorePreferences.getM2RepoPath();
            }

            default public String getM2RepoFromEnvironmentVariable() {
                return System.getenv(MavenCore.M2_REPO);
            }

            default public IPath getM2RepoFromClasspathVariable() {
                return JavaCore.getClasspathVariable((String)MavenCore.M2_REPO);
            }

            default public String getM2RepoFromSystemProperty() {
                return System.getProperty(MavenCore.SYS_PROP_M2_REPO);
            }

            default public List<SettingsFileTransformer<?>> getSettingsTransformers() {
                return MavenCore.getSettingsTransformers();
            }

            default public List<SettingsFileTransformer.ConfigData> getSettingsTransformerLatestConfigs() {
                return this.getSettingsTransformers().stream().map(SettingsFileTransformer::getLatestConfigData).collect(Collectors.toList());
            }
        }
    }
}

