/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.apache.maven.model.building.ModelCache;

public class GuavaModelCache
implements ModelCache {
    private static final int MAX_CACHE_SIZE = Integer.valueOf(System.getProperty("org.mule.tooling.core.m2.internal.modelcache.size", "512"));
    private static final int ENTRY_TIMEOUT = Integer.valueOf(System.getProperty("org.mule.tooling.core.m2.internal.modelcache.timeout", "1"));
    private final Cache<ModelCacheKey, Object> cache = CacheBuilder.newBuilder().maximumSize((long)MAX_CACHE_SIZE).expireAfterAccess((long)ENTRY_TIMEOUT, TimeUnit.MINUTES).build();

    public Object get(String groupId, String artifactId, String version, String tag) {
        return this.cache.getIfPresent((Object)GuavaModelCache.getKey(groupId, artifactId, version, tag));
    }

    private static ModelCacheKey getKey(String groupId, String artifactId, String version, String tag) {
        return new ModelCacheKey(groupId, artifactId, version, tag);
    }

    public void put(String groupId, String artifactId, String version, String tag, Object data) {
        this.cache.put((Object)GuavaModelCache.getKey(groupId, artifactId, version, tag), data);
    }

    private static class ModelCacheKey {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String tag;

        private ModelCacheKey(String groupId, String artifactId, String version, String tag) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.tag = tag;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ModelCacheKey other = (ModelCacheKey)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public String toString() {
            return "ModelCacheKey [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ", tag=" + this.tag + "]";
        }
    }
}

