/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.mule.tooling.core.m2.dependency.MavenDependency;

public class DependencyResolutionResult {
    private final MavenDependency dependency;
    private final File result;
    private final List<Exception> exceptions;

    public static Builder builder() {
        return new Builder();
    }

    public DependencyResolutionResult(MavenDependency dependency2, File result, List<Exception> exceptions) {
        this.dependency = dependency2;
        this.result = result;
        this.exceptions = new ArrayList<Exception>(exceptions);
    }

    public MavenDependency getDependency() {
        return this.dependency;
    }

    public File getResultFile() {
        return this.result;
    }

    public List<Exception> getExceptions() {
        return this.exceptions;
    }

    public boolean isSuccessful() {
        return this.result != null;
    }

    public void addException(Exception e) {
        this.exceptions.add(e);
    }

    public String toString() {
        return "DependencyResolutionResult [dependency=" + String.valueOf(this.dependency) + ", result=" + String.valueOf(this.result) + "]";
    }

    public static class Builder {
        private MavenDependency dependency;
        private File result;
        private List<Exception> exceptions = new LinkedList<Exception>();

        public Builder withDependency(MavenDependency dependency2) {
            this.dependency = dependency2;
            return this;
        }

        public Builder withResult(File result) {
            this.result = result;
            return this;
        }

        public Builder withException(Exception exception) {
            this.exceptions.add(exception);
            return this;
        }

        public Builder withExceptions(List<Exception> exceptions) {
            this.exceptions = exceptions;
            return this;
        }

        public DependencyResolutionResult build() {
            return new DependencyResolutionResult(this.dependency, this.result, this.exceptions);
        }
    }
}

