/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.RepositoryBase;
import org.apache.maven.model.Resource;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.IMavenPropertyResolver;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.MavenPropertyResolver;
import org.mule.tooling.core.m2.PomDOMUtils;
import org.mule.tooling.core.m2.XmlEditingHelper;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.PomFileHandler;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.core.xml.format.XmlFormatter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DefaultPomFileHandler
implements PomFileHandler {
    private static final boolean DEBUG_REMOVE_DEPENDENCY = Boolean.getBoolean("org.mule.tooling.core.m2.internal.remove");
    private static final IMavenPropertyResolver NOOP_PROPERTY_RESOLVER = new NoOpPropertyResolver();
    private long lastModificationStamp;
    private Model rawModel;
    private Model mavenModel;
    private PomFileHandler.PomState pomState = PomFileHandler.PomState.INVALID;
    private Document pomDocument;
    private final IFile pomIFile;
    private static final DocumentBuilderFactory dbFactory = XmlFactoryUtils.createSecureDocumentBuilderFactory(factory -> factory.setNamespaceAware(true));
    private MavenModelHelper mavenModelHelper;

    public DefaultPomFileHandler(IFile pomIFile) {
        this.pomIFile = pomIFile;
    }

    @Override
    public Model getRawModel() {
        return this.rawModel;
    }

    @Override
    public Model getMavenModel() {
        return this.mavenModel != null && this.isPomWellFormed() ? this.mavenModel : new Model();
    }

    @Override
    public MavenModelHelper getMavenModelHelper() {
        return this.mavenModelHelper;
    }

    @Override
    public File getPomFile() {
        return this.mavenModel.getPomFile();
    }

    @Override
    public boolean isPomWellFormed() {
        return this.pomState != PomFileHandler.PomState.INVALID;
    }

    @Override
    public PomFileHandler.PomState getPomState() {
        return this.pomState;
    }

    @Override
    public IMavenPropertyResolver getPropertyResolver() {
        IMavenPropertyResolver resolver = null;
        switch (this.pomState) {
            case INVALID: {
                resolver = NOOP_PROPERTY_RESOLVER;
                break;
            }
            case READ: 
            case RESOLVED: {
                resolver = new MavenPropertyResolver(this);
            }
        }
        return resolver;
    }

    @Override
    public void ensureSync() {
        if (this.pomIFile.getModificationStamp() != this.lastModificationStamp) {
            this.loadPom();
        }
    }

    @Override
    public void removeDependency(Dependency dependency2) {
        if (DEBUG_REMOVE_DEPENDENCY) {
            MuleCorePlugin.logError("Removing dependency " + dependency2.getArtifactId() + " from " + String.valueOf(this.pomIFile.getFullPath()), new Exception("Stack trace information").fillInStackTrace());
        }
        Node dependenciesNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "dependencies");
        Node dependencyNodeToBeRemoved = PomDOMUtils.findElementMatching(dependenciesNode.getChildNodes(), dependency2.getGroupId(), dependency2.getArtifactId());
        PomDOMUtils.removeChildNode(dependenciesNode, dependencyNodeToBeRemoved);
    }

    @Override
    public void addDependency(Dependency newDependency) {
        Node dependenciesNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "dependencies");
        Node newDependencyNode = PomDOMUtils.createDomDependency(this.pomDocument, newDependency);
        PomDOMUtils.appendChild(dependenciesNode, newDependencyNode);
    }

    @Override
    public void addProperty(String name, String value) {
        Node propertiesNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "properties");
        Node newPropertyNode = PomDOMUtils.getOrCreateChild(propertiesNode, name);
        newPropertyNode.setTextContent(value);
        PomDOMUtils.appendChild(propertiesNode, newPropertyNode);
    }

    @Override
    public void addRepository(Repository repository) {
        Node repositoriesNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "repositories");
        Element repositoryNode = PomDOMUtils.appendNewChild(repositoriesNode, "repository");
        this.fillRepositoryNode((RepositoryBase)repository, repositoryNode);
    }

    @Override
    public void addRepositoryBefore(Repository repositoryToAdd, Repository existingRepository) {
        Node repositoriesNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "repositories");
        Optional<Node> maybeReferenceNode = PomDOMUtils.getChildren(repositoriesNode, "repository").stream().filter(node -> PomDOMUtils.getChild(node, "id").getTextContent().equals(existingRepository.getId())).findFirst();
        if (!maybeReferenceNode.isPresent()) {
            throw new IllegalArgumentException(MessageFormat.format("Couldn''t find repository node with id: {0}.", existingRepository.getId()));
        }
        Node referenceNode = maybeReferenceNode.get();
        Element repositoryNode = PomDOMUtils.insertBeforeNode(repositoriesNode, referenceNode, "repository");
        this.fillRepositoryNode((RepositoryBase)repositoryToAdd, repositoryNode);
    }

    private void fillRepositoryNode(RepositoryBase repository, Element repositoryNode) {
        PomDOMUtils.appendNewChild(repositoryNode, "id", repository.getId());
        String name = repository.getName();
        if (name != null) {
            PomDOMUtils.appendNewChild(repositoryNode, "name", name);
        }
        PomDOMUtils.appendNewChild(repositoryNode, "url", repository.getUrl());
        PomDOMUtils.appendNewChild(repositoryNode, "layout", repository.getLayout());
    }

    @Override
    public void addTestResource(Resource resource) {
        ArrayList<Resource> testResources = new ArrayList();
        Build build = this.mavenModel.getBuild();
        if (build != null) {
            testResources = build.getTestResources();
        }
        this.addResource(resource, testResources, "testResource");
    }

    @Override
    public void addResource(Resource resource) {
        ArrayList<Resource> resources = new ArrayList();
        Build build = this.mavenModel.getBuild();
        if (build != null) {
            resources = build.getTestResources();
        }
        this.addResource(resource, resources, "testResource");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void writeChanges() {
        this.pomDocument.setXmlStandalone(true);
        XmlFormatter.removeWhitespaceNodes(this.pomDocument);
        DOMSource source = new DOMSource(this.pomDocument);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileOutputStream pomOutputStream = new FileOutputStream(this.mavenModel.getPomFile());
                try {
                    try (OutputStreamWriter outputWriter = new OutputStreamWriter((OutputStream)pomOutputStream, StandardCharsets.UTF_8);){
                        StreamResult result = new StreamResult(outputWriter);
                        TransformerFactory transformerFactory = XmlFactoryUtils.createSecureTransformerFactory();
                        Transformer transformer = transformerFactory.newTransformer();
                        transformer.setOutputProperty("doctype-public", "");
                        transformer.setOutputProperty("indent", "yes");
                        transformer.setOutputProperty("method", "xml");
                        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(XmlFormatter.getIndentationSize()));
                        transformer.transform(source, result);
                        XmlFormatter.postProcess(this.mavenModel.getPomFile());
                        this.refreshPom();
                        this.loadPom();
                    }
                    if (pomOutputStream == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (pomOutputStream == null) throw throwable;
                    pomOutputStream.close();
                    throw throwable;
                }
                pomOutputStream.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException | TransformerException e) {
            MuleCorePlugin.logError("Error transforming DOM model to pom.xml file", e);
        }
    }

    @Override
    public void loadPom() {
        this.readPomModel();
        if (this.isPomWellFormed()) {
            this.readPomDocument();
        }
    }

    private void refreshPom() {
        final CountDownLatch latch = new CountDownLatch(1);
        WorkspaceJob refreshJob = new WorkspaceJob("Refreshing " + String.valueOf(this.pomIFile.getFullPath())){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                DefaultPomFileHandler.this.pomIFile.refreshLocal(0, monitor);
                latch.countDown();
                return Status.OK_STATUS;
            }
        };
        refreshJob.setRule((ISchedulingRule)this.pomIFile.getProject());
        refreshJob.schedule();
        try {
            latch.await(3000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            MuleCorePlugin.logWarning("Refreshing pom.xml file after changed took too long.");
        }
    }

    private void readPomDocument() {
        try {
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            this.pomDocument = dBuilder.parse(this.mavenModel.getPomFile());
        }
        catch (ParserConfigurationException | SAXException e) {
            MuleCorePlugin.logError("Unable initialize pom DOM document", e);
        }
        catch (IOException e) {
            MuleCorePlugin.logError("Unable to fetch the pom.xml contents", e);
        }
    }

    private void readPomModel() {
        this.lastModificationStamp = this.pomIFile.getModificationStamp();
        try {
            this.doReadPomModel(Collections.emptyList());
        }
        catch (ModelBuildingException modelException) {
            if (modelException.getProblems().stream().anyMatch(p -> p.getMessage().contains("Non-resolvable parent POM"))) {
                MuleCorePlugin.logWarning("There was a problem resolving the parent POM\nRetrying with remote repositories.", modelException);
                this.retryReadModelWithRemoteRepositories();
            }
            this.readModelFallback(modelException);
        }
    }

    private void doReadPomModel(List<RemoteRepository> remoteRepository) throws ModelBuildingException {
        try {
            ModelBuildingResult result;
            IVMInstall vm;
            Properties properties = new Properties();
            IProject project = this.pomIFile.getProject();
            if (project.exists() && (vm = JavaRuntime.getVMInstall((IJavaProject)JavaCore.create((IProject)project))) instanceof IVMInstall2) {
                properties.put("java.version", ((IVMInstall2)vm).getJavaVersion());
            }
            properties.putAll((Map<?, ?>)MavenCore.getPropertiesSetting(MavenCore.getGlobalSettings()));
            properties.putAll((Map<?, ?>)MavenCore.getPropertiesSetting(MavenCore.getUserSettings()));
            if (this.pomIFile.exists() && this.pomIFile.getLocation() != null) {
                result = MavenCore.getMavenModelReader().readModel(this.pomIFile.getLocation().toFile(), remoteRepository, properties);
            } else {
                Throwable throwable = null;
                Object var6_8 = null;
                try (InputStream pomFileInputStream = this.pomIFile.getContents(true);){
                    result = MavenCore.getMavenModelReader().readModel(pomFileInputStream, remoteRepository, properties);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.mavenModel = result.getEffectiveModel();
            this.rawModel = result.getRawModel();
            this.postPomRead(PomFileHandler.PomState.RESOLVED);
        }
        catch (IOException | CoreException e) {
            MuleCorePlugin.logWarning("Unable to parse " + String.valueOf(this.pomIFile) + ". " + e.getMessage(), e);
            this.postPomRead(PomFileHandler.PomState.INVALID);
        }
    }

    private void retryReadModelWithRemoteRepositories() {
        try {
            File rootProject = null;
            IPath location = this.pomIFile.getProject().getLocation();
            if (location != null) {
                rootProject = new File(location.toString());
            }
            this.doReadPomModel(MavenCore.getUserRepositories(rootProject));
        }
        catch (ModelBuildingException modelException) {
            this.readModelFallback(modelException);
        }
    }

    private void readModelFallback(ModelBuildingException exception) {
        try {
            MuleCorePlugin.logWarning("There was a problem loading the effective model of pom file: " + String.valueOf(this.pomIFile) + "\nFalling back to using the plain unresolved model.", exception);
            if (exception.getResult() != null && exception.getResult().getRawModel() != null) {
                this.rawModel = this.mavenModel = exception.getResult().getRawModel();
            } else {
                Throwable throwable = null;
                Object var3_5 = null;
                try (InputStream fallbackReadInputStream = this.pomIFile.getContents();){
                    this.rawModel = this.mavenModel = new MavenXpp3Reader().read(fallbackReadInputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            this.postPomRead(PomFileHandler.PomState.READ);
        }
        catch (IOException | XmlPullParserException | CoreException e) {
            MuleCorePlugin.logWarning("Unable to parse " + String.valueOf(this.pomIFile) + ". " + e.getMessage(), e);
            this.postPomRead(PomFileHandler.PomState.INVALID);
        }
    }

    private void postPomRead(PomFileHandler.PomState state) {
        if (state != PomFileHandler.PomState.INVALID) {
            this.mavenModelHelper = new MavenModelHelper(this.mavenModel);
            this.setModelPomFile(this.mavenModel);
            this.setModelPomFile(this.rawModel);
        }
        this.pomState = state;
    }

    private void setModelPomFile(Model model) {
        IPath location;
        if (model.getPomFile() == null && this.pomIFile.getLocation() != null && (location = this.pomIFile.getLocation()) != null) {
            File pomFile = location.toFile();
            model.setPomFile(pomFile);
        }
    }

    private Node getProjectNode() {
        Node projectNode = null;
        projectNode = PomDOMUtils.getChild(this.pomDocument, "project");
        if (projectNode == null) {
            MuleCorePlugin.logError("pom.xml does not have a project element: " + this.getPomFile().getAbsolutePath(), new RuntimeException().fillInStackTrace());
        }
        return projectNode;
    }

    @Override
    public XmlEditingHelper edit(String xpathExpression) throws XPathExpressionException {
        Node result = PomDOMUtils.find(xpathExpression, this.pomDocument);
        return result != null ? new XmlEditingHelper(result) : null;
    }

    @Override
    public XmlEditingHelper editExecutionConfigurationForPlugin(String pluginGroupId, String pluginArtifactId, String executionId) {
        Node pluginElement = null;
        Node buildNode = PomDOMUtils.getElement(this.pomDocument, "build");
        NodeList pluginsList = PomDOMUtils.getChild(buildNode, "plugins").getChildNodes();
        pluginElement = PomDOMUtils.findElementMatching(pluginsList, pluginGroupId, pluginArtifactId);
        Node executionsNode = PomDOMUtils.getChild(pluginElement, "executions");
        if (executionsNode == null) {
            throw new IllegalArgumentException(MessageFormat.format("Couldn''t find execution node with id: {0} for plugin: {1}:{2}. No executions tag declared.", executionId, pluginGroupId, pluginArtifactId));
        }
        Node executionNode = null;
        if (executionId == null) {
            executionNode = PomDOMUtils.getFirstChild(executionsNode, "execution");
        } else {
            executionNode = this.findExecutionWithId(executionId, executionsNode);
            if (executionNode == null) {
                throw new IllegalArgumentException(MessageFormat.format("Couldn''t find execution node with id: {0} for plugin: {1}:{2}", executionId, pluginGroupId, pluginArtifactId));
            }
        }
        Node configurationNode = PomDOMUtils.getOrCreateChild(executionNode, "configuration");
        return new XmlEditingHelper(configurationNode);
    }

    private Node findExecutionWithId(String executionId, Node executionsNode) {
        Node executionNode = null;
        NodeList executions = executionsNode.getChildNodes();
        int i = 0;
        while (i < executions.getLength()) {
            String _executionId;
            Node childNode = executions.item(i);
            Node idNode = PomDOMUtils.getChild(childNode, "id");
            String string = _executionId = idNode != null ? idNode.getTextContent() : "";
            if (executionId.equals(_executionId)) {
                executionNode = childNode;
            }
            ++i;
        }
        return executionNode;
    }

    @Override
    public XmlEditingHelper editConfigurationForPlugin(String pluginGroupId, String pluginArtifactId) {
        Node pluginElement = null;
        Node buildNode = PomDOMUtils.getElement(this.pomDocument, "build");
        NodeList pluginsList = PomDOMUtils.getChild(buildNode, "plugins").getChildNodes();
        pluginElement = PomDOMUtils.findElementMatching(pluginsList, pluginGroupId, pluginArtifactId);
        Node executionsNode = PomDOMUtils.getChild(pluginElement, "executions");
        Node configurationNode = PomDOMUtils.getChild(pluginElement, "configuration");
        if (executionsNode != null && configurationNode == null) {
            Node executionNode = PomDOMUtils.getChild(executionsNode, "execution");
            configurationNode = PomDOMUtils.getOrCreateChild(executionNode, "configuration");
        }
        return new XmlEditingHelper(configurationNode);
    }

    @Override
    public XmlEditingHelper getOrCreatePlugin(String pluginGroupId, String pluginArtifactId, String version) {
        Node pluginElement = null;
        Node buildNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "build");
        Node pluginsNode = PomDOMUtils.getOrCreateChild(buildNode, "plugins");
        NodeList pluginsList = pluginsNode.getChildNodes();
        pluginElement = PomDOMUtils.findElementMatching(pluginsList, pluginGroupId, pluginArtifactId);
        if (pluginElement == null) {
            return new XmlEditingHelper(pluginsNode).createElement("plugin").createElement("groupId").setValue(pluginGroupId).createElement("artifactId").setValue(pluginArtifactId).createElement("version").setValue(version);
        }
        return new XmlEditingHelper(pluginElement);
    }

    private void addResource(Resource resource, List<Resource> existingResources, String tagName) {
        if (!CollectionUtils.exists(existingResources, (Predicate)new ResourcePredicate(resource))) {
            Node buildNode = PomDOMUtils.getOrCreateChild(this.getProjectNode(), "build");
            Node testResourcesNode = PomDOMUtils.getOrCreateChild(buildNode, tagName + "s");
            Element testResourceNode = PomDOMUtils.appendNewChild(testResourcesNode, tagName);
            PomDOMUtils.appendNewChild(testResourceNode, "directory").setTextContent(resource.getDirectory());
        }
    }

    @Override
    public void removePlugin(String pluginGroupId, String pluginArtifactId) {
        Node buildNode = PomDOMUtils.getElement(this.pomDocument, "build");
        Node pluginsNode = PomDOMUtils.getChild(buildNode, "plugins");
        NodeList pluginsList = pluginsNode.getChildNodes();
        Node pluginElement = PomDOMUtils.findElementMatching(pluginsList, pluginGroupId, pluginArtifactId);
        pluginsNode.removeChild(pluginElement);
    }

    @Override
    public void removeProperty(String name) {
        Node propertiesNode = PomDOMUtils.getElement(this.pomDocument, "properties");
        Node propertyNode = PomDOMUtils.getChild(propertiesNode, name);
        propertiesNode.removeChild(propertyNode);
    }

    private static final class NoOpPropertyResolver
    implements IMavenPropertyResolver {
        private NoOpPropertyResolver() {
        }

        @Override
        public String resolveProperties(String string) {
            return string;
        }
    }

    private class ResourcePredicate
    implements Predicate {
        Resource requiredResource;

        public ResourcePredicate(Resource resource) {
            this.requiredResource = resource;
        }

        public boolean evaluate(Object object) {
            if (object instanceof Resource) {
                return this.requiredResource.getDirectory().equals(((Resource)object).getDirectory());
            }
            return false;
        }
    }
}

