/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.aether.transfer.AbstractTransferListener;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.TransferCancelledException;
import org.eclipse.aether.transfer.TransferEvent;
import org.eclipse.aether.transfer.TransferResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;

public class ConsoleToMonitorTransferListener
extends AbstractTransferListener {
    private final IProgressMonitor monitor;
    private Map<TransferResource, Long> downloads = new ConcurrentHashMap<TransferResource, Long>();
    private Map<TransferResource, IProgressMonitor> monitors = new ConcurrentHashMap<TransferResource, IProgressMonitor>();

    public ConsoleToMonitorTransferListener(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void transferInitiated(TransferEvent event) throws TransferCancelledException {
        this.handleCancellation(event);
        String downloadMessage = this.getDownloadProgressMessage(event, null);
        this.monitor.subTask(downloadMessage);
    }

    private void handleCancellation(TransferEvent event) throws TransferCancelledException {
        if (this.monitor.isCanceled()) {
            StringBuilder message = new StringBuilder("Cancelling ");
            boolean isUpload = event.getRequestType() == TransferEvent.RequestType.PUT;
            message.append(isUpload ? "upload" : "download");
            if (!isUpload) {
                message.append(". Downloading remaining data.");
            }
            this.monitor.subTask(message.toString());
            throw new TransferCancelledException();
        }
    }

    private String getDownloadProgressMessage(TransferEvent event, String dlProgress) {
        StringBuilder message = new StringBuilder(event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploading" : "Downloading");
        if (dlProgress != null) {
            message.append(" (").append(dlProgress).append(")");
        }
        message.append(": ");
        message.append(event.getResource().getRepositoryUrl());
        message.append(event.getResource().getResourceName());
        return message.toString();
    }

    public void transferStarted(TransferEvent event) throws TransferCancelledException {
        this.handleCancellation(event);
        int contentLength = (int)event.getResource().getContentLength();
        SubProgressMonitor subMonitor = new SubProgressMonitor(this.monitor, contentLength);
        subMonitor.beginTask(this.getDownloadProgressMessage(event, null), contentLength);
        this.monitors.put(event.getResource(), (IProgressMonitor)subMonitor);
    }

    public void transferProgressed(TransferEvent event) throws TransferCancelledException {
        this.handleCancellation(event);
        TransferResource resource = event.getResource();
        int transferredBytes = (int)event.getTransferredBytes();
        this.downloads.put(resource, Long.valueOf(transferredBytes));
        StringBuilder buffer = new StringBuilder(64);
        boolean first = true;
        for (Map.Entry<TransferResource, Long> entry : this.downloads.entrySet()) {
            long total = entry.getKey().getContentLength();
            long complete = entry.getValue();
            if (!first) {
                buffer.append(" ");
            } else {
                first = false;
            }
            buffer.append(this.getStatus(complete, total));
        }
        IProgressMonitor submonitor = this.monitors.get(resource);
        submonitor.worked(transferredBytes);
        submonitor.subTask(this.getDownloadProgressMessage(event, buffer.toString()));
    }

    private String getStatus(long complete, long total) {
        if (total >= 1024L) {
            return this.toKB(complete) + "/" + this.toKB(total) + " KB";
        }
        if (total >= 0L) {
            return complete + "/" + total + " B";
        }
        if (complete >= 1024L) {
            return this.toKB(complete) + " KB";
        }
        return complete + " B";
    }

    public void transferSucceeded(TransferEvent event) {
        this.transferCompleted(event);
        TransferResource resource = event.getResource();
        long contentLength = event.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = event.getRequestType() == TransferEvent.RequestType.PUT ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            Object throughput = "";
            long duration = System.currentTimeMillis() - resource.getTransferStartTime();
            if (duration > 0L) {
                long bytes = contentLength - resource.getResumeOffset();
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)bytes / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.monitor.subTask(type + ": " + resource.getRepositoryUrl() + resource.getResourceName() + " (" + len + (String)throughput + ")");
        }
    }

    public void transferFailed(TransferEvent event) {
        this.transferCompleted(event);
        if (!(event.getException() instanceof MetadataNotFoundException)) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            event.getException().printStackTrace(printWriter);
            this.monitor.subTask(stringWriter.toString());
        }
    }

    private void transferCompleted(TransferEvent event) {
        TransferResource resource = event.getResource();
        this.downloads.remove(resource);
        StringBuilder buffer = new StringBuilder(64);
        buffer.append('\r');
        this.monitor.subTask(buffer.toString());
        this.monitors.remove(resource).done();
    }

    public void transferCorrupted(TransferEvent event) {
        MuleCorePlugin.logWarning(event.getException().getMessage(), event.getException());
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }
}

