/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.internal;

import java.io.File;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.DependencySelector;
import org.eclipse.aether.repository.AuthenticationSelector;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.graph.selector.AndDependencySelector;
import org.eclipse.aether.util.graph.selector.ExclusionDependencySelector;
import org.eclipse.aether.util.graph.selector.OptionalDependencySelector;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.eclipse.aether.util.repository.ConservativeAuthenticationSelector;
import org.eclipse.aether.util.repository.DefaultAuthenticationSelector;
import org.mule.tooling.core.m2.internal.ConsoleRepositoryListener;
import org.mule.tooling.core.m2.internal.ConsoleTransferListener;
import org.mule.tooling.core.m2.internal.ManualRepositorySystemFactory;
import org.mule.tooling.core.m2.internal.MavenCore;

public class Booter {
    public static RepositorySystem newRepositorySystem() {
        return ManualRepositorySystemFactory.newRepositorySystem();
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepository) {
        return Booter.newRepositorySystemSession(system, localRepository, RepositoryType.SIMPLE, null, false);
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepository, RepositoryType repositoryType, UpdatePolicy updatePolicy, boolean offline) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        session.setAuthenticationSelector(Booter.createAuthenticationSelector(MavenCore.getUserSettings()));
        LocalRepository localRepo = new LocalRepository(new File(localRepository), repositoryType.getTypeString());
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        AndDependencySelector depFilter = new AndDependencySelector(new DependencySelector[]{new OptionalDependencySelector(), new ExclusionDependencySelector()});
        session.setDependencySelector((DependencySelector)depFilter);
        session.setUpdatePolicy(updatePolicy == null ? null : updatePolicy.getValue());
        session.setOffline(offline);
        return session;
    }

    public static RepositoryPolicy getReleasePolicy() {
        return new RepositoryPolicy(true, "never", "warn");
    }

    public static RepositoryPolicy getSnapshotPolicy() {
        String snapshotPolicy = "daily";
        return new RepositoryPolicy(true, snapshotPolicy, "warn");
    }

    private static AuthenticationSelector createAuthenticationSelector(Settings settings) {
        DefaultAuthenticationSelector selector = new DefaultAuthenticationSelector();
        for (Server server : settings.getServers()) {
            AuthenticationBuilder auth = new AuthenticationBuilder();
            auth.addUsername(server.getUsername()).addPassword(server.getPassword());
            auth.addPrivateKey(server.getPrivateKey(), server.getPassphrase());
            selector.add(server.getId(), auth.build());
        }
        return new ConservativeAuthenticationSelector((AuthenticationSelector)selector);
    }

    public static enum RepositoryType {
        SIMPLE("simple"),
        ENHANCED("default");

        private String typeString;

        private RepositoryType(String typeString) {
            this.typeString = typeString;
        }

        public String getTypeString() {
            return this.typeString;
        }
    }

    public static enum UpdatePolicy {
        ALWAYS("always"),
        NEVER("never");

        private String value;

        private UpdatePolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

