/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.dependency.inspect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.model.Repository;
import org.mule.tooling.core.m2.dependency.inspect.InspectingStrategy;
import org.mule.tooling.core.utils.JarFileHelper;

class PomPropertiesStrategy
implements InspectingStrategy {
    PomPropertiesStrategy() {
    }

    @Override
    public String getGroupId(JarFile jarFile) {
        try {
            return this.getPomProperties(jarFile).getProperty("groupId");
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading modules jar file", e);
        }
    }

    @Override
    public String getArtifactId(JarFile jarFile) {
        try {
            return this.getPomProperties(jarFile).getProperty("artifactId");
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading modules jar file", e);
        }
    }

    @Override
    public String getVersion(JarFile jarFile) {
        try {
            return this.getPomProperties(jarFile).getProperty("version");
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading modules jar file", e);
        }
    }

    @Override
    public Repository getSnapshotsRepository(JarFile jarFile) {
        return null;
    }

    @Override
    public Repository getReleaseRepository(JarFile jarFile) {
        return null;
    }

    Properties getPomProperties(JarFile jarFile) throws IOException {
        JarEntry pomPropertiesJarEntry = JarFileHelper.searchForEntry(jarFile, "META-INF/maven/.*/pom.properties");
        if (pomPropertiesJarEntry != null) {
            return this.loadPropertiesFromJarEntry(pomPropertiesJarEntry, jarFile);
        }
        throw new IllegalStateException("Module is not maven based");
    }

    Properties loadPropertiesFromJarEntry(JarEntry jarEntry, JarFile jarFile) {
        try {
            Properties properties = new Properties();
            InputStream inputStream = jarFile.getInputStream(jarEntry);
            properties.load(inputStream);
            return properties;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Jar entry not found in jar file");
        }
    }
}

