/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.dependency.inspect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.tooling.core.m2.dependency.inspect.InspectingStrategy;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.utils.JarFileHelper;

public class PomFileStrategy
implements InspectingStrategy {
    private static final Properties EMPTY_PROPERTIES = new Properties();
    private Model pomModel;

    @Override
    public String getGroupId(JarFile jarFile) {
        Parent parent;
        Model pomModel = this.getPomModel(jarFile);
        String groupId = pomModel.getGroupId();
        if (groupId == null && (parent = pomModel.getParent()) != null) {
            groupId = parent.getGroupId();
        }
        return groupId;
    }

    @Override
    public String getArtifactId(JarFile jarFile) {
        return this.getPomModel(jarFile).getArtifactId();
    }

    @Override
    public String getVersion(JarFile jarFile) {
        Parent parent;
        Model pomModel = this.getPomModel(jarFile);
        String version = pomModel.getVersion();
        if (version == null && (parent = pomModel.getParent()) != null) {
            version = parent.getVersion();
        }
        return version;
    }

    @Override
    public Repository getSnapshotsRepository(JarFile jarFile) {
        Model pomModel = this.getPomModel(jarFile);
        DistributionManagement distributionManagement = pomModel.getDistributionManagement();
        return distributionManagement != null ? distributionManagement.getSnapshotRepository() : null;
    }

    @Override
    public Repository getReleaseRepository(JarFile jarFile) {
        Model pomModel = this.getPomModel(jarFile);
        DistributionManagement distributionManagement = pomModel.getDistributionManagement();
        return distributionManagement != null ? distributionManagement.getRepository() : null;
    }

    public Model getPomModel(JarFile jarFile) {
        if (this.pomModel == null) {
            JarEntry pomJarEntry = null;
            try {
                pomJarEntry = JarFileHelper.searchForEntry(jarFile, "META-INF/.*/pom.xml");
                Throwable throwable = null;
                Object var4_7 = null;
                try (InputStream pomInputStream = this.getPomInputStream(pomJarEntry, jarFile);){
                    ModelBuildingResult result = MavenCore.getMavenModelReader().readModel(pomInputStream, Collections.emptyList(), EMPTY_PROPERTIES);
                    this.pomModel = result.getEffectiveModel() != null ? result.getEffectiveModel() : result.getRawModel();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (ModelBuildingException e) {
                try {
                    Throwable throwable = null;
                    Object var5_12 = null;
                    try (InputStream pomInputStream = this.getPomInputStream(pomJarEntry, jarFile);){
                        MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
                        this.pomModel = mavenXpp3Reader.read(pomInputStream);
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (XmlPullParserException xmlPullParserException) {
                    throw new IllegalStateException(this.buildUnparseablePomMessage(pomJarEntry, jarFile));
                }
                catch (IOException iOException) {
                    throw new IllegalStateException("Problem reading modules jar file", e);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Problem reading modules jar file", e);
            }
        }
        return this.pomModel;
    }

    private String buildUnparseablePomMessage(JarEntry pomJarEntry, JarFile jarFile) {
        return "Unparseable POM in module " + jarFile.getName() + "/" + pomJarEntry.getName();
    }

    private InputStream getPomInputStream(JarEntry pomJarEntry, JarFile jarFile) throws IOException {
        return jarFile.getInputStream(pomJarEntry);
    }
}

