/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.dependency.inspect;

import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.apache.maven.model.Repository;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.inspect.InspectingStrategy;
import org.mule.tooling.core.m2.dependency.inspect.PomFileStrategy;
import org.mule.tooling.core.m2.dependency.inspect.PomPropertiesStrategy;
import org.mule.tooling.core.utils.JarFileHelper;
import org.mule.tooling.osgi.services.maven.MavenJarFileInspector;

public class DefaultMavenJarfileInspector
implements MavenJarFileInspector {
    private JarFile jarFile;
    private InspectingStrategy inspectingStrategy;
    private Optional<InspectingStrategy> pomPropertiesInspector;
    public static final String POM_ENTRY_REGEX = "META-INF/.*/pom.xml";

    public static boolean hasMavenMetadata(JarFile jarFile) throws IOException {
        return DefaultMavenJarfileInspector.hasPomFile(jarFile) || DefaultMavenJarfileInspector.hasPomProperties(jarFile);
    }

    private static boolean hasPomProperties(JarFile jarFile) throws IOException {
        return JarFileHelper.searchForEntry(jarFile, "META-INF/maven/.*/pom.properties") != null;
    }

    public static boolean hasPomFile(JarFile jarFile) throws IOException {
        JarEntry pomFileEntry = JarFileHelper.searchForEntry(jarFile, POM_ENTRY_REGEX);
        if (pomFileEntry != null) {
            try {
                return DefaultMavenJarfileInspector.getPomModel(jarFile, pomFileEntry) != null;
            }
            catch (XmlPullParserException xmlPullParserException) {
                return false;
            }
        }
        return false;
    }

    public DefaultMavenJarfileInspector(JarFile jarFile) {
        try {
            boolean hasPomProperties = DefaultMavenJarfileInspector.hasPomProperties(jarFile);
            this.pomPropertiesInspector = Optional.ofNullable(hasPomProperties ? new PomPropertiesStrategy() : null);
            if (DefaultMavenJarfileInspector.hasPomFile(jarFile)) {
                this.inspectingStrategy = new PomFileStrategy();
            } else if (hasPomProperties) {
                this.inspectingStrategy = this.pomPropertiesInspector.get();
            } else {
                throw new IllegalStateException("JarFile: " + jarFile.getName() + " does not have maven metadata");
            }
            this.jarFile = jarFile;
        }
        catch (IOException e) {
            MuleCorePlugin.logError("There was an error reading " + jarFile.getName(), e);
        }
    }

    public String getGroupId() {
        return this.pomPropertiesInspector.map(inspector -> inspector.getGroupId(this.jarFile)).orElseGet(() -> this.inspectingStrategy.getGroupId(this.jarFile));
    }

    public String getArtifactId() {
        return this.pomPropertiesInspector.map(inspector -> inspector.getArtifactId(this.jarFile)).orElseGet(() -> this.inspectingStrategy.getArtifactId(this.jarFile));
    }

    public String getVersion() {
        return this.pomPropertiesInspector.map(inspector -> inspector.getVersion(this.jarFile)).orElseGet(() -> this.inspectingStrategy.getVersion(this.jarFile));
    }

    public Repository getSnapshotsRepository() {
        return this.inspectingStrategy.getSnapshotsRepository(this.jarFile);
    }

    public Repository getReleaseRepository() {
        return this.inspectingStrategy.getReleaseRepository(this.jarFile);
    }

    public boolean hasPomFile() {
        try {
            return DefaultMavenJarfileInspector.hasPomFile(this.jarFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading modules jar file", e);
        }
    }

    public InputStream getPomFile() {
        try {
            JarEntry pomJarEntry = JarFileHelper.searchForEntry(this.jarFile, "META-INF/maven/.*/pom.xml");
            if (pomJarEntry != null) {
                InputStream pomInputStream = this.jarFile.getInputStream(pomJarEntry);
                return pomInputStream;
            }
            return null;
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading modules jar file", e);
        }
    }

    public Model getPomModel() {
        if (this.inspectingStrategy instanceof PomFileStrategy) {
            PomFileStrategy pomFileStrategy = (PomFileStrategy)this.inspectingStrategy;
            return pomFileStrategy.getPomModel(this.jarFile);
        }
        JarEntry pomJarEntry = null;
        try {
            pomJarEntry = JarFileHelper.searchForEntry(this.jarFile, "META-INF/maven/.*/pom.xml");
            return DefaultMavenJarfileInspector.getPomModel(this.jarFile, pomJarEntry);
        }
        catch (XmlPullParserException xmlPullParserException) {
            throw new IllegalStateException(this.buildUnparseablePomMessage(pomJarEntry));
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading modules jar file", e);
        }
    }

    private static Model getPomModel(JarFile jarFile, JarEntry pomJarEntry) throws IOException, XmlPullParserException {
        MavenXpp3Reader mavenXpp3Reader = new MavenXpp3Reader();
        InputStream pomInputStream = jarFile.getInputStream(pomJarEntry);
        return mavenXpp3Reader.read(pomInputStream);
    }

    private String buildUnparseablePomMessage(JarEntry pomJarEntry) {
        return "Unparseable POM in module " + this.jarFile.getName() + "/" + pomJarEntry.getName();
    }
}

