/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.dependency;

import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenDependencyXmlParser {
    public Optional<String> getGroupId(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "groupId");
    }

    public Optional<String> getArtifactId(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "artifactId");
    }

    public Optional<String> getVersion(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "version");
    }

    public Optional<String> getScope(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "scope");
    }

    public Optional<String> getClassifier(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "classifier");
    }

    public Optional<String> getType(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "type");
    }

    public Optional<String> getSystemPath(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "systemPath");
    }

    public Optional<String> getOptional(String contents) throws IOException {
        if (StringUtils.isBlank((String)contents)) {
            return Optional.empty();
        }
        return this.getContentFromTag(contents, "optional");
    }

    private Optional<String> getContentFromTag(String contents, String tagName) throws IOException {
        MXParser parser = new MXParser();
        try {
            return this.doGetContentFromTag(contents, tagName, parser);
        }
        catch (XmlPullParserException xmlPullParserException) {
            return null;
        }
    }

    private Optional<String> doGetContentFromTag(String contents, String tagName, MXParser parser) throws XmlPullParserException, IOException {
        parser.setInput((Reader)new StringReader(contents));
        boolean healthyInput = true;
        String[] lines = contents.split(System.lineSeparator());
        while ((healthyInput = this.next(parser)) && !this.isAtEnd((XmlPullParser)parser, lines) && !this.foundStartTag(tagName, parser)) {
        }
        if (!healthyInput) {
            return null;
        }
        if (this.isAtEnd((XmlPullParser)parser, lines)) {
            return Optional.empty();
        }
        healthyInput = this.next(parser);
        if (healthyInput && parser.getEventType() != 3) {
            return Optional.ofNullable(parser.getText());
        }
        return healthyInput ? Optional.empty() : null;
    }

    private boolean foundStartTag(String tagName, MXParser parser) throws XmlPullParserException {
        return parser.getEventType() == 2 && parser.getName().equals(tagName);
    }

    private boolean next(MXParser parser) throws IOException {
        try {
            parser.next();
            return true;
        }
        catch (XmlPullParserException xmlPullParserException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        catch (EOFException eOFException) {
            return false;
        }
    }

    private boolean isAtEnd(XmlPullParser parser, String[] lines) {
        String lastLine = lines[lines.length - 1];
        int lastLineLength = lastLine.length();
        return parser.getLineNumber() == lines.length && parser.getColumnNumber() == lastLineLength + 1;
    }
}

