/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.dependency;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;

public interface MavenDependency
extends MavenCoordinates {
    public Scope getScope();

    public Optional<String> getSystemPath();

    public Optional<Boolean> isOptional();

    public boolean isSharedDependency();

    default public List<String> getExclusions() {
        return Collections.emptyList();
    }

    default public boolean isSnapshot() {
        return this.getVersion().toLowerCase().endsWith("snapshot");
    }

    default public String asString() {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + this.getVersion();
    }

    public static enum Scope {
        COMPILE,
        TEST,
        RUNTIME,
        SYSTEM,
        PROVIDED,
        IMPORT;


        public String asString() {
            return this.toString().toLowerCase();
        }

        public boolean matches(String scope) {
            if (scope == null) {
                return false;
            }
            return this.asString().equals(scope.toLowerCase());
        }

        public static Scope value(String scope) {
            switch (scope.toLowerCase()) {
                case "compile": {
                    return COMPILE;
                }
                case "test": {
                    return TEST;
                }
                case "runtime": {
                    return RUNTIME;
                }
                case "system": {
                    return SYSTEM;
                }
                case "provided": {
                    return PROVIDED;
                }
                case "import": {
                    return IMPORT;
                }
            }
            return null;
        }
    }
}

