/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2.dependency;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.jar.JarFile;
import org.apache.maven.model.Model;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.inspect.DefaultMavenJarfileInspector;
import org.mule.tooling.core.module.ExternalContributionMuleModule;

public class ExternalModuleMavenDependency
implements MavenDependency {
    private DefaultMavenJarfileInspector inspector;

    public static ExternalModuleMavenDependency from(ExternalContributionMuleModule module) {
        return new ExternalModuleMavenDependency(module);
    }

    private ExternalModuleMavenDependency(ExternalContributionMuleModule module) {
        try {
            JarFile moduleJarFile = this.getModuleJarFile(module);
            this.inspector = new DefaultMavenJarfileInspector(moduleJarFile);
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading the module's jar file", e);
        }
    }

    @Override
    public String getGroupId() {
        return this.inspector.getGroupId();
    }

    @Override
    public String getArtifactId() {
        return this.inspector.getArtifactId();
    }

    @Override
    public String getVersion() {
        return this.inspector.getVersion();
    }

    @Override
    public MavenDependency.Scope getScope() {
        return MavenDependency.Scope.COMPILE;
    }

    public Model getPomModel() {
        return this.inspector.getPomModel();
    }

    private JarFile getModuleJarFile(ExternalContributionMuleModule module) throws IOException {
        File moduleFile = module.getExtensionZipFile();
        if (!moduleFile.exists()) {
            throw new IllegalStateException("Module does not have a jar file");
        }
        return new JarFile(moduleFile);
    }

    @Override
    public Optional<String> getClassifier() {
        return Optional.of("mule-plugin");
    }

    @Override
    public Optional<String> getType() {
        return Optional.of("zip");
    }

    @Override
    public Optional<String> getSystemPath() {
        return Optional.empty();
    }

    @Override
    public Optional<Boolean> isOptional() {
        return Optional.empty();
    }

    @Override
    public boolean isSharedDependency() {
        return false;
    }
}

