/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import javax.xml.xpath.XPathExpressionException;
import org.mule.tooling.core.m2.PomDOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlEditingHelper {
    private final XmlEditingHelper parent;
    private final Node node;

    public XmlEditingHelper(Node node) {
        this(null, node);
    }

    public XmlEditingHelper(XmlEditingHelper parent, Node node) {
        this.parent = parent;
        this.node = node;
    }

    public XmlEditingHelper getOrCreateElement(String tagName) {
        Node element = PomDOMUtils.getOrCreateChild(this.node, tagName);
        return new XmlEditingHelper(this, element);
    }

    public XmlEditingHelper getOrCreateElementBeforeNode(String tagName, String siblingName) {
        Node element = PomDOMUtils.getOrCreateChildBeforeNode(this.node, tagName, siblingName);
        return new XmlEditingHelper(this, element);
    }

    public XmlEditingHelper createElement(String tagName) {
        Element element = PomDOMUtils.appendNewChild(this.node, tagName);
        return new XmlEditingHelper(this, element);
    }

    public boolean hasChild(String tagName) {
        Node element = PomDOMUtils.getChild(this.node, tagName);
        return element != null;
    }

    public XmlEditingHelper findChild(String xpathExpr) throws XPathExpressionException {
        Node child = PomDOMUtils.find(xpathExpr, this.node);
        return child != null ? this.createHelpers(child) : null;
    }

    private XmlEditingHelper createHelpers(Node child) {
        Node childParent = child.getParentNode();
        if (childParent != this.node) {
            return new XmlEditingHelper(this.createHelpers(childParent), child);
        }
        return new XmlEditingHelper(this, child);
    }

    public XmlEditingHelper setValue(String value) {
        this.node.setTextContent(value);
        return this.parent;
    }

    public Node getNode() {
        return this.node;
    }

    private XmlEditingHelper remove(Node child) {
        PomDOMUtils.removeChildNode(this.node, child);
        if (!this.hasChildElements() && this.parent != null && !PomDOMUtils.isRootNode(this.node)) {
            this.parent.remove(this.node);
            return this.parent;
        }
        return this;
    }

    public boolean hasChildElements() {
        return PomDOMUtils.hasChildElements(this.node);
    }

    public XmlEditingHelper remove() {
        if (this.parent != null) {
            return this.parent.remove(this.node);
        }
        PomDOMUtils.removeChildNode(this.node.getParentNode(), this.node);
        return null;
    }
}

