/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.MuleMavenClientResolver;
import org.mule.tooling.core.m2.repo.RepositoryComparator;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.exchange.ExchangeAsset;

public class SnapshotUpdater {
    private static final String RESOLVING_IN_ORDER_TO_DETECT_CHANGES = "Checking for updates to '%s'";
    private static final String USER_CANCEL_SNAPSHOT_RESOLUTION = "User canceled snapshot resolution";
    private static final String SNAPSHOT_RESOLUTION_FOLDER_SUFFIX = "-SNAPSHOTS_RESOLUTION";

    public static CompletableFuture<RepositoryComparator.RepositoryComparationResult> resolveSnapshot(IMuleProject muleProject, final ExchangeAsset exchangeAsset) {
        CompletableFuture<RepositoryComparator.RepositoryComparationResult> result = new CompletableFuture<RepositoryComparator.RepositoryComparationResult>();
        File tempFolder = SnapshotUpdater.getSnapshotsResolutionFolder();
        DependencyResolutionConfiguration dependencyTemporalResolutionConfiguration = DependencyResolutionConfiguration.createDefault().withResolverFactory(sessionConfigurator -> new MuleMavenClientResolver(MavenCore.getUserSettings(), MavenCore.newUserMavenConfigurationSnapshotUpdates(true, Optional.of(tempFolder)), (Consumer<DefaultRepositorySystemSession>)sessionConfigurator));
        Optional<MavenDependency> dependency2 = muleProject.getMuleProjectModel().getAllAPIDependencies().stream().filter(dep -> MavenUtils.getGAV(dep).equals(MavenUtils.getGAV(exchangeAsset.toDepenendency()))).findFirst();
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getDefault().getActiveShell()){

            protected void configureShell(Shell shell) {
                super.configureShell(shell);
                shell.setText(String.format(SnapshotUpdater.RESOLVING_IN_ORDER_TO_DETECT_CHANGES, exchangeAsset.getName()));
            }
        };
        IRunnableWithProgress resolve = monitor -> ArtifactResolvingRunnerFactory.syncInstance().runResolvingDependencies(muleProject, Arrays.asList(dependency2.orElse(exchangeAsset.toDepenendency())), DependenciesCallback.builder().onSuccess(resolvedDependencies -> result.complete(RepositoryComparator.compare(exchangeAsset, MavenCore.getM2RepoFile(), tempFolder))).onError(exceptions -> {
            result.complete(RepositoryComparator.RepositoryComparationResult.failed());
            ArtifactResolvingRunnerFactory.ON_ERROR_LOG.accept((Map<MavenDependency, List<Exception>>)exceptions);
        }).doFinally(() -> {
            boolean bl = tempFolder.delete();
        }).build(), dependencyTemporalResolutionConfiguration, monitor);
        try {
            progressMonitorDialog.run(true, true, resolve);
        }
        catch (InterruptedException | InvocationTargetException exception) {
            MuleCorePlugin.logInfo(USER_CANCEL_SNAPSHOT_RESOLUTION);
        }
        return result;
    }

    private static File getSnapshotsResolutionFolder() {
        File folder = new File(FileUtils.getTempDirectory(), UUID.randomUUID().toString().substring(0, 10) + SNAPSHOT_RESOLUTION_FOLDER_SUFFIX);
        if (!folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }
}

