/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.util.Optional;
import org.eclipse.aether.repository.RemoteRepository;
import org.mule.maven.client.api.model.RepositoryPolicy;
import org.mule.tooling.core.m2.MavenCorePreferences;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.internal.DefaultRepository;

public class RepositoryFactory {
    public static final String UPDATE_POLICY_ALWAYS = "always";
    public static final String UPDATE_POLICY_NEVER = "never";
    public static final String UPDATE_POLICY_DAILY = "daily";

    public static Repository create(org.apache.maven.model.Repository repo) {
        return new DefaultRepository(repo.getId(), repo.getId(), repo.getUrl(), Optional.ofNullable(repo.getReleases()).map(RepositoryFactory::toPolicy).orElse(RepositoryFactory.getDefaultReleasePolicy()), Optional.ofNullable(repo.getSnapshots()).map(RepositoryFactory::toPolicy).orElse(RepositoryFactory.getDefaultSnapshotPolicy()));
    }

    public static Repository create(RemoteRepository repo) {
        return new DefaultRepository(repo.getId(), repo.getId(), repo.getUrl(), Optional.ofNullable(repo.getPolicy(false)).map(RepositoryFactory::toPolicy).orElse(RepositoryFactory.getDefaultReleasePolicy()), Optional.ofNullable(repo.getPolicy(true)).map(RepositoryFactory::toPolicy).orElse(RepositoryFactory.getDefaultSnapshotPolicy()));
    }

    public static Repository create(org.apache.maven.settings.Repository repo) {
        return new DefaultRepository(repo.getId(), repo.getId(), repo.getUrl(), Optional.ofNullable(repo.getReleases()).map(RepositoryFactory::toPolicy).orElse(RepositoryFactory.getDefaultReleasePolicy()), Optional.ofNullable(repo.getSnapshots()).map(RepositoryFactory::toPolicy).orElse(RepositoryFactory.getDefaultSnapshotPolicy()));
    }

    public static RepositoryPolicy toPolicy(org.apache.maven.settings.RepositoryPolicy policy) {
        return RepositoryFactory.createPolicy(policy.isEnabled(), policy.getChecksumPolicy(), policy.getUpdatePolicy());
    }

    public static RepositoryPolicy toPolicy(org.eclipse.aether.repository.RepositoryPolicy policy) {
        return RepositoryFactory.createPolicy(policy.isEnabled(), policy.getChecksumPolicy(), policy.getUpdatePolicy());
    }

    public static RepositoryPolicy toPolicy(org.apache.maven.model.RepositoryPolicy policy) {
        return RepositoryFactory.createPolicy(policy.isEnabled(), policy.getChecksumPolicy(), policy.getUpdatePolicy());
    }

    private static RepositoryPolicy createPolicy(boolean enabled, String checksumPolicy, String updatePolicy) {
        RepositoryPolicy.RepositoryPolicyBuilder builder = new RepositoryPolicy.RepositoryPolicyBuilder();
        builder.enabled(enabled);
        if (enabled) {
            if (checksumPolicy != null) {
                builder.checksumPolicy(checksumPolicy);
            }
            if (updatePolicy != null) {
                builder.updatePolicy(updatePolicy);
            }
        }
        return builder.build();
    }

    public static RepositoryPolicy getDefaultReleasePolicy() {
        return new RepositoryPolicy.RepositoryPolicyBuilder().enabled(true).checksumPolicy("warn").updatePolicy(MavenCorePreferences.getDefaultReleaseUpdatePolicy()).build();
    }

    public static RepositoryPolicy getDefaultSnapshotPolicy() {
        return new RepositoryPolicy.RepositoryPolicyBuilder().enabled(true).checksumPolicy("warn").updatePolicy(MavenCorePreferences.getDefaultSnapshotUpdatePolicy()).build();
    }
}

