/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public enum ProjectType {
    EMPTY_SELECTION("---- Select project Type ----", "---- Select project Type ----"),
    EXAMPLE("Example", "mule-application-example"),
    TEMPLATE("Template", "mule-application-template"),
    MULE_APP("Mule Application", "mule-application"),
    UNRECOGNIZED("", "");

    private final String display;
    private final String classifier;

    public static ProjectType getProjectType(String name) {
        return ProjectType.valueOf(name.substring(0, 1).toUpperCase() + name.substring(1));
    }

    public static Optional<ProjectType> getProjectTypeFromValue(String value) {
        return Arrays.asList(ProjectType.values()).stream().filter(projectType -> projectType.projectType().equals(value)).findFirst();
    }

    private ProjectType(String display, String classifier) {
        this.display = display;
        this.classifier = classifier;
    }

    public String projectType() {
        return this.classifier.toLowerCase();
    }

    public String toString() {
        return this.display;
    }

    public static List<ProjectType> getAllowedProjectTypes() {
        ArrayList allProjectTypes = Lists.newArrayList((Object[])ProjectType.values());
        return allProjectTypes.stream().filter(projectType -> projectType != MULE_APP && projectType != UNRECOGNIZED).collect(Collectors.toList());
    }

    public static ProjectType from(String value) {
        try {
            return ProjectType.getProjectType(value);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return UNRECOGNIZED;
        }
    }

    public boolean isUnrecognized() {
        return this == UNRECOGNIZED;
    }
}

