/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.Resource;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.PomChangedEvent;
import org.mule.tooling.core.event.PomChangedEventHandler;
import org.mule.tooling.core.event.PomDeletedEventHandler;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.m2.IMavenPropertyResolver;
import org.mule.tooling.core.m2.MavenModelHelper;
import org.mule.tooling.core.m2.ProjectType;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.RepositoryFactory;
import org.mule.tooling.core.m2.XmlEditingHelper;
import org.mule.tooling.core.m2.XmlEditionCallable;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.internal.DefaultPomFileHandler;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.PomFileHandler;
import org.mule.tooling.core.m2.internal.WriteSafeDecoratorHandler;
import org.mule.tooling.core.m2.internal.markers.PomFileExistsRule;
import org.mule.tooling.core.m2.internal.markers.PomFileValidRule;
import org.mule.tooling.core.m2.internal.markers.PomSemanticVersioningRule;
import org.mule.tooling.core.m2.plugin.MavenBuildPlugin;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.ProjectModelState;
import org.mule.tooling.core.packageManager.PackagingOptions;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.VersionComparator;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.IMuleProjectModelListener;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class PomMuleProjectModel
implements IMuleProjectModel,
PomChangedEventHandler,
PomDeletedEventHandler,
IMuleProjectEventListener {
    private static final String DEFAULT_LAYOUT = "default";
    private static final String ABSENT = "__absent__";
    private static final String OPEN_PROPERTY_KEY = "${";
    private static final String CLOSE_PROPERTY_KEY = "}";
    public static final String POM_PROPERTY_MULE_VERSION = "${app.runtime}";
    private final Collection<IMuleProjectModelListener> modelListeners;
    private final PomFileHandler pomFileHandler;
    private final EventBusHelper eventBusHelper;
    private final IFile pomResource;
    private final AtomicBoolean programaticallyModified;
    private final PomFileExistsRule pomFileExistsRule;
    private final PomFileValidRule pomFileValidRule;
    private final PomSemanticVersioningRule semanticVersioningRule;

    public static PomMuleProjectModel create(IFile pomFile) {
        return PomMuleProjectModel.create(pomFile, (ProjectInitializationData)ProjectInitializationData.EmptyData.instance());
    }

    public static PomMuleProjectModel create(IFile pomFile, ProjectInitializationData initData) {
        PomMuleProjectModel muleProjectModel = new PomMuleProjectModel(pomFile);
        muleProjectModel.loadPomContents();
        muleProjectModel.initialize(initData);
        return muleProjectModel;
    }

    public static PomMuleProjectModel create(File pomFile, ProjectInitializationData initData) throws IOException {
        PomMuleProjectModel muleProjectModel = new PomMuleProjectModel(InMemoryFile.createInMemoryFile((File)pomFile));
        muleProjectModel.loadPomContents();
        return muleProjectModel;
    }

    protected PomMuleProjectModel(IFile pomFile) {
        DefaultPomFileHandler pomFileHandler = new DefaultPomFileHandler(pomFile);
        this.pomFileHandler = new WriteSafeDecoratorHandler(pomFileHandler);
        this.programaticallyModified = new AtomicBoolean(false);
        this.eventBusHelper = new EventBusHelper();
        this.modelListeners = new LinkedList<IMuleProjectModelListener>();
        this.pomResource = pomFile;
        this.pomFileValidRule = new PomFileValidRule(pomFileHandler);
        this.pomFileExistsRule = new PomFileExistsRule();
        this.semanticVersioningRule = new PomSemanticVersioningRule(this);
    }

    protected void loadPomContents() {
        this.pomFileHandler.loadPom();
    }

    protected void initialize(ProjectInitializationData initData) {
        boolean pomWellFormed = this.pomFileHandler.isPomWellFormed();
        String description = initData.getDescription(ABSENT);
        if (pomWellFormed) {
            String domainName;
            String runtimeId;
            if (!ABSENT.equals(description)) {
                this.setDescription(description);
            }
            if (!ABSENT.equals(runtimeId = initData.getRuntimeId(ABSENT))) {
                this.setRuntimeQualifier(runtimeId);
            }
            if (!ABSENT.equals(domainName = initData.getDomainName(ABSENT))) {
                this.setProperty("app.domain", domainName);
            }
        }
        this.programaticallyModified.set(false);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.POM_CHANGED, (IEventHandler)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.POM_DELETED, (IEventHandler)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_MULE_PROJECT_EVENT, (IEventHandler)this);
    }

    @Override
    public void onMuleProjectClosed(IProject project) {
        if (this.pomResource.getProject().equals((Object)project)) {
            this.eventBusHelper.unregister();
        }
    }

    @Override
    public void onPomChanged(IResource pomResource, IProject project) {
        if (this.pomResource.equals((Object)pomResource)) {
            this.pomChanged();
        }
    }

    @Override
    public ProjectModelState getModelState() {
        if (this.pomResource.exists()) {
            return PomFileHandler.PomState.RESOLVED.equals((Object)this.pomFileHandler.getPomState()) ? ProjectModelState.VALID : ProjectModelState.INVALID;
        }
        return ProjectModelState.MISSING;
    }

    public Optional<String> getResolvedMuleVersionInPom() {
        Optional<String> property = this.getProperty(this.getMuleVersionPropertyName());
        Optional<String> resolveProperties = property.isPresent() ? Optional.of(this.getPropertyResolver().resolveProperties(property.get())) : Optional.empty();
        return resolveProperties;
    }

    public void updateMuleVersionInPom(String newServerVersion) {
        String muleVersionInPom;
        String muleVersionPropertyName = this.getMuleVersionPropertyName();
        Optional<String> muleVersionProperty = this.getProperty(muleVersionPropertyName);
        if (muleVersionProperty.isPresent() && !(muleVersionInPom = this.getPropertyResolver().resolveProperties(muleVersionProperty.get())).equals(newServerVersion)) {
            this.setProperty(muleVersionPropertyName, newServerVersion);
        }
    }

    private String getMuleVersionPropertyName() {
        return "app.runtime";
    }

    public String getMuleVersionProperty() {
        return MessageFormat.format("$'{'{0}'}'", this.getMuleVersionPropertyName());
    }

    public File getPomFile() {
        this.ensurePomWellFormed();
        return this.pomFileHandler.getPomFile();
    }

    public void setGroupId(String groupId) {
        try {
            this.pomFileHandler.edit("/pom:project").getOrCreateElement("groupId").setValue(groupId);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.writeChanges();
    }

    @Override
    public String getGroupId() {
        this.ensurePomWellFormed();
        String groupId = this.pomFileHandler.getMavenModel().getGroupId();
        groupId = this.getPropertyResolver().resolveProperties(groupId);
        return groupId;
    }

    public void setArtifactId(String artifactId) {
        try {
            this.pomFileHandler.edit("/pom:project").getOrCreateElement("artifactId").setValue(artifactId);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.writeChanges();
    }

    @Override
    public String getArtifactId() {
        this.ensurePomWellFormed();
        String artifactId = this.pomFileHandler.getMavenModel().getArtifactId();
        artifactId = this.getPropertyResolver().resolveProperties(artifactId);
        return artifactId;
    }

    public void setVersion(String version) {
        try {
            this.pomFileHandler.edit("/pom:project").getOrCreateElement("version").setValue(version);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.writeChanges();
    }

    @Override
    public String getVersion() {
        this.ensurePomWellFormed();
        String version = this.pomFileHandler.getMavenModel().getVersion();
        version = this.getPropertyResolver().resolveProperties(version);
        return version;
    }

    public boolean isPomWellFormed() {
        return this.pomFileHandler.isPomWellFormed();
    }

    public String getPackaging() {
        return this.pomFileHandler.getMavenModel().getPackaging();
    }

    public void removeDependency(MavenDependency dependency2) {
        Dependency newDependency = MavenModelHelper.dependency(dependency2.getGroupId(), dependency2.getArtifactId(), dependency2.getVersion());
        boolean needsWrite = false;
        if (this.hasDependencyLocal(dependency2)) {
            this.doRemoveDependency(newDependency);
            needsWrite = true;
        }
        if (this.hasSharedDependencyLocal(dependency2)) {
            this.removeSharedDependency(dependency2);
            needsWrite = true;
        }
        if (needsWrite) {
            this.writeChanges();
        }
    }

    private void doRemoveDependency(Dependency dependency2) {
        this.pomFileHandler.removeDependency(dependency2);
    }

    private void addDependency(MavenDependency dependency2) {
        boolean needsWrite = false;
        if (!this.hasDependency(dependency2, false)) {
            this.doAddDependency(dependency2);
            needsWrite = true;
        }
        if (dependency2.isSharedDependency() && !this.hasSharedDependency(dependency2)) {
            this.addSharedDependency(dependency2);
            needsWrite = true;
        }
        if (needsWrite) {
            this.writeChanges();
        }
    }

    private void addSharedDependency(MavenDependency dependency2) {
        Plugin mulePlugin = this.getMulePlugin().get();
        this.editPluginConfiguration(mulePlugin.getGroupId(), mulePlugin.getArtifactId(), xmlEditorHelper -> {
            xmlEditorHelper.getOrCreateElement("sharedLibraries").createElement("sharedLibrary").createElement("groupId").setValue(dependency2.getGroupId()).createElement("artifactId").setValue(dependency2.getArtifactId());
            return true;
        });
    }

    private boolean hasSharedDependency(MavenDependency dependency2) {
        return this.pomFileHandler.getMavenModelHelper().hasSharedLibrary(dependency2.getGroupId(), dependency2.getArtifactId());
    }

    private boolean hasSharedDependencyLocal(MavenDependency dependency2) {
        return new MavenModelHelper(this.pomFileHandler.getRawModel()).hasSharedLibrary(dependency2.getGroupId(), dependency2.getArtifactId());
    }

    private void removeSharedDependency(MavenDependency dependency2) {
        String libraryXpathExpr = "pom:sharedLibraries/pom:sharedLibrary[pom:groupId='" + dependency2.getGroupId() + "' and pom:artifactId='" + dependency2.getArtifactId() + "']";
        try {
            Plugin mulePlugin = this.pomFileHandler.getMavenModelHelper().findMulePlugin();
            XmlEditingHelper configurationEditor = this.pomFileHandler.editConfigurationForPlugin(mulePlugin.getGroupId(), mulePlugin.getArtifactId());
            configurationEditor.findChild(libraryXpathExpr).remove();
            if (!configurationEditor.hasChildElements()) {
                configurationEditor.remove();
            }
        }
        catch (XPathExpressionException e) {
            MuleCorePlugin.logError("Problem parsing xpath expression " + libraryXpathExpr, e);
        }
    }

    private void addDependencies(Collection<MavenDependency> dependencies) {
        boolean needsWrite = false;
        for (MavenDependency dependency2 : dependencies) {
            if (!this.hasDependency(dependency2, false)) {
                this.doAddDependency(dependency2);
                needsWrite = true;
            }
            if (!dependency2.isSharedDependency() || this.hasSharedDependency(dependency2)) continue;
            this.addSharedDependency(dependency2);
            needsWrite = true;
        }
        if (needsWrite) {
            this.writeChanges();
        }
    }

    private MavenDependency convert(Dependency dependency2) {
        MavenDependency.Scope scope = MavenDependency.Scope.value(Optional.ofNullable(dependency2.getScope()).orElse(""));
        Function<String, String> resolveProperties = this.getPropertyResolver()::resolveProperties;
        PojoMavenDependency newDependency = ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(Optional.ofNullable(dependency2.getGroupId()).map(resolveProperties).orElse(null))).withArtifactId(Optional.ofNullable(dependency2.getArtifactId()).map(resolveProperties).orElse(null))).withVersion(Optional.ofNullable(dependency2.getVersion()).map(resolveProperties).orElse(null))).withScope(scope != null ? scope : MavenDependency.Scope.COMPILE)).withClassifier(Optional.ofNullable(dependency2.getClassifier()).map(resolveProperties).orElse(null))).withType(Optional.ofNullable(dependency2.getType()).map(resolveProperties).orElse(null))).withSystemPath(Optional.ofNullable(dependency2.getSystemPath()).map(resolveProperties).orElse(null))).withOptional(dependency2.isOptional())).beingShared(this.pomFileHandler.getMavenModelHelper().hasSharedLibrary(dependency2.getGroupId(), dependency2.getArtifactId()))).withExclusions(dependency2.getExclusions().stream().map(e -> e.getGroupId() + ":" + e.getArtifactId()).collect(Collectors.toList()))).build();
        return newDependency;
    }

    public boolean hasDependency(MavenDependency dependency2) {
        return this.hasDependency(dependency2, true);
    }

    public boolean hasDependency(MavenDependency dependency2, boolean considerVersion) {
        return this.pomFileHandler.getMavenModelHelper().hasDependency(MavenCore.convert(dependency2), considerVersion);
    }

    public boolean hasDependencyLocal(MavenDependency dependency2) {
        return new MavenModelHelper(this.pomFileHandler.getRawModel()).hasDependencyLocal(MavenCore.convert(dependency2));
    }

    public MavenDependency getDependency(MavenDependency dependency2, boolean considerVersion) {
        Optional<Dependency> foundDependency = this.pomFileHandler.getMavenModelHelper().getDependency(MavenCore.convert(dependency2), considerVersion);
        return foundDependency.isPresent() ? this.convert(foundDependency.get()) : null;
    }

    public void addResource(String resourcePath) {
        Resource resource = new Resource();
        resource.setDirectory(resourcePath);
        this.pomFileHandler.addResource(resource);
        this.writeChanges();
    }

    public void addTestResourceDirectory(String resourcePath) {
        Resource resource = new Resource();
        resource.setDirectory(resourcePath);
        this.pomFileHandler.addTestResource(resource);
        this.writeChanges();
    }

    public List<String> getTestResourceDirectories() {
        LinkedList<String> testResources = new LinkedList<String>();
        Build build = this.pomFileHandler.getRawModel().getBuild();
        Optional.ofNullable(build).flatMap(b -> Optional.ofNullable(b.getTestResources())).ifPresent(resources -> resources.stream().filter(resource -> resource.getDirectory() != null).forEach(resource -> {
            boolean bl = testResources.add(resource.getDirectory());
        }));
        return testResources;
    }

    public boolean hasTestResourceDirectory(String resourceDirectory) {
        return this.getTestResourceDirectories().contains(resourceDirectory);
    }

    private void writeChanges() {
        this.programaticallyModified.set(true);
        this.pomFileHandler.writeChanges();
    }

    private void doAddDependency(MavenDependency dependency2) {
        Dependency newDependency = MavenCore.convert(dependency2);
        this.pomFileHandler.addDependency(newDependency);
    }

    public boolean addPlugin(String pluginGroupId, String pluginArtifactId, String version, XmlEditionCallable edition) {
        XmlEditingHelper xmlEditorHelper = this.pomFileHandler.getOrCreatePlugin(pluginGroupId, pluginArtifactId, version);
        boolean editionSuccessful = edition.editXml(xmlEditorHelper);
        if (editionSuccessful) {
            this.writeChanges();
        }
        return editionSuccessful;
    }

    public boolean hasPlugin(String pluginGroupId, String pluginArtifactId) {
        MavenModelHelper mavenModelHelper = this.pomFileHandler.getMavenModelHelper();
        Plugin plugin = mavenModelHelper.getPlugin(pluginGroupId, pluginArtifactId);
        return plugin != null;
    }

    public Optional<MavenBuildPlugin> getPlugin(String pluginGroupId, String pluginArtifactId) {
        MavenModelHelper mavenModelHelper = this.pomFileHandler.getMavenModelHelper();
        Plugin plugin = mavenModelHelper.getPlugin(pluginGroupId, pluginArtifactId);
        return plugin == null ? Optional.empty() : Optional.of(this.convert(plugin));
    }

    public Optional<Plugin> getRawPlugin(String pluginGroupId, String pluginArtifactId) {
        MavenModelHelper mavenModelHelper = this.pomFileHandler.getMavenModelHelper();
        Plugin plugin = mavenModelHelper.getPlugin(pluginGroupId, pluginArtifactId);
        return Optional.ofNullable(plugin);
    }

    public boolean hasPluginInLocalPom(String pluginGroupId, String pluginArtifactId) {
        Model rawModel = this.pomFileHandler.getRawModel();
        Plugin rawPlugin = new MavenModelHelper(rawModel).getPlugin(pluginGroupId, pluginArtifactId);
        return rawPlugin != null;
    }

    private MavenBuildPlugin convert(Plugin plugin) {
        return MavenBuildPlugin.builder().withGroupId(plugin.getGroupId()).withArtifactId(plugin.getArtifactId()).withVersion(plugin.getVersion()).withConfiguration(this.convert((Xpp3Dom)plugin.getConfiguration())).build();
    }

    private MavenBuildPlugin.Configuration convert(Xpp3Dom configuration) {
        return configuration == null ? null : new DomConfiguration(configuration);
    }

    public void addRepository(String mavenFacadeIdV2, String string, String mavenFacadeUrl) {
        org.apache.maven.model.Repository mavenV2Repository = new org.apache.maven.model.Repository();
        mavenV2Repository.setId(mavenFacadeIdV2);
        mavenV2Repository.setUrl(mavenFacadeUrl);
        mavenV2Repository.setName(string);
        mavenV2Repository.setLayout(DEFAULT_LAYOUT);
        this.pomFileHandler.addRepository(mavenV2Repository);
        this.writeChanges();
    }

    public void addRepositoryBefore(String mavenFacadeIdV2, String string, String mavenFacadeUrl, Repository exchangeV1Repository) {
        org.apache.maven.model.Repository mavenV2Repository = new org.apache.maven.model.Repository();
        mavenV2Repository.setId(mavenFacadeIdV2);
        mavenV2Repository.setUrl(mavenFacadeUrl);
        mavenV2Repository.setName(string);
        mavenV2Repository.setLayout(DEFAULT_LAYOUT);
        org.apache.maven.model.Repository mavenV1Repository = new org.apache.maven.model.Repository();
        mavenV1Repository.setId(exchangeV1Repository.getId());
        mavenV1Repository.setUrl(exchangeV1Repository.getUrl());
        mavenV1Repository.setName(exchangeV1Repository.getName());
        mavenV1Repository.setLayout(DEFAULT_LAYOUT);
        this.pomFileHandler.addRepositoryBefore(mavenV2Repository, mavenV1Repository);
        this.writeChanges();
    }

    public boolean editPluginConfiguration(String pluginGroupId, String pluginArtifactId, XmlEditionCallable edition) {
        boolean editionSuccessful = false;
        XmlEditingHelper xmlEditorHelper = this.getEditorHelperForPluginConfiguration(pluginGroupId, pluginArtifactId);
        if (xmlEditorHelper != null) {
            if (xmlEditorHelper.hasChild("executions")) {
                xmlEditorHelper = xmlEditorHelper.getOrCreateElement("executions").getOrCreateElement("execution");
            }
            if (editionSuccessful = edition.editXml(xmlEditorHelper = xmlEditorHelper.getOrCreateElement("configuration"))) {
                this.writeChanges();
            }
        }
        return editionSuccessful;
    }

    public static boolean isMavenProperty(String value) {
        return value != null && value.startsWith(OPEN_PROPERTY_KEY) && value.endsWith(CLOSE_PROPERTY_KEY);
    }

    public static String getMavenProperty(String value) {
        return StringUtils.substringBetween((String)value, (String)OPEN_PROPERTY_KEY, (String)CLOSE_PROPERTY_KEY);
    }

    public boolean updatePluginVersion(String pluginGroupId, String pluginArtifactId, String version) {
        boolean editionSuccessful = false;
        Model rawModel = this.pomFileHandler.getRawModel();
        Plugin rawPlugin = new MavenModelHelper(rawModel).getPlugin(pluginGroupId, pluginArtifactId);
        if (rawPlugin != null) {
            String currentVersion = rawPlugin.getVersion();
            if (PomMuleProjectModel.isMavenProperty(currentVersion)) {
                this.setProperty(PomMuleProjectModel.getMavenProperty(currentVersion), version);
                editionSuccessful = true;
            } else {
                XmlEditingHelper xmlEditorHelper = this.getEditorHelperForPluginConfiguration(pluginGroupId, pluginArtifactId);
                if (xmlEditorHelper != null) {
                    xmlEditorHelper = xmlEditorHelper.getOrCreateElement("version");
                    xmlEditorHelper.setValue(version);
                    editionSuccessful = true;
                }
            }
        }
        if (editionSuccessful) {
            this.writeChanges();
        }
        return editionSuccessful;
    }

    private XmlEditingHelper getEditorHelperForPluginConfiguration(String pluginGroupId, String pluginArtifactId) {
        XmlEditingHelper xmlEditorHelper;
        String xpathExpression = MessageFormat.format("/pom:project/pom:build/pom:plugins/pom:plugin[pom:groupId=\"{0}\" and pom:artifactId=\"{1}\" ]", pluginGroupId, pluginArtifactId);
        try {
            xmlEditorHelper = this.pomFileHandler.edit(xpathExpression);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return xmlEditorHelper;
    }

    private void ensurePomWellFormed() {
        if (!this.isPomWellFormed()) {
            throw new IllegalStateException("Trying to execute an operation over project \"" + this.getName() + "\", which pom file is not well formed");
        }
    }

    public String getArtifactFinalName(PackagingOptions packagingOptions, Properties properties) {
        MavenModelHelper mavenModelHelper = this.pomFileHandler.getMavenModelHelper();
        String artifactFinalName = mavenModelHelper.getArtifactFinalName(properties);
        artifactFinalName = this.getPropertyResolver().resolveProperties(artifactFinalName);
        Optional<String> classifierOptional = mavenModelHelper.getClassifier(packagingOptions);
        return artifactFinalName + classifierOptional.map(classifier -> "-" + classifier).orElse("");
    }

    public String getRawArtifactFinalName(PackagingOptions packagingOptions) {
        Model mavenModel = this.pomFileHandler.getRawModel();
        MavenModelHelper mavenModelHelper = this.pomFileHandler.getMavenModelHelper();
        Build build = mavenModel.getBuild();
        String rawArtifactFinalName = "";
        if (build != null) {
            String modelName = mavenModel.getBuild().getFinalName();
            rawArtifactFinalName = modelName != null ? modelName : "";
        }
        Optional<String> classifierOptional = mavenModelHelper.getClassifier(packagingOptions);
        return rawArtifactFinalName + classifierOptional.map(classifier -> "-" + classifier).orElse("");
    }

    public IMavenPropertyResolver getPropertyResolver() {
        return this.pomFileHandler.getPropertyResolver();
    }

    @Override
    public void setProperty(String name, String value) {
        try {
            XmlEditingHelper xmlEditingHelper = this.pomFileHandler.edit("/pom:project").getOrCreateElement("properties");
            xmlEditingHelper.getOrCreateElement(name).setValue(value);
            this.writeChanges();
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getProperties() {
        Properties properties = this.pomFileHandler.getRawModel().getProperties();
        return properties.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    @Override
    public Optional<String> getProperty(String key) {
        if (this.isPomWellFormed()) {
            return Optional.ofNullable(this.pomFileHandler.getMavenModel().getProperties()).map(properties -> properties.getProperty(key));
        }
        return Optional.empty();
    }

    public void removePlugin(String pluginGroupId, String pluginArtifactId) {
        this.pomFileHandler.removePlugin(pluginGroupId, pluginArtifactId);
        this.writeChanges();
    }

    public void removeProperty(String name) {
        this.pomFileHandler.removeProperty(name);
        this.writeChanges();
    }

    public boolean hasProperty(String name) {
        return this.getProperty(name).isPresent();
    }

    public File getLocallyInstalledArtifact() {
        String sep = File.separator;
        String groupId = this.getGroupId();
        String artifactId = this.getArtifactId();
        String finalName = this.getArtifactFinalName(PackagingOptions.DEFAULT, new Properties());
        String version = this.getVersion();
        String m2repoPath = "";
        StringBuilder pathBuilder = new StringBuilder("");
        if (m2repoPath != null && StringUtils.isNotBlank((String)m2repoPath)) {
            String[] groupSegments;
            pathBuilder.append(m2repoPath).append(sep);
            String[] stringArray = groupSegments = groupId.split("\\.");
            int n = groupSegments.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                pathBuilder.append(segment).append(sep);
                ++n2;
            }
            pathBuilder.append(artifactId).append(sep).append(version).append(sep).append(finalName).append(".zip");
        }
        return new File(pathBuilder.toString());
    }

    public void pomChanged() {
        if (!this.programaticallyModified.compareAndSet(true, false)) {
            this.runNotifyingDependencyChanges(() -> {
                this.loadPomContents();
                this.postPomChanged();
            });
        }
    }

    protected void runNotifyingDependencyChanges(Runnable runnable) {
        MavenDependency previousCoordinates = this.getCoordinates();
        List<MuleExtension> previousExtensions = this.getMuleExtensions();
        List<MavenDependency> previousDependencies = this.getDependencies();
        List<MavenDependency> previousAPIDependencies = this.getAPISpecDependencies();
        List<MavenDependency> previousAsyncAPIDependencies = this.getAsyncAPISpecDependencies();
        Optional<MavenDependency> previousDomainDependency = this.getDomainDependency();
        Optional<String> previousRuntimeQualifier = this.getRuntimeQualifier();
        runnable.run();
        MavenDependency currentCoordinates = this.getCoordinates();
        List<MuleExtension> currentExtensions = this.getMuleExtensions();
        List<MavenDependency> currentDependencies = this.getDependencies();
        List<MavenDependency> currentAPIDependencies = this.getAPISpecDependencies();
        List<MavenDependency> currentAsyncAPIDependencies = this.getAsyncAPISpecDependencies();
        Optional<MavenDependency> currentDomainDependency = this.getDomainDependency();
        Optional<String> currentRuntimeQualifier = this.getRuntimeQualifier();
        this.compareAndNotifyCoordinates(previousCoordinates, currentCoordinates);
        this.compareAndNotify(previousExtensions, currentExtensions);
        this.compareAndNotifyDependencies(previousDependencies, currentDependencies);
        this.compareAndNotifyAPISpecDependencies(previousAPIDependencies, currentAPIDependencies);
        this.compareAndNotifyAsyncAPISpecDependencies(previousAsyncAPIDependencies, currentAsyncAPIDependencies);
        this.compareAndNotifyDomain(previousDomainDependency, currentDomainDependency);
        this.compareAndNotifyRuntimeQualifier(previousRuntimeQualifier, currentRuntimeQualifier);
    }

    private MavenDependency getCoordinates() {
        Model mavenModel = this.pomFileHandler.getMavenModel();
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(mavenModel.getGroupId())).withArtifactId(mavenModel.getArtifactId())).withVersion(mavenModel.getVersion())).build();
    }

    private void compareAndNotifyCoordinates(MavenDependency previousCoordinates, MavenDependency currentCoordinates) {
        if (!previousCoordinates.equals(currentCoordinates)) {
            this.modelListeners.forEach(listener -> listener.coordinatesChangedInModel(this, previousCoordinates, currentCoordinates));
        }
    }

    public void compareAndNotifyDomain(Optional<MavenDependency> previousDomainDependency, Optional<MavenDependency> currentDomainDependency) {
        this.modelListeners.forEach(listener -> listener.domainDependencyChangedInModel(this, previousDomainDependency, currentDomainDependency));
    }

    private void compareAndNotifyRuntimeQualifier(Optional<String> previousRuntimeQualifier, Optional<String> currentRuntimeQualifier) {
        if (!previousRuntimeQualifier.equals(currentRuntimeQualifier)) {
            this.modelListeners.forEach(listener -> listener.runtimeQualifierChangedInModel(this, previousRuntimeQualifier, currentRuntimeQualifier));
        }
    }

    private void compareAndNotifyDependencies(List<MavenDependency> previousDependencies, List<MavenDependency> currentDependencies) {
        Optional<List<MavenDependency>> removed = this.getDifference(previousDependencies, currentDependencies);
        Optional<List<MavenDependency>> added = this.getDifference(currentDependencies, previousDependencies);
        this.modelListeners.forEach(listener -> {
            removed.ifPresent(dependency2 -> listener.dependenciesRemovedFromModel(this, (List<MavenDependency>)dependency2));
            added.ifPresent(dependency2 -> listener.dependenciesAddedToModel(this, (List<MavenDependency>)dependency2));
        });
    }

    private void compareAndNotify(List<MuleExtension> previousExtensions, List<MuleExtension> currentExtensions) {
        Optional<List<MuleExtension>> removed = this.getDifference(previousExtensions, currentExtensions, this::containsMuleExtension);
        Optional<List<MuleExtension>> added = this.getDifference(currentExtensions, previousExtensions, this::containsMuleExtension);
        this.modelListeners.forEach(listener -> {
            removed.ifPresent(extensions -> listener.extensionsRemovedFromModel(this, (List<MuleExtension>)extensions));
            added.ifPresent(extensions -> listener.extensionsAddedToModel(this, (List<MuleExtension>)extensions));
        });
    }

    private void compareAndNotifyAPISpecDependencies(List<MavenDependency> previousAPIDependencies, List<MavenDependency> currentAPIDependencies) {
        Optional<List<MavenDependency>> removed = this.getDifference(previousAPIDependencies, currentAPIDependencies);
        Optional<List<MavenDependency>> added = this.getDifference(currentAPIDependencies, previousAPIDependencies);
        this.modelListeners.forEach(listener -> {
            removed.ifPresent(dependency2 -> listener.apiSpecDependenciesRemovedFromModel(this, (List<MavenDependency>)dependency2));
            added.ifPresent(dependency2 -> listener.apiSpecDependenciesAddedToModel(this, (List<MavenDependency>)dependency2));
        });
    }

    private void compareAndNotifyAsyncAPISpecDependencies(List<MavenDependency> previousAsyncAPIDependencies, List<MavenDependency> currentAsyncAPIDependencies) {
        Optional<List<MavenDependency>> removed = this.getDifference(previousAsyncAPIDependencies, currentAsyncAPIDependencies);
        Optional<List<MavenDependency>> added = this.getDifference(currentAsyncAPIDependencies, previousAsyncAPIDependencies);
        this.modelListeners.forEach(listener -> {
            removed.ifPresent(dependency2 -> listener.apiSpecDependenciesRemovedFromModel(this, (List<MavenDependency>)dependency2));
            added.ifPresent(dependency2 -> listener.apiSpecDependenciesAddedToModel(this, (List<MavenDependency>)dependency2));
        });
    }

    private boolean containsMuleExtension(List<MuleExtension> extensions, MuleExtension extension) {
        return extensions.stream().anyMatch(extension::equalsWithScope);
    }

    private <T> Optional<List<T>> getDifference(List<T> aCollection, List<T> anotherCollection) {
        return this.getDifference(aCollection, anotherCollection, List::contains);
    }

    private <T> Optional<List<T>> getDifference(List<T> aCollection, List<T> anotherCollection, BiPredicate<List<T>, T> containingPredicate) {
        List difference = aCollection.stream().filter(ext -> !containingPredicate.test(anotherCollection, ext)).collect(Collectors.toList());
        return difference.isEmpty() ? Optional.empty() : Optional.of(difference);
    }

    private void postPomChanged() {
        MuleCorePlugin.getEventBus().fireEvent((IEvent)PomChangedEvent.postFileChanged((IResource)this.pomResource, this.pomResource.getProject()));
    }

    @Override
    public List<MavenDependency> getDependencies() {
        if (this.isPomWellFormed()) {
            List dependencies = this.pomFileHandler.getMavenModel().getDependencies();
            List<MavenDependency> collect = dependencies.stream().filter(dep -> !this.isMuleExtensionDependency((Dependency)dep) && !this.isMuleDomainDependency((Dependency)dep) && !this.isAnyApiDepType((Dependency)dep)).map(this::convert).collect(Collectors.toList());
            return collect;
        }
        return Collections.emptyList();
    }

    @Override
    public List<Repository> getRepositories() {
        return this.pomFileHandler.getMavenModel().getRepositories().stream().map(RepositoryFactory::create).collect(Collectors.toList());
    }

    @Override
    public String getName() {
        if (this.isPomWellFormed()) {
            String projectName = Optional.ofNullable(this.pomFileHandler.getMavenModel().getName()).orElseGet(this::getArtifactId);
            projectName = this.getPropertyResolver().resolveProperties(projectName);
            return projectName;
        }
        return this.pomResource.getProject().getName();
    }

    @Override
    public String getDescription() {
        if (this.isPomWellFormed()) {
            return Optional.ofNullable(this.pomFileHandler.getMavenModel().getDescription()).orElse("");
        }
        return "";
    }

    @Override
    public Optional<String> getRuntimeQualifier() {
        return this.getRuntime().map(IServerDefinition::getId);
    }

    public Optional<IServerDefinition> getRuntime() {
        if (this.isPomWellFormed()) {
            String runtimeVersion = this.getResolvedMuleVersionInPom().orElseGet(CoreUtils.getDefaultServer()::getVersionWithSuffix);
            List<IServerDefinition> serverDefinitions = MuleCorePlugin.getServerManager().getServerDefinitions();
            try {
                VersionComparator versionComparator = VersionComparator.forVersion(runtimeVersion);
                return serverDefinitions.stream().filter(server -> versionComparator.compareVersionTo(server.getVersionWithSuffix()) == 0).findFirst();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Optional.empty();
            }
        }
        return Optional.of(CoreUtils.getDefaultServer());
    }

    @Override
    public void setRuntimeQualifier(String runtimeId) {
        String versionWithSuffix = MuleCorePlugin.getServerManager().getServerDefinition(runtimeId).getVersionWithSuffix();
        this.setProperty(this.getMuleVersionPropertyName(), versionWithSuffix);
        this.writeChanges();
    }

    @Override
    public void setName(String name) {
        if (!name.equals(this.getName())) {
            try {
                this.pomFileHandler.edit("/pom:project").getOrCreateElement("name").setValue(name);
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
            this.writeChanges();
        }
    }

    @Override
    public void setDescription(String description) {
        try {
            this.pomFileHandler.edit("/pom:project").getOrCreateElementBeforeNode("description", "properties").setValue(description);
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
        }
        this.writeChanges();
    }

    @Override
    public List<MuleExtension> getMuleExtensions() {
        return this.pomFileHandler.getMavenModel().getDependencies().stream().filter(this::isMuleExtensionDependency).map(dep -> {
            String qualifier = this.getGav((Dependency)dep);
            return new MuleExtension(qualifier, qualifier, dep.getScope());
        }).collect(Collectors.toList());
    }

    protected boolean isMuleExtensionDependency(Dependency dep) {
        return "mule-plugin".equals(dep.getClassifier());
    }

    private boolean isMuleDomainDependency(Dependency dep) {
        return "mule-domain".equals(dep.getClassifier());
    }

    private boolean isApiSpecDep(Dependency dep) {
        return CoreUtils.isAPIClassifier(dep.getClassifier());
    }

    private boolean isDwLibraryDep(Dependency dep) {
        return CoreUtils.isDwLibraryClassifier(dep.getClassifier());
    }

    private boolean isAsyncApiDep(Dependency dep) {
        return CoreUtils.isAsyncAPIClassifier(dep.getClassifier());
    }

    private boolean isAnyApiDepType(Dependency dep) {
        return CoreUtils.isAnyAPITypeClassifier(dep.getClassifier());
    }

    protected String getGav(Dependency dep) {
        return dep.getGroupId() + ":" + dep.getArtifactId() + ":" + dep.getVersion();
    }

    @Override
    public void addMuleExtension(MuleExtension muleExtension) {
        MavenDependency dependency2 = MavenUtils.getDependency(muleExtension);
        this.runNotifyingDependencyChanges(() -> this.addDependency(dependency2));
    }

    @Override
    public void removeMuleExtension(MuleExtension muleExtension) {
        MavenDependency dependency2 = MavenUtils.getDependency(muleExtension);
        this.runNotifyingDependencyChanges(() -> this.removeDependency(dependency2));
    }

    @Override
    public void addModelListener(IMuleProjectModelListener modelListener) {
        this.modelListeners.add(modelListener);
    }

    @Override
    public void removeModelListener(IMuleProjectModelListener modelListener) {
        this.modelListeners.remove(modelListener);
    }

    @Override
    public void onMuleProjectOpened(IProject project) {
    }

    @Override
    public void postPomChanged(IResource resource, IProject project) {
        if (resource.equals((Object)this.pomResource)) {
            try {
                this.pomFileExistsRule.apply(project);
                this.pomFileValidRule.apply(project);
                this.semanticVersioningRule.apply(project);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("There was a problem creating or clearing markers from project " + String.valueOf(project), e);
            }
        }
    }

    @Override
    public void onPomDeleted(IResource resource, IProject project) {
        if (resource.equals((Object)this.pomResource)) {
            try {
                this.pomFileExistsRule.apply(project);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("There was a problem creating or clearing markers from project " + String.valueOf(project), e);
            }
        }
    }

    @Override
    public void addMavenDependency(MavenDependency dependency2) {
        this.runNotifyingDependencyChanges(() -> this.addDependency(dependency2));
    }

    @Override
    public void addMavenDependencies(List<MavenDependency> dependencies) {
        this.runNotifyingDependencyChanges(() -> this.addDependencies(dependencies));
    }

    @Override
    public void removeMavenDependency(MavenDependency dependency2) {
        this.runNotifyingDependencyChanges(() -> this.removeDependency(dependency2));
    }

    public void setProjectType(ProjectType projectType) {
        Optional<Plugin> mulePackagerPlugin = this.getMulePlugin();
        if (mulePackagerPlugin.isPresent()) {
            Plugin plugin = mulePackagerPlugin.get();
            this.editPluginConfiguration(plugin.getGroupId(), plugin.getArtifactId(), xmlEditorHelper -> {
                xmlEditorHelper.getOrCreateElement("classifier").setValue(projectType.projectType());
                return true;
            });
        } else {
            MuleCorePlugin.logWarning("Mule maven plugin could not be found, please check your pom.xml");
        }
    }

    public void removeMulePluginClassifier() {
        this.getMulePlugin().ifPresent(plugin -> this.editPluginConfiguration(plugin.getGroupId(), plugin.getArtifactId(), xmlEditorHelper -> {
            xmlEditorHelper.getOrCreateElement("classifier").remove();
            return true;
        }));
    }

    private Optional<Plugin> getMulePlugin() {
        MavenModelHelper mavenModelHelper = this.pomFileHandler.getMavenModelHelper();
        return Optional.ofNullable(mavenModelHelper.findMulePlugin());
    }

    public Optional<ProjectType> getProjectType() {
        Optional<Plugin> mulePackagerPlugin = this.getMulePlugin();
        Optional<ProjectType> result = Optional.empty();
        if (mulePackagerPlugin.isPresent()) {
            Plugin plugin = mulePackagerPlugin.get();
            XmlEditingHelper editorHelperForPluginConfiguration = this.getEditorHelperForPluginConfiguration(plugin.getGroupId(), plugin.getArtifactId());
            try {
                XmlEditingHelper findChild = editorHelperForPluginConfiguration.findChild("pom:configuration/pom:classifier");
                if (findChild != null) {
                    result = ProjectType.getProjectTypeFromValue(findChild.getNode().getTextContent());
                }
            }
            catch (XPathExpressionException e) {
                e.printStackTrace();
            }
        } else {
            MuleCorePlugin.logWarning("Mule maven plugin could not be found, please check your pom.xml");
        }
        return result;
    }

    @Override
    public List<MavenDependency> getAPISpecDependencies() {
        if (this.isPomWellFormed()) {
            List dependencies = this.pomFileHandler.getMavenModel().getDependencies();
            return dependencies.stream().filter(this::isApiSpecDep).map(this::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public Optional<MavenDependency> getDomainDependency() {
        if (this.isPomWellFormed()) {
            List dependencies = this.pomFileHandler.getMavenModel().getDependencies();
            return dependencies.stream().filter(this::isMuleDomainDependency).map(this::convert).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public void setDomainDependency(Optional<MavenDependency> newDomainDependency) {
        Optional<MavenDependency> currentDomainDependency = this.getDomainDependency();
        this.runNotifyingDependencyChanges(() -> {
            currentDomainDependency.ifPresent(this::removeDependency);
            newDomainDependency.ifPresent(this::addDependency);
        });
    }

    @Override
    public List<MavenDependency> getDataWeaveDependencies() {
        if (this.isPomWellFormed()) {
            List dependencies = this.pomFileHandler.getMavenModel().getDependencies();
            return dependencies.stream().filter(this::isDwLibraryDep).map(d -> this.convert((Dependency)d)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<MavenDependency> getAsyncAPISpecDependencies() {
        if (this.isPomWellFormed()) {
            List dependencies = this.pomFileHandler.getMavenModel().getDependencies();
            return dependencies.stream().filter(this::isAsyncApiDep).map(this::convert).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<MavenDependency> getAllAPIDependencies() {
        if (this.isPomWellFormed()) {
            ArrayList<MavenDependency> apiDependencies = new ArrayList<MavenDependency>();
            apiDependencies.addAll(this.getAPISpecDependencies());
            apiDependencies.addAll(this.getAsyncAPISpecDependencies());
            return apiDependencies;
        }
        return Collections.emptyList();
    }

    private static class DomConfiguration
    implements MavenBuildPlugin.Configuration {
        private Xpp3Dom configurationDom;

        public DomConfiguration(Xpp3Dom configurationDom) {
            this.configurationDom = configurationDom;
        }

        @Override
        public Optional<MavenBuildPlugin.Configuration> getChild(String name) {
            Xpp3Dom child = this.configurationDom.getChild(name);
            return child == null ? Optional.empty() : Optional.of(new DomConfiguration(child));
        }

        @Override
        public List<MavenBuildPlugin.Configuration> getChildren(String name) {
            return Stream.of(this.configurationDom.getChildren(name)).map(DomConfiguration::new).collect(Collectors.toList());
        }

        @Override
        public String getValue() {
            return this.configurationDom.getValue();
        }

        @Override
        public List<MavenBuildPlugin.Configuration> getChildren() {
            return Stream.of(this.configurationDom.getChildren()).map(DomConfiguration::new).collect(Collectors.toList());
        }

        @Override
        public String getName() {
            return this.configurationDom.getName();
        }
    }
}

