/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.xpath.jaxp.XPathFactoryImpl;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class PomDOMUtils {
    private static final String XML_POM_NAMESPACE_PREFIX = "http://maven.apache.org/POM/";
    private static final String XML_POM_NAMESPACE = "http://maven.apache.org/POM/4.0.0";
    private static final String XML_PREFIX_POM = "pom";
    private static NamespaceContext namespaceContext;
    private static XPathFactory xPathfactory;

    static {
        xPathfactory = PomDOMUtils.initializeXPathFactory();
    }

    private static XPathFactory initializeXPathFactory() {
        XPathFactory factory;
        try {
            factory = XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", XPathFactoryImpl.class.getName(), XPathFactoryImpl.class.getClassLoader());
        }
        catch (XPathFactoryConfigurationException e) {
            MuleCorePlugin.logError("Error initializing DOM/XPATH libraries", e);
            throw new RuntimeException(e);
        }
        return factory;
    }

    public static boolean hasChildElements(Node node) {
        boolean hasChildren = false;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (!hasChildren && i < childNodes.getLength()) {
            short type = childNodes.item(i).getNodeType();
            hasChildren = type == 1 || type == 8;
            ++i;
        }
        return hasChildren;
    }

    public static Node getElement(Document pomDocument, String name) {
        NodeList elementsByTagName = pomDocument.getElementsByTagName(name);
        if (elementsByTagName.getLength() == 0) {
            return null;
        }
        return elementsByTagName.item(0);
    }

    public static Node getChild(Node node, String name) {
        Node targetNode = null;
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (name.equals(item.getNodeName())) {
                targetNode = item;
            }
            ++i;
        }
        return targetNode;
    }

    public static List<Node> getChildren(Node node, String name) {
        ArrayList<Node> collectedChildren = new ArrayList<Node>();
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (name.equals(item.getNodeName())) {
                collectedChildren.add(item);
            }
            ++i;
        }
        return collectedChildren;
    }

    public static Node getFirstChild(Node node, String name) {
        NodeList childNodes = node.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node item = childNodes.item(i);
            if (name.equals(item.getNodeName())) {
                return item;
            }
            ++i;
        }
        return null;
    }

    public static Node getOrCreateChild(Node node, String name) {
        Node child = PomDOMUtils.getChild(node, name);
        if (child == null) {
            child = PomDOMUtils.appendNewChild(node, name);
        }
        return child;
    }

    public static Node getOrCreateChildBeforeNode(Node node, String name, String siblingName) {
        Node child = PomDOMUtils.getChild(node, name);
        if (child == null) {
            Node siblingNode = PomDOMUtils.getChild(node, siblingName);
            child = PomDOMUtils.insertBeforeNode(node, siblingNode, name);
        }
        return child;
    }

    public static Node createDomDependency(Document document, Dependency newDependency) {
        Element newDependencyNode = document.createElement("dependency");
        Element groupIdNode = document.createElement("groupId");
        groupIdNode.setTextContent(newDependency.getGroupId());
        newDependencyNode.appendChild(groupIdNode);
        Element artifactIdNode = document.createElement("artifactId");
        artifactIdNode.setTextContent(newDependency.getArtifactId());
        newDependencyNode.appendChild(artifactIdNode);
        Element versionNode = document.createElement("version");
        versionNode.setTextContent(newDependency.getVersion());
        newDependencyNode.appendChild(versionNode);
        if (StringUtils.isNotBlank((String)newDependency.getClassifier())) {
            Element classifierNode = document.createElement("classifier");
            classifierNode.setTextContent(newDependency.getClassifier());
            newDependencyNode.appendChild(classifierNode);
        }
        if (!MavenDependency.Scope.COMPILE.asString().equals(newDependency.getScope())) {
            Element scopeNode = document.createElement("scope");
            scopeNode.setTextContent(newDependency.getScope());
            newDependencyNode.appendChild(scopeNode);
        }
        if (StringUtils.isNotBlank((String)newDependency.getType()) && !"jar".equals(newDependency.getType())) {
            Element typeNode = document.createElement("type");
            typeNode.setTextContent(newDependency.getType());
            newDependencyNode.appendChild(typeNode);
        }
        if (StringUtils.isNotBlank((String)newDependency.getSystemPath())) {
            Element systemPathNode = document.createElement("systemPath");
            systemPathNode.setTextContent(newDependency.getSystemPath());
            newDependencyNode.appendChild(systemPathNode);
        }
        if (newDependency.isOptional()) {
            Element optionalNode = document.createElement("optional");
            optionalNode.setTextContent("true");
            newDependencyNode.appendChild(optionalNode);
        }
        return newDependencyNode;
    }

    public static Element appendNewChild(Node node, String newChildName) {
        Element newElement = node.getOwnerDocument().createElement(newChildName);
        PomDOMUtils.appendChild(node, newElement);
        return newElement;
    }

    public static Element insertBeforeNode(Node node, Node siblingNode, String newChildName) {
        Element newElement = node.getOwnerDocument().createElement(newChildName);
        PomDOMUtils.insertBefore(node, siblingNode, newElement);
        return newElement;
    }

    private static void insertBefore(Node node, Node siblingNode, Element newElement) {
        node.insertBefore(newElement, siblingNode);
    }

    public static void appendChild(Node node, Node newElement) {
        node.appendChild(newElement);
    }

    public static Element appendNewChild(Node node, String newChildName, String newChildTextContent) {
        Element newElement = node.getOwnerDocument().createElement(newChildName);
        newElement.setTextContent(newChildTextContent);
        PomDOMUtils.appendChild(node, newElement);
        return newElement;
    }

    public static Node findElementMatching(NodeList nodeList, String groupId, String artifactId) {
        Node targetNode = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            NodeList nodeSubElements = node.getChildNodes();
            boolean artifactIdMatches = false;
            boolean groupIdMatches = false;
            int j = 0;
            while (j < nodeSubElements.getLength()) {
                Node pluginElement = nodeSubElements.item(j);
                if ("groupId".equals(pluginElement.getNodeName())) {
                    groupIdMatches = groupId.equals(pluginElement.getTextContent());
                } else if ("artifactId".equals(pluginElement.getNodeName())) {
                    artifactIdMatches = artifactId.equals(pluginElement.getTextContent());
                }
                ++j;
            }
            if (artifactIdMatches && groupIdMatches) {
                targetNode = node;
            }
            ++i;
        }
        return targetNode;
    }

    public static void removeChildNode(Node parentNode, Node nodeToBeRemoved) {
        if (PomDOMUtils.isWhitespaceTextNode(nodeToBeRemoved.getPreviousSibling())) {
            parentNode.removeChild(nodeToBeRemoved.getPreviousSibling());
        } else if (PomDOMUtils.isWhitespaceTextNode(nodeToBeRemoved.getNextSibling())) {
            parentNode.removeChild(nodeToBeRemoved.getNextSibling());
        }
        parentNode.removeChild(nodeToBeRemoved);
    }

    private static boolean isWhitespaceTextNode(Node node) {
        return node != null && node.getNodeType() == 3 && StringUtils.isBlank((String)((Text)node).getNodeValue());
    }

    public static Node find(String xpathExpression, Node node) throws XPathExpressionException {
        XPathExpression expression = PomDOMUtils.compile(xpathExpression);
        Node result = (Node)expression.evaluate(node, XPathConstants.NODE);
        return result;
    }

    private static XPathExpression compile(String xpathExpression) throws XPathExpressionException {
        XPath xpath = xPathfactory.newXPath();
        xpath.setNamespaceContext(PomDOMUtils.getNamespaceContext());
        return xpath.compile(xpathExpression);
    }

    private static NamespaceContext getNamespaceContext() {
        if (namespaceContext == null) {
            namespaceContext = new NamespaceContext(){

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    return namespaceURI.startsWith(PomDOMUtils.XML_POM_NAMESPACE_PREFIX) ? Arrays.asList(PomDOMUtils.XML_PREFIX_POM).iterator() : Collections.emptyList().iterator();
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return namespaceURI.startsWith(PomDOMUtils.XML_POM_NAMESPACE_PREFIX) ? PomDOMUtils.XML_PREFIX_POM : null;
                }

                @Override
                public String getNamespaceURI(String prefix) {
                    return PomDOMUtils.XML_PREFIX_POM.equals(prefix) ? PomDOMUtils.XML_POM_NAMESPACE : "";
                }
            };
        }
        return namespaceContext;
    }

    public static boolean isRootNode(Node node) {
        return node.getParentNode() == node.getOwnerDocument();
    }
}

