/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.builder.ICleanerDelegate;
import org.mule.tooling.core.builder.MuleBuilderExtensionProvider;
import org.mule.tooling.core.event.PomChangedEvent;
import org.mule.tooling.core.event.PomDeletedEvent;
import org.mule.tooling.utils.eventbus.IEvent;

public class PomBuilderExtensionProvider
implements MuleBuilderExtensionProvider {
    @Override
    public IResourceDeltaVisitor getResourceDeltaVisitor() {
        return this::visitResourceDelta;
    }

    protected boolean visitResourceDelta(IResourceDelta delta) {
        IResource resource = delta.getResource();
        if (resource != null && "pom.xml".equals(resource.getName()) && resource.getFullPath().segmentCount() == 2) {
            IProject project = resource.getProject();
            if (this.hasFlag(delta, 2)) {
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new PomDeletedEvent(resource, project));
            } else if (this.hasFlag(delta, 4) || this.hasFlag(delta, 1)) {
                MuleCorePlugin.getEventBus().fireEvent((IEvent)PomChangedEvent.fileChanged(resource, project));
            }
        }
        return resource instanceof IProject;
    }

    private boolean hasFlag(IResourceDelta delta, int flag) {
        return (delta.getKind() & flag) != 0;
    }

    @Override
    public ICleanerDelegate getCleanerDelegate() {
        return null;
    }

    @Override
    public IResourceVisitor getResourceVisitor() {
        return null;
    }
}

