/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.velocity.exception.VelocityException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.auth.PlatformUrls;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.m2.ExchangeMavenFacade;
import org.mule.tooling.core.m2.PomDefaults;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.inspect.DefaultMavenJarfileInspector;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.utils.exception.IllegalCreationException;

public class MavenResourceUtils {
    public static final String DEFAULT_TYPE = "jar";
    public static final String POM_TYPE = "pom";
    public static final String TEMP_POM_FILE = ".org.mule.tooling.pom";
    private static final String VELOCITY_KEY_MODULES = "extensions";
    private static final String VELOCITY_KEY_MULE_VERSION = "muleVersion";
    private static final String VELOCITY_KEY_EE = "EE";
    private static final String VELOCITY_KEY_MULE_MAVEN_PLUGIN_VERSION = "muleMavenPluginVersion";
    private static final String VELOCITY_KEY_VERSION = "version";
    private static final String VELOCITY_KEY_ARTIFACT_ID = "artifactId";
    private static final String VELOCITY_KEY_GROUP_ID = "groupId";
    private static final String VELOCITY_KEY_MAVEN_FACADE_ID = "mavenFacadeId";
    private static final String VELOCITY_KEY_MAVEN_FACADE_URL = "mavenFacadeUrl";
    public static final String POM_FILENAME = "pom.xml";
    public static final String SETTINGS_XML = "settings.xml";
    private static final String POM_TEMPLATE_PATH = "/templates/pom.xml.tmpl";
    private static final String SETTINGS_TEMPLATE_PATH = "/templates/settings.xml";
    private static final String DOMAIN_POM_TEMPLATE_PATH = "/templates/domain/pom.xml.tmpl";

    private MavenResourceUtils() {
        throw new IllegalCreationException();
    }

    public static File getEmptySettingsFile() {
        File settingsFile = MuleCorePlugin.getDataFile(SETTINGS_XML);
        if (!settingsFile.exists()) {
            try {
                MavenResourceUtils.writeEmptySettingsFile(settingsFile);
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot write empty settings.xml file to the workspace", e);
            }
        }
        return settingsFile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeEmptySettingsFile(File settingsFile) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            InputStream settingsStream = MavenResourceUtils.class.getResourceAsStream(SETTINGS_TEMPLATE_PATH);
            try {
                try (FileOutputStream fileOutputStream = new FileOutputStream(settingsFile);){
                    String settingsContents = IOUtils.toString((InputStream)settingsStream);
                    IOUtils.write((String)settingsContents, (OutputStream)fileOutputStream);
                }
                if (settingsStream == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (settingsStream == null) throw throwable;
                settingsStream.close();
                throw throwable;
            }
            settingsStream.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static void createPomFile(MuleProjectKind<?> muleProjectKind, IJavaProject project, IServerDefinition serverDefinition, MavenDependency mavenModel) throws CoreException {
        MavenResourceUtils.createPomFile(muleProjectKind, project, serverDefinition, mavenModel, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void createPomFile(MuleProjectKind<?> muleProjectKind, IJavaProject project, IServerDefinition serverDefinition, MavenDependency mavenModel, IProgressMonitor monitor) throws CoreException {
        MavenResourceUtils.createPomFile(POM_FILENAME, true, muleProjectKind, project, serverDefinition, mavenModel, monitor);
    }

    public static IFile createPomFile(String pomFileName, Boolean addDefaultExtensions, MuleProjectKind<?> muleProjectKind, IJavaProject project, IServerDefinition serverDefinition, MavenDependency mavenModel, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        IFile pomFile = project.getProject().getFile(pomFileName);
        byte[] pomContents = MavenResourceUtils.getNewPomFileContents(addDefaultExtensions, muleProjectKind, serverDefinition, mavenModel);
        subMonitor.beginTask("Creating pom.xml for project: " + project.getProject().getName(), 100);
        subMonitor.worked(30);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(pomContents);
        pomFile.create((InputStream)byteArrayInputStream, false, (IProgressMonitor)subMonitor.split(40));
        pomFile.setDerived(false, (IProgressMonitor)subMonitor.split(30));
        return pomFile;
    }

    /*
     * Loose catch block
     */
    public static byte[] getNewPomFileContents(Boolean addDefaultExtensions, MuleProjectKind<?> muleProjectKind, IServerDefinition serverDefinition, MavenDependency mavenModel) throws CoreException {
        try {
            String pomTemplatePath;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            if (MuleProjectKind.APPLICATION.equals(muleProjectKind)) {
                pomTemplatePath = POM_TEMPLATE_PATH;
            } else if (MuleProjectKind.DOMAIN.equals(muleProjectKind)) {
                pomTemplatePath = DOMAIN_POM_TEMPLATE_PATH;
            } else {
                throw new NotImplementedException("still not implementing maven support for custom policies");
            }
            InputStream pomTemplateResource = MavenResourceUtils.class.getResourceAsStream(pomTemplatePath);
            Throwable throwable = null;
            Object var8_10 = null;
            try {
                byte[] byArray;
                OutputStreamWriter writer;
                InputStreamReader reader;
                block22: {
                    block21: {
                        reader = new InputStreamReader(pomTemplateResource, StandardCharsets.UTF_8);
                        writer = new OutputStreamWriter((OutputStream)byteArrayOutputStream, StandardCharsets.UTF_8);
                        Optional<List<MavenDependency>> defaultExtensions = addDefaultExtensions != false ? Optional.ofNullable(MavenCore.getPomDefaultsHandlerManager().findProviderFor(serverDefinition).getNewProjectDefaultExtensions()) : Optional.empty();
                        MavenResourceUtils.performPomReplacements(serverDefinition, reader, writer, mavenModel, defaultExtensions);
                        ((Writer)writer).flush();
                        byArray = byteArrayOutputStream.toByteArray();
                        if (writer == null) break block21;
                        ((Writer)writer).close();
                    }
                    if (reader == null) break block22;
                    ((Reader)reader).close();
                }
                return byArray;
                {
                    catch (Throwable throwable2) {
                        try {
                            if (writer != null) {
                                ((Writer)writer).close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (reader != null) {
                                ((Reader)reader).close();
                            }
                            throw throwable;
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException | VelocityException e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.core", "Unable to generate pom.xml file", e));
        }
    }

    private static void performPomReplacements(IServerDefinition serverDefinition, Reader reader, Writer writer, MavenDependency mavenModel, Optional<List<MavenDependency>> defaultExtensions) throws IOException {
        String muleVersion = serverDefinition.getVersionWithSuffix();
        String isEnterprise = String.valueOf(serverDefinition.isEnterpriseRuntime());
        ArrayList contextKeyValues = Lists.newArrayList((Object[])new Object[]{VELOCITY_KEY_GROUP_ID, mavenModel.getGroupId(), VELOCITY_KEY_ARTIFACT_ID, mavenModel.getArtifactId(), VELOCITY_KEY_VERSION, mavenModel.getVersion(), VELOCITY_KEY_MULE_MAVEN_PLUGIN_VERSION, PomDefaults.Pom_defaults_muleMavenPluginVersion, VELOCITY_KEY_EE, isEnterprise, VELOCITY_KEY_MULE_VERSION, muleVersion, VELOCITY_KEY_MAVEN_FACADE_ID, ExchangeMavenFacade.getCurrentId(), VELOCITY_KEY_MAVEN_FACADE_URL, PlatformUrls.getMavenFacadeUrl()});
        if (defaultExtensions.isPresent()) {
            contextKeyValues.add(VELOCITY_KEY_MODULES);
            contextKeyValues.add(defaultExtensions.get());
        }
        MuleResourceUtils.executeVelocityTemplate(MavenResourceUtils.class.getClassLoader(), reader, writer, contextKeyValues.toArray());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isMavenBased(ExternalContributionMuleModule module) {
        File contributionJar = module.getContributionJarFile();
        if (contributionJar == null) return false;
        if (!contributionJar.exists()) return false;
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (JarFile moduleJarFile = new JarFile(contributionJar);){
                JarEntry jarEntry;
                Enumeration<JarEntry> entries = moduleJarFile.entries();
                do {
                    if (entries.hasMoreElements()) continue;
                    return false;
                } while (!(jarEntry = entries.nextElement()).getName().endsWith(POM_FILENAME));
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Problem reading the module's jar file. Module: " + module.getName() + ", Jar file: " + String.valueOf(module.getContributionJarFile()), e);
        }
    }

    public static boolean isMavenBased(JarFile jarFile) {
        try {
            return DefaultMavenJarfileInspector.hasMavenMetadata(jarFile);
        }
        catch (IOException iOException) {
            MuleCorePlugin.logError("Problem reading jar file: " + jarFile.getName(), new RuntimeException().fillInStackTrace());
            return false;
        }
    }

    public static String getRepositoryPath(MavenDependency artifact, String pathSeparator) {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        Optional<String> classifier = artifact.getClassifier();
        Optional<String> type = artifact.getType();
        return MavenResourceUtils.getRepositoryPath(groupId, artifactId, version, classifier, type, pathSeparator);
    }

    public static String getRepositoryPath(String groupId, String artifactId, String version, Optional<String> classifier, Optional<String> type, String pathSeparator) {
        StringBuilder builder = new StringBuilder();
        String[] stringArray = groupId.split("\\.");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String groupSegment = stringArray[n2];
            builder.append(groupSegment);
            builder.append(pathSeparator);
            ++n2;
        }
        builder.append(artifactId).append(pathSeparator).append(version).append(pathSeparator).append(artifactId).append("-").append(version);
        if (classifier.isPresent()) {
            builder.append("-").append(classifier.get());
        }
        builder.append(".").append(type.orElse(DEFAULT_TYPE));
        return builder.toString();
    }
}

