/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.mule.tooling.core.m2.IMavenPropertyResolver;
import org.mule.tooling.core.m2.internal.PomFileHandler;

public class MavenPropertyResolver
implements IMavenPropertyResolver {
    private static final int MAX_DEPTH = 128;
    private PomFileHandler pomFileHandler;
    private Properties systemProperties;

    public MavenPropertyResolver(PomFileHandler pomFileHandler) {
        this.pomFileHandler = pomFileHandler;
        this.systemProperties = (Properties)System.getProperties().clone();
    }

    @Override
    public String resolveProperties(String propertyToResolve) {
        if (propertyToResolve != null) {
            return this.doResolve(0, propertyToResolve);
        }
        return "";
    }

    private String doResolve(int depth, String propertyToResolve) {
        if (depth > 128) {
            throw new RuntimeException("Cannot resolve property " + propertyToResolve + " since it appears to be in a recursive loop");
        }
        propertyToResolve = this.replaceProjectProperties(propertyToResolve);
        propertyToResolve = this.replaceSystemProperties(propertyToResolve);
        propertyToResolve = this.resolveUnknownProperties(depth, propertyToResolve);
        return propertyToResolve;
    }

    private String resolveUnknownProperties(int depth, String propertyToResolve) {
        Matcher matcher = Pattern.compile("\\$\\{([^\\}]+)\\}").matcher(propertyToResolve);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            Optional<String> property = this.getProperty(propertyName);
            if (!property.isPresent()) continue;
            String result = this.doResolve(++depth, property.get());
            propertyToResolve = propertyToResolve.replaceAll(this.property(propertyName), result);
        }
        return propertyToResolve;
    }

    private Optional<String> getProperty(String propertyName) {
        return Optional.ofNullable(this.pomFileHandler.getMavenModel().getProperties()).map(properties -> properties.getProperty(propertyName));
    }

    private String replaceSystemProperties(String propertyToResolve) {
        String resolvedProperty = propertyToResolve;
        for (Map.Entry<Object, Object> entry : this.systemProperties.entrySet()) {
            resolvedProperty = this.getProjectProperty(propertyToResolve, (String)entry.getKey()).map(p -> propertyToResolve.replaceAll((String)p, (String)entry.getValue())).orElse(resolvedProperty);
        }
        return resolvedProperty;
    }

    private String replaceProjectProperties(String propertyToResolve) {
        if (!this.pomFileHandler.isPomWellFormed()) {
            if (this.pomFileHandler.getPomFile() != null) {
                throw new IllegalStateException("Trying to execute an operation over project " + this.pomFileHandler.getPomFile().getPath() + " , which pom file is not well formed");
            }
            throw new IllegalStateException("Trying to execute an operation over a project which pom file is not well formed");
        }
        Model mavenModel = this.pomFileHandler.getMavenModel();
        propertyToResolve = this.replaceProperty(propertyToResolve, "artifactId", mavenModel.getArtifactId());
        propertyToResolve = this.replaceProperty(propertyToResolve, "groupId", mavenModel.getGroupId());
        propertyToResolve = this.replaceProperty(propertyToResolve, "version", mavenModel.getVersion());
        Parent parent = mavenModel.getParent();
        if (parent != null) {
            propertyToResolve = this.replaceProperty(propertyToResolve, "artifactId", parent.getArtifactId());
            propertyToResolve = this.replaceProperty(propertyToResolve, "groupId", parent.getGroupId());
            propertyToResolve = this.replaceProperty(propertyToResolve, "version", parent.getVersion());
        }
        return propertyToResolve;
    }

    private String replaceProperty(String propertyToResolve, String propertyName, String propertyValue) {
        if (propertyValue != null) {
            return this.getProjectProperty(propertyToResolve, propertyName).map(property -> propertyToResolve.replaceAll((String)property, propertyValue)).orElse(propertyToResolve);
        }
        return propertyToResolve;
    }

    private Optional<String> getProjectProperty(String propertyToResolve, String property) {
        return this.getPropertyIfExist(propertyToResolve, this.property(property), this.property("project." + property));
    }

    private Optional<String> getPropertyIfExist(String propertyToResolve, String ... property) {
        String[] stringArray = property;
        int n = property.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            if (propertyToResolve.matches(".*" + prop + ".*")) {
                return Optional.of(prop);
            }
            ++n2;
        }
        return Optional.empty();
    }

    private String property(String name) {
        return "\\$\\{" + name + "\\}";
    }
}

