/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Repository;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.packageManager.PackagingOptions;
import org.mule.tools.api.packager.packaging.PackagingType;

public class MavenModelHelper {
    private static final String PACKAGE_GOAL = "package";
    private static final String CLASSIFIER = "classifier";
    private static final String LIGHTWEIGHT_PACKAGE = "lightweightPackage";
    public static final String ORG_MULE_TOOLS_MAVEN = "org.mule.tools.maven";
    public static final String MULE_MAVEN_PLUGIN = "mule-maven-plugin";
    private static final String DEFAULT_FINALNAME = "${project.artifactId}-${project.version}";
    private Map<Properties, Build> buildWithProperties = new HashMap<Properties, Build>();
    private Model pomModel;

    public static MavenModelHelper from(File pomFile) throws FileNotFoundException, IOException {
        Model model = null;
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream pomStream = new FileInputStream(pomFile);){
            try {
                model = new MavenXpp3Reader().read((InputStream)pomStream);
            }
            catch (XmlPullParserException e) {
                throw new IllegalArgumentException("Parse error reading " + pomFile.getAbsolutePath(), e);
            }
            model.setPomFile(pomFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return new MavenModelHelper(model);
    }

    public MavenModelHelper(Model pomModel) {
        this.pomModel = pomModel;
    }

    public Plugin findMulePlugin() {
        Plugin mulePlugin = this.getPlugin(ORG_MULE_TOOLS_MAVEN, MULE_MAVEN_PLUGIN);
        if (mulePlugin == null) {
            String message = "Unable to determine Mule packaging plugin for pom file: " + this.pomModel.getPomFile().getAbsolutePath();
            MuleCorePlugin.logWarning(message, new IllegalArgumentException(message).fillInStackTrace());
        }
        return mulePlugin;
    }

    public boolean hasMavenMulePlugin() {
        Plugin mulePlugin = this.findMulePlugin();
        return mulePlugin != null;
    }

    public boolean hasInclusion(Dependency includedArtifact) {
        Plugin mulePlugin = this.findMulePlugin();
        if (mulePlugin == null) {
            return false;
        }
        Xpp3Dom configuration = (Xpp3Dom)mulePlugin.getConfiguration();
        Xpp3Dom inclusions = configuration.getChild("inclusions");
        if (inclusions == null) {
            return false;
        }
        Xpp3Dom[] inclusionElements = inclusions.getChildren();
        if (inclusionElements.length > 0) {
            Xpp3Dom[] xpp3DomArray = inclusionElements;
            int n = inclusionElements.length;
            int n2 = 0;
            while (n2 < n) {
                Xpp3Dom inclusionElement = xpp3DomArray[n2];
                Xpp3Dom inclusionElementGroupId = inclusionElement.getChild("groupId");
                Xpp3Dom inclusionElementArtifactId = inclusionElement.getChild("artifactId");
                if (inclusionElementGroupId != null && inclusionElementArtifactId != null) {
                    String inclusionGroupId = inclusionElementGroupId.getValue();
                    String inclusionArtifactId = inclusionElementArtifactId.getValue();
                    if (includedArtifact.getGroupId().equals(inclusionGroupId) && includedArtifact.getArtifactId().equals(inclusionArtifactId)) {
                        return true;
                    }
                }
                ++n2;
            }
        }
        return false;
    }

    public Plugin getPlugin(String groupId, String artifactId) {
        Build buildElement = this.pomModel.getBuild();
        if (buildElement == null) {
            return null;
        }
        List plugins = buildElement.getPlugins();
        if (plugins.isEmpty()) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!groupId.equals(plugin.getGroupId()) || !artifactId.equals(plugin.getArtifactId())) continue;
            return plugin;
        }
        return null;
    }

    public void addInclusion(Dependency newDependency) {
        Plugin mulePlugin = this.findMulePlugin();
        Xpp3Dom configuration = (Xpp3Dom)mulePlugin.getConfiguration();
        Xpp3Dom inclusionsElement = configuration.getChild("inclusions");
        if (inclusionsElement == null) {
            inclusionsElement = new Xpp3Dom("inclusions");
            configuration.addChild(inclusionsElement);
        }
        Dependency clone = newDependency.clone();
        clone.setVersion(null);
        inclusionsElement.addChild(MavenModelHelper.buildNewInclusion(clone));
    }

    private static Xpp3Dom buildNewInclusion(Dependency newDependency) {
        Xpp3Dom newInclusion = MavenModelHelper.buildNewGAVelementWithName("inclusion", newDependency);
        return newInclusion;
    }

    public static Xpp3Dom buildNewGAVelementWithName(String name, Dependency dependency2) {
        Xpp3Dom elementGroupId = new Xpp3Dom("groupId");
        elementGroupId.setValue(dependency2.getGroupId());
        Xpp3Dom elementArtifactId = new Xpp3Dom("artifactId");
        elementArtifactId.setValue(dependency2.getArtifactId());
        Xpp3Dom newElement = new Xpp3Dom(name);
        newElement.addChild(elementGroupId);
        newElement.addChild(elementArtifactId);
        if (dependency2.getVersion() != null) {
            Xpp3Dom elementVersion = new Xpp3Dom("version");
            elementVersion.setValue(dependency2.getVersion());
            newElement.addChild(elementVersion);
        }
        return newElement;
    }

    public String getArtifactFinalName(Properties properties) {
        String finalName;
        Build buildElement;
        boolean differentProperties = properties.entrySet().stream().anyMatch(property -> {
            Properties modelProperties = this.pomModel.getProperties();
            if (modelProperties != null) {
                return !property.getValue().equals(modelProperties.get(property.getKey()));
            }
            return false;
        });
        Build build = buildElement = differentProperties ? this.getBuildWithProperties(properties) : this.pomModel.getBuild();
        if (buildElement != null && (finalName = buildElement.getFinalName()) != null) {
            return finalName;
        }
        return DEFAULT_FINALNAME;
    }

    private Build getBuildWithProperties(Properties properties) {
        Build buildElement;
        if (this.buildWithProperties.containsKey(properties)) {
            return this.buildWithProperties.get(properties);
        }
        try {
            ModelBuildingResult modelResult = MavenCore.getMavenModelReader().readModel(this.pomModel.getPomFile(), Collections.emptyList(), properties);
            Model mavenModel = modelResult.getEffectiveModel() != null ? modelResult.getEffectiveModel() : modelResult.getRawModel();
            buildElement = mavenModel.getBuild();
        }
        catch (IOException | ModelBuildingException e) {
            MuleCorePlugin.logWarning("Unable to parse " + String.valueOf(this.pomModel.getPomFile()) + ". " + e.getMessage(), e);
            buildElement = this.pomModel.getBuild();
        }
        this.buildWithProperties.put(properties, buildElement);
        return buildElement;
    }

    public Optional<String> getClassifier(PackagingOptions packagingOptions) {
        Plugin mulePlugin = this.findMulePlugin();
        Optional<String> executionLightweightPackage = Optional.empty();
        Optional<String> executionClassifier = Optional.empty();
        Optional<Object> configurationLightweightPackage = Optional.empty();
        Optional<Object> configurationClassifier = Optional.empty();
        if (mulePlugin != null) {
            configurationLightweightPackage = this.findInConfiguration((Xpp3Dom)mulePlugin.getConfiguration(), LIGHTWEIGHT_PACKAGE);
            configurationClassifier = this.findInConfiguration((Xpp3Dom)mulePlugin.getConfiguration(), CLASSIFIER);
            List executions = mulePlugin.getExecutions();
            if (executions != null && !executions.isEmpty()) {
                Optional<PluginExecution> packageExecution = executions.stream().filter(execution -> execution.getGoals().contains(PACKAGE_GOAL)).findFirst();
                executionLightweightPackage = packageExecution.flatMap(execution -> this.findInConfiguration((Xpp3Dom)execution.getConfiguration(), LIGHTWEIGHT_PACKAGE));
                executionClassifier = packageExecution.flatMap(execution -> this.findInConfiguration((Xpp3Dom)execution.getConfiguration(), CLASSIFIER));
            }
        }
        Optional configurationClassifierFinal = configurationClassifier;
        StringBuilder classifierBuilder = new StringBuilder();
        executionClassifier.map(classifier -> classifierBuilder.append((String)classifier)).orElseGet(() -> classifierBuilder.append(configurationClassifierFinal.orElse("")));
        String packaging = this.pomModel.getPackaging();
        PackagingType packagingType = this.getPackagingType(packaging);
        if (packagingType != null) {
            boolean lightweightPackage = Boolean.valueOf(executionLightweightPackage.orElse(configurationLightweightPackage.orElse(Boolean.toString(packagingOptions.isLightweightPackage()))));
            boolean testPackage = packagingOptions.isTestJar();
            return Optional.of(packagingType.resolveClassifier(classifierBuilder.toString(), lightweightPackage, testPackage));
        }
        return Optional.empty();
    }

    private PackagingType getPackagingType(String packaging) {
        PackagingType packagingType = null;
        try {
            packagingType = PackagingType.fromString((String)packaging);
        }
        catch (IllegalArgumentException e) {
            MuleCorePlugin.logError("Illegal packaging type " + packaging, e);
        }
        return packagingType;
    }

    public boolean hasRepository(Repository repository) {
        return this.pomModel.getRepositories().contains(repository);
    }

    public Optional<Dependency> getDependency(Dependency dependency2, boolean checkVersion) {
        List existingDependencies = this.pomModel.getDependencies();
        return this.doGetDependency(dependency2, checkVersion, existingDependencies);
    }

    private Optional<Dependency> doGetDependency(Dependency dependency2, boolean checkVersion, List<Dependency> existingDependencies) {
        if (existingDependencies != null) {
            for (Dependency existingDependency : existingDependencies) {
                if (!this.areDependenciesEqual(existingDependency, dependency2, checkVersion)) continue;
                return Optional.ofNullable(existingDependency);
            }
        }
        return Optional.empty();
    }

    private boolean areDependenciesEqual(Dependency existingDependency, Dependency dependency2, boolean checkVersion) {
        boolean versionEquals;
        boolean groupIdEquals = existingDependency.getGroupId().equals(dependency2.getGroupId());
        boolean artifactIdEquals = existingDependency.getArtifactId().equals(dependency2.getArtifactId());
        String existingDependencyVersion = this.getLocalResolvedDependencyVersion(existingDependency.getVersion());
        String dependencyVersion = this.getLocalResolvedDependencyVersion(dependency2.getVersion());
        boolean bothVersionsAreNull = existingDependencyVersion == null && dependencyVersion == null;
        boolean bl = versionEquals = bothVersionsAreNull || existingDependencyVersion != null && existingDependencyVersion.equals(dependencyVersion);
        return groupIdEquals && artifactIdEquals && (versionEquals || !checkVersion);
    }

    private String getLocalResolvedDependencyVersion(String dependencyVersion) {
        return PomMuleProjectModel.isMavenProperty(dependencyVersion) ? this.pomModel.getProperties().getProperty(PomMuleProjectModel.getMavenProperty(dependencyVersion), dependencyVersion) : dependencyVersion;
    }

    public boolean hasDependency(Dependency dependency2, boolean checkVersion) {
        return this.getDependency(dependency2, checkVersion).isPresent();
    }

    public boolean hasDependencyLocal(Dependency convert) {
        Optional<Dependency> dependency2 = this.doGetDependency(convert, true, this.pomModel.getDependencies());
        if (dependency2.isEmpty() && this.pomModel.getDependencyManagement() != null) {
            dependency2 = this.doGetDependency(convert, true, this.pomModel.getDependencyManagement().getDependencies());
        }
        return dependency2.isPresent();
    }

    public boolean hasSharedLibrary(Dependency dependency2) {
        return this.hasSharedLibrary(dependency2.getGroupId(), dependency2.getArtifactId());
    }

    public boolean hasSharedLibrary(String groupId, String artifactId) {
        Xpp3Dom sharedLibs;
        Xpp3Dom configuration;
        Plugin mulePlugin = this.findMulePlugin();
        if (mulePlugin != null && (configuration = (Xpp3Dom)mulePlugin.getConfiguration()) != null && (sharedLibs = configuration.getChild("sharedLibraries")) != null) {
            return this.findElementMatching(sharedLibs.getChildren("sharedLibrary"), groupId, artifactId) != null;
        }
        return false;
    }

    private Xpp3Dom findElementMatching(Xpp3Dom[] children, String groupId, String artifactId) {
        Xpp3Dom targetNode = null;
        int i = 0;
        while (targetNode == null && i < children.length) {
            Xpp3Dom node = children[i];
            Xpp3Dom[] nodeSubElements = node.getChildren();
            boolean artifactIdMatches = false;
            boolean groupIdMatches = false;
            int j = 0;
            while (j < nodeSubElements.length) {
                Xpp3Dom pluginElement = nodeSubElements[j];
                if ("groupId".equals(pluginElement.getName())) {
                    groupIdMatches = groupId.equals(pluginElement.getValue());
                } else if ("artifactId".equals(pluginElement.getName())) {
                    artifactIdMatches = artifactId.equals(pluginElement.getValue());
                }
                ++j;
            }
            if (artifactIdMatches && groupIdMatches) {
                targetNode = node;
            }
            ++i;
        }
        return targetNode;
    }

    private Optional<String> findInConfiguration(Xpp3Dom configuration, String configName) {
        Xpp3Dom child;
        Optional<String> result = Optional.empty();
        if (configuration != null && (child = configuration.getChild(configName)) != null) {
            result = Optional.ofNullable(child.getValue());
        }
        return result;
    }

    public static MavenDependency mavenDependency(String ... coordinates) {
        if (coordinates.length != 3) {
            throw new RuntimeException("Provide 3 coordinates for instantiating the dependency");
        }
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(coordinates[0])).withArtifactId(coordinates[1])).withVersion(coordinates[2])).build();
    }

    public static Dependency dependency(String ... coordinates) {
        if (coordinates.length == 0) {
            throw new RuntimeException("Provide coordinates for instantiating the dependency");
        }
        Dependency dependency2 = new Dependency();
        dependency2.setGroupId(coordinates[0]);
        if (coordinates.length > 1) {
            dependency2.setArtifactId(coordinates[1]);
        }
        if (coordinates.length > 2) {
            dependency2.setVersion(coordinates[2]);
        }
        if (coordinates.length > 3) {
            dependency2.setClassifier(coordinates[3]);
        }
        return dependency2;
    }
}

