/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.mule.tooling.core.m2.Settings;
import org.mule.tooling.core.m2.internal.DefaultSettings;
import org.mule.tooling.core.m2.internal.MavenCore;

public class MavenConfiguration {
    public static MavenConfiguration instance() {
        return Singleton.instance;
    }

    public Settings getSettings() {
        return new DefaultSettings(MavenCore.getUserRepositories());
    }

    public Settings getSettings(File settings) {
        org.apache.maven.settings.Settings customSettings = MavenCore.getSettings(settings);
        if (customSettings != null) {
            return new DefaultSettings(MavenCore.getRepositories(customSettings));
        }
        return null;
    }

    public Optional<String> getUserSettingsPath() throws IOException {
        File userSettingsFile = MavenCore.getUserSettingsFile();
        String path = userSettingsFile.getAbsolutePath();
        return Optional.ofNullable(path);
    }

    public Optional<String> getSettingsSecurityPath() throws IOException {
        return MavenCore.getMavenSettingsSecurity().map(File::getAbsolutePath);
    }

    public String getLocalRepositoryPath() {
        return MavenCore.getM2repoPath();
    }

    public Optional<String> getGlobalSettingsPath() throws IOException {
        String path = null;
        Optional<File> userSettingsFile = MavenCore.getGlobalSettingsFile();
        if (userSettingsFile.isPresent()) {
            path = userSettingsFile.get().getCanonicalPath();
        }
        return Optional.ofNullable(path);
    }

    public Settings getGlobalSettings() {
        return new DefaultSettings(MavenCore.getGlobalRepositories());
    }

    private static class Singleton {
        private static final MavenConfiguration instance = new MavenConfiguration();

        private Singleton() {
        }
    }
}

