/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.util.Arrays;
import java.util.List;
import org.mule.tooling.core.auth.PlatformRegion;
import org.mule.tooling.core.auth.RegionUrlResolver;

public class ExchangeMavenFacade {
    public static final String ID = "anypoint-exchange";
    public static final String ID_FD = "exchange";
    public static final String ID_V2 = "anypoint-exchange-v2";
    public static final String ID_V3 = "anypoint-exchange-v3";
    public static final String REPOSITORY_NAME_V2 = "Anypoint Exchange V2";
    public static final String REPOSITORY_NAME_V3 = "Anypoint Exchange V3";
    private static final List<String> SERVER_IDS = Arrays.asList("anypoint-exchange", "anypoint-exchange-v3", "anypoint-exchange-v2", "exchange");
    private static final List<String> OLD_SERVER_IDS = Arrays.asList("anypoint-exchange", "anypoint-exchange-v2", "exchange");

    public static String getCurrentName() {
        if (ExchangeMavenFacade.isGovCloudEnv()) {
            return REPOSITORY_NAME_V2;
        }
        return REPOSITORY_NAME_V3;
    }

    public static String getCurrentId() {
        if (ExchangeMavenFacade.isGovCloudEnv()) {
            return ID_V2;
        }
        return ID_V3;
    }

    public static String getCurrentAPIVersion() {
        if (ExchangeMavenFacade.isGovCloudEnv()) {
            return "v2";
        }
        return "v3";
    }

    public static List<String> getKnownRepositoryIds() {
        return SERVER_IDS;
    }

    public static List<String> getOldRepositoryIds() {
        return OLD_SERVER_IDS;
    }

    private static boolean isGovCloudEnv() {
        PlatformRegion platformRegion = RegionUrlResolver.getInstance().getPlatformRegion();
        return platformRegion == PlatformRegion.GOV || platformRegion.getPrefix().contentEquals("gstg");
    }
}

