/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.m2;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.mule.tooling.core.m2.IDependencyResolver;

public class DependencyResolutionConfiguration {
    private Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver> resolverFactory;
    private boolean withTests = false;
    private boolean withProvided = false;

    public DependencyResolutionConfiguration includeTestScope() {
        this.withTests = true;
        return this;
    }

    public DependencyResolutionConfiguration excludeTestScope() {
        this.withTests = false;
        return this;
    }

    public DependencyResolutionConfiguration includeProvidedScope() {
        this.withProvided = true;
        return this;
    }

    public DependencyResolutionConfiguration excludeProvidedScope() {
        this.withProvided = false;
        return this;
    }

    public DependencyResolutionConfiguration withResolverFactory(Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver> resolverFactory) {
        this.resolverFactory = resolverFactory;
        return this;
    }

    public boolean isWithTests() {
        return this.withTests;
    }

    public boolean isWithProvided() {
        return this.withProvided;
    }

    public Optional<Function<Consumer<DefaultRepositorySystemSession>, IDependencyResolver>> getResolverFactory() {
        return Optional.ofNullable(this.resolverFactory);
    }

    public static DependencyResolutionConfiguration createDefault() {
        return new DependencyResolutionConfiguration().includeTestScope();
    }
}

