/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.jvm;

import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

@ExtensionPoint(extensionPointId="org.mule.tooling.runtime.launch.javacompatibility")
public class MuleRuntimeJavaCompatibilityExtension {
    public static final Version DEFAULT_UPPER_BOUND = Version.valueOf((String)"999.999.999");
    public static final Version DEFAULT_LOWER_BOUND = Version.emptyVersion;
    @ExtensionAttribute
    private ServerMatcher targetServers;
    @ExtensionAttribute(optional=true)
    private Version lowerBound = DEFAULT_LOWER_BOUND;
    @ExtensionAttribute(optional=true)
    private boolean lowerBoundInclusive = true;
    @ExtensionAttribute(optional=true)
    private Version upperBound = DEFAULT_UPPER_BOUND;
    @ExtensionAttribute(optional=true)
    private boolean upperBoundInclusive = false;

    public ServerMatcher getTargetServers() {
        return this.targetServers;
    }

    public void setTargetServers(ServerMatcher targetServers) {
        this.targetServers = targetServers;
    }

    public VersionRange getCompatibleJavaVersions() {
        char rightType = this.upperBoundInclusive ? (char)']' : ')';
        char leftType = this.lowerBoundInclusive ? (char)'[' : '(';
        return new VersionRange(leftType, this.lowerBound, this.upperBound, rightType);
    }

    public void setLowerBound(Version lowerBound) {
        this.lowerBound = lowerBound;
    }

    public void setLowerBoundInclusive(boolean lowerBoundInclusive) {
        this.lowerBoundInclusive = lowerBoundInclusive;
    }

    public void setUpperBound(Version upperBound) {
        this.upperBound = upperBound;
    }

    public void setUpperBoundInclusive(boolean upperBoundInclusive) {
        this.upperBoundInclusive = upperBoundInclusive;
    }

    public boolean isVersionInRange(Version javaVersion) {
        return this.getCompatibleJavaVersions().includes(javaVersion);
    }

    public boolean matches(IServerDefinition server) {
        return this.targetServers.matches(server);
    }
}

