/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.jvm;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.core.jvm.CompatibilityResult;
import org.mule.tooling.core.jvm.MuleRuntimeJavaCompatibilityExtension;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class MuleRuntimeJavaCompatibilityComputer {
    private List<MuleRuntimeJavaCompatibilityExtension> extensions;

    public static MuleRuntimeJavaCompatibilityComputer createReadingExtensions() {
        return Singleton.instance;
    }

    public MuleRuntimeJavaCompatibilityComputer(List<MuleRuntimeJavaCompatibilityExtension> extensions) {
        this.extensions = new ArrayList<MuleRuntimeJavaCompatibilityExtension>(extensions);
    }

    public CompatibilityResult isJavaVersionCompatible(IServerDefinition server, Version version) {
        Version normalizedVersion = this.getNormalizedJavaVersion(version);
        List<MuleRuntimeJavaCompatibilityExtension> applicableExtensions = this.extensions.stream().filter(ext -> ext.matches(server)).collect(Collectors.toList());
        boolean isVersionCompatible = applicableExtensions.stream().allMatch(ext -> ext.isVersionInRange(normalizedVersion));
        CompatibilityResult result = !isVersionCompatible ? CompatibilityResult.createError(this.getCompatibleVersionRange(server, applicableExtensions)) : CompatibilityResult.createSuccess();
        return result;
    }

    public VersionRange getCompatibleVersionRange(IServerDefinition server) {
        List<MuleRuntimeJavaCompatibilityExtension> applicableExtensions = this.extensions.stream().filter(ext -> ext.matches(server)).collect(Collectors.toList());
        return this.getCompatibleVersionRange(server, applicableExtensions);
    }

    private VersionRange getCompatibleVersionRange(IServerDefinition server, List<MuleRuntimeJavaCompatibilityExtension> applicableExtensions) {
        VersionRange compatibleVersionRange = applicableExtensions.stream().map(ext -> ext.getCompatibleJavaVersions()).reduce((aRange, anotherRange) -> aRange.intersection(new VersionRange[]{anotherRange})).get();
        return compatibleVersionRange;
    }

    private Version getNormalizedJavaVersion(Version version) {
        return version.getMajor() == 1 ? new Version(version.getMinor(), version.getMicro(), 0, version.getQualifier()) : version;
    }

    private static class Singleton {
        private static final MuleRuntimeJavaCompatibilityComputer instance = new MuleRuntimeJavaCompatibilityComputer(IExtensionPointReader.create(MuleRuntimeJavaCompatibilityExtension.class).readAll());

        private Singleton() {
        }
    }
}

