/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.jvm;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class JVMHelper {
    public Optional<IVMInstall> getVMInstall(String vmId) {
        return this.getVMInstalls().stream().filter(vm -> Objects.equals(vmId, vm.getId())).findAny();
    }

    public List<IVMInstall> getVMInstalls() {
        return Arrays.stream(JavaRuntime.getVMInstallTypes()).flatMap(type -> Arrays.stream(type.getVMInstalls())).collect(Collectors.toList());
    }

    public Optional<IVMInstall> getLatestCompatibleVMInstall(VersionRange supportedJVMRange) {
        return this.getVMInstalls().stream().map(vm -> Pair.of((Object)this.getVMVersion((IVMInstall)vm), (Object)vm)).filter(p -> supportedJVMRange.includes((Version)p.getLeft())).sorted((p1, p2) -> ((Version)p2.getLeft()).compareTo((Version)p1.getLeft())).map(p -> (IVMInstall)p.getRight()).findFirst();
    }

    public Optional<IVMInstall> getVMInstallByName(String jvmName) {
        return this.getVMInstalls().stream().filter(vm -> jvmName.equals(vm.getName())).findFirst();
    }

    public static IVMInstall getVMInstallByProject(IJavaProject project) throws CoreException {
        IVMInstall vm = JavaRuntime.getVMInstall((IJavaProject)project.getJavaProject());
        return vm != null ? vm : JavaRuntime.getDefaultVMInstall();
    }

    private Version getVMVersion(IVMInstall vm) {
        if (vm instanceof IVMInstall2) {
            IVMInstall2 vm2 = (IVMInstall2)vm;
            String versionString = vm2.getJavaVersion();
            if (versionString.startsWith("1.")) {
                versionString = versionString.substring(2);
            }
            return new Version(versionString);
        }
        return null;
    }
}

