/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.jvm;

import java.text.MessageFormat;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.mule.tooling.core.jvm.MuleRuntimeJavaCompatibilityExtension;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;

public class CompatibilityResult {
    private final VersionRange compatibleRange;

    private CompatibilityResult(VersionRange compatibleRange) {
        this.compatibleRange = compatibleRange;
    }

    public static CompatibilityResult createSuccess() {
        return new CompatibilityResult(null);
    }

    public static CompatibilityResult createError(VersionRange compatibleRange) {
        Objects.requireNonNull(compatibleRange);
        return new CompatibilityResult(compatibleRange);
    }

    public boolean ifIncompatible(BiConsumer<VersionRange, String> onIncompatible) {
        boolean incompatible;
        boolean bl = incompatible = !this.isCompatible();
        if (incompatible) {
            onIncompatible.accept(this.getCompatibleRange(), this.getCompatibleRangeDescription());
        }
        return incompatible;
    }

    public boolean isCompatible() {
        return this.compatibleRange == null;
    }

    public VersionRange getCompatibleRange() {
        return this.compatibleRange;
    }

    private String getCompatibleRangeDescription() {
        String message = null;
        Version lowerBound = this.compatibleRange.getLeft();
        Version upperBound = this.compatibleRange.getRight();
        boolean isDefaultLowerBound = MuleRuntimeJavaCompatibilityExtension.DEFAULT_LOWER_BOUND.equals((Object)lowerBound);
        boolean isDefaultUpperBound = MuleRuntimeJavaCompatibilityExtension.DEFAULT_UPPER_BOUND.equals((Object)upperBound);
        int upperBoundVersion = upperBound.getMajor();
        int lowerBoundVersion = lowerBound.getMajor();
        if (!isDefaultLowerBound && !isDefaultUpperBound) {
            boolean isExact = this.isExact(upperBoundVersion, lowerBoundVersion);
            message = isExact ? "Java version {0}" : "Java versions {0} through {1}";
        } else if (isDefaultLowerBound) {
            message = "Java versions up to {1}";
        } else if (isDefaultUpperBound) {
            message = "Java versions starting from {0}";
        }
        return MessageFormat.format(message, lowerBoundVersion, upperBoundVersion);
    }

    private boolean isExact(int upperBoundVersion, int lowerBoundVersion) {
        boolean describeOnlyOneVersion = lowerBoundVersion == upperBoundVersion || !this.isUpperBoundIncluded() && upperBoundVersion == lowerBoundVersion + 1 && this.compatibleRange.getRight().getMinor() == 0;
        return describeOnlyOneVersion;
    }

    private boolean isUpperBoundIncluded() {
        return this.compatibleRange.getRightType() == ']';
    }
}

