/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.io;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.io.ByteOrderMark;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.BOMInputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.VelocityException;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.io.ProjectModelLoadingResult;
import org.mule.tooling.core.io.ProjectStructureContribution;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.core.xml.XmlFactoryUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.project.EmptyProjectDescriptor;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MulePolicyProjectDescriptor;
import org.mule.tooling.model.project.MuleProjectDescriptor;
import org.mule.tooling.utils.InMemoryFile;
import org.mule.tooling.utils.Pair;
import org.w3c.dom.Document;

public class MuleResourceUtils {
    private static final int BUFFER = 2048;
    private static final List<String> BLOCK_LIST = Arrays.asList(".DS_Store");
    private static List<IPath> MULE_CONFIG_PATHS = Arrays.asList(IMuleResources.MULE_APP_FOLDER_PATH, IMuleResources.MULE_DOMAIN_FOLDER_PATH, IMuleResources.MULE_RESOURCES_FOLDER_PATH, IMuleResources.MULE_TEST_RESOURCES_FOLDER_PATH);
    public static final String MULE_CONFIG_ROOT_ELEMENT = "mule";
    public static final String MULE_DOMAIN_ROOT_ELEMENT = "domain:mule-domain";
    private static volatile List<IPath> muleConfigPaths;
    private static Object lock;
    private static XMLInputFactory inputFactory;
    private static DocumentBuilderFactory documentBuilderFactory;

    static {
        lock = new Object();
        inputFactory = MuleResourceUtils.getInputFactory();
        documentBuilderFactory = XmlFactoryUtils.createSecureDocumentBuilderFactory(factory -> factory.setNamespaceAware(true));
    }

    public static boolean isConfigFile(IResource resource, String rootElement) {
        if (resource instanceof IFile) {
            IFile resourceFile = (IFile)resource;
            String fileExtension = resource.getFileExtension();
            if (fileExtension == null || !fileExtension.equals("xml") || MuleResourceUtils.isApplicationTypesFile(resource) || MuleResourceUtils.isDesignInfoFile(resource)) {
                return false;
            }
            if (!MuleResourceUtils.isRightLocated((IResource)resourceFile)) {
                return false;
            }
            if (!resourceFile.exists()) {
                return false;
            }
            if (!resourceFile.isSynchronized(0)) {
                return false;
            }
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (InputStream contents = resourceFile.getContents();){
                    XMLEventReader eventReader = inputFactory.createXMLEventReader(contents);
                    while (eventReader.hasNext()) {
                        XMLEvent event = eventReader.nextEvent();
                        if (!event.isStartElement()) continue;
                        String localPart = event.asStartElement().getName().getLocalPart();
                        return MuleResourceUtils.isEffectivelyElement(rootElement, localPart);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (XMLStreamException xMLStreamException) {
                return false;
            }
            catch (IOException | CoreException e) {
                MuleCorePlugin.logError("Error opening resource " + resource.getName(), e);
            }
        }
        return false;
    }

    public static boolean isResource(IResource resource) {
        IPath projectRelativePath = resource.getProjectRelativePath();
        return IMuleResources.MULE_RESOURCES_FOLDER_PATH.isPrefixOf(projectRelativePath);
    }

    public static boolean isApplicationTypesFile(IResource resource) {
        IPath projectRelativePath = resource.getProjectRelativePath();
        return "application-types.xml".equals(resource.getName()) && (IMuleResources.MULE_RESOURCES_FOLDER_PATH.isPrefixOf(projectRelativePath) || IMuleResources.MULE_APP_FOLDER_PATH.isPrefixOf(projectRelativePath));
    }

    public static boolean isDesignInfoFile(IResource resource) {
        IPath projectRelativePath = resource.getProjectRelativePath();
        return "design-info.json".equals(resource.getName()) && IMuleResources.MULE_TEST_RESOURCES_FOLDER_PATH.isPrefixOf(projectRelativePath);
    }

    private static boolean isEffectivelyElement(String rootElement, String localPart) {
        int lastIndexOfColonInElementName = rootElement.lastIndexOf(58);
        int lastIndexOfColonInLocalPart = localPart.lastIndexOf(58);
        return localPart.substring(lastIndexOfColonInLocalPart == -1 ? 0 : lastIndexOfColonInLocalPart + 1).equals(rootElement.substring(lastIndexOfColonInElementName == -1 ? 0 : lastIndexOfColonInElementName + 1));
    }

    public static boolean isBegginingOfMuleConfigFile(String localPart) {
        return MuleResourceUtils.isEffectivelyElement(MULE_CONFIG_ROOT_ELEMENT, localPart) || MuleResourceUtils.isEffectivelyElement(MULE_DOMAIN_ROOT_ELEMENT, localPart);
    }

    public static boolean isConfigFile(IResource resource) {
        String rootElementName;
        try {
            rootElementName = MuleProjectKind.DOMAIN.classifies(resource.getProject()) ? MuleProjectKind.DOMAIN.getXmlRootNodeName() : MuleProjectKind.APPLICATION.getXmlRootNodeName();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while determining the nature of resource " + resource.getName(), e);
            rootElementName = MuleProjectKind.APPLICATION.getXmlRootNodeName();
        }
        return MuleResourceUtils.isConfigFile(resource, rootElementName);
    }

    private static XMLInputFactory getInputFactory() {
        XMLInputFactory newFactory = XMLInputFactory.newFactory();
        newFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.FALSE);
        newFactory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return newFactory;
    }

    public static boolean isRightLocated(IResource resource) {
        boolean rightLocated = false;
        IPath projectRelativePath = resource.getProjectRelativePath();
        List<IPath> muleConfigPaths = MuleResourceUtils.getMuleConfigPaths();
        for (IPath path : muleConfigPaths) {
            if (!path.isPrefixOf(projectRelativePath)) continue;
            rightLocated = true;
            break;
        }
        return rightLocated;
    }

    public static boolean belongsToDefaultMulePaths(IFile file) {
        boolean belongs = false;
        String filePath = file.getProjectRelativePath().toString();
        for (IPath path : MuleResourceUtils.getDefaultMuleConfigPaths()) {
            if (!filePath.startsWith(path.toString())) continue;
            belongs = true;
            break;
        }
        return belongs;
    }

    private static List<IPath> getDefaultMuleConfigPaths() {
        return new ArrayList<IPath>(MULE_CONFIG_PATHS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IPath> getMuleConfigPaths() {
        List<IPath> result = muleConfigPaths;
        if (result == null) {
            Object object = lock;
            synchronized (object) {
                result = muleConfigPaths;
                if (result == null) {
                    List<IPath> configPaths = MuleResourceUtils.getDefaultMuleConfigPaths();
                    Collection<ProjectStructureContribution> contributions = ProjectStructureContributionManager.getDefault().getContributions();
                    for (ProjectStructureContribution contribution : contributions) {
                        if (!contribution.acceptsMuleConfigFiles()) continue;
                        configPaths.add((IPath)new Path(contribution.getFolderPath()));
                    }
                    muleConfigPaths = result = configPaths;
                }
            }
        }
        return result;
    }

    public static void createFromExample(String content, IFile file) throws CoreException {
        ByteArrayInputStream input = null;
        try {
            input = new ByteArrayInputStream(content.getBytes());
            if (file.exists()) {
                file.setContents((InputStream)input, 2, (IProgressMonitor)new NullProgressMonitor());
            } else {
                file.create((InputStream)input, true, null);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
    }

    public static MulePolicyProjectDescriptor loadMulePolicyProject(IFile file) throws CoreException {
        MulePolicyProjectDescriptor mulePolicyProjectDescriptor;
        InputStream fileInputStream = null;
        try {
            MulePolicyProjectDescriptor unmarshalled;
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MulePolicyProjectDescriptor.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            fileInputStream = EFS.getStore((URI)file.getLocationURI()).openInputStream(0, null);
            mulePolicyProjectDescriptor = unmarshalled = (MulePolicyProjectDescriptor)unmarshaller.unmarshal(fileInputStream);
        }
        catch (JAXBException e) {
            try {
                throw new CoreException(MuleCorePlugin.createStatus(4, e.getMessage(), e));
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileInputStream);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)fileInputStream);
        return mulePolicyProjectDescriptor;
    }

    public static MulePolicyProjectDescriptor loadMulePolicyProject(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MulePolicyProjectDescriptor.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            MulePolicyProjectDescriptor unmarshalled = (MulePolicyProjectDescriptor)unmarshaller.unmarshal(stream);
            return unmarshalled;
        }
        catch (JAXBException e) {
            MuleCorePlugin.logError("Error trying to load mule policy form project xml", e);
            return null;
        }
    }

    public static ProjectModelLoadingResult loadMuleProjectModel(IProject project, ProjectInitializationData initData) {
        IFile modelFile = project.getFile("pom.xml");
        try {
            File muleProjectFile;
            File file;
            if (modelFile.exists()) {
                return ProjectModelLoadingResult.createDefinitive(PomMuleProjectModel.create(modelFile, initData));
            }
            IPath location = modelFile.getLocation();
            File file2 = file = location != null ? location.toFile() : null;
            if (file != null && file.exists()) {
                return ProjectModelLoadingResult.createTransitory(PomMuleProjectModel.create(file, initData));
            }
            IFile muleProject = project.getFile("mule-project.xml");
            IPath muleProjectLocation = muleProject != null ? muleProject.getLocation() : null;
            File file3 = muleProjectFile = muleProjectLocation != null ? muleProjectLocation.toFile() : null;
            if (muleProjectFile != null && muleProjectFile.exists()) {
                Throwable throwable = null;
                Object var9_11 = null;
                try (FileInputStream contents = new FileInputStream(muleProjectFile);){
                    return ProjectModelLoadingResult.createTransitory(MuleResourceUtils.loadMuleProjectModel(contents));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Model file not readable for project: " + String.valueOf(project), e);
        }
        return ProjectModelLoadingResult.createTransitory(EmptyProjectDescriptor.instance());
    }

    public static IMuleProjectModel loadMuleProjectModel(File file) throws IOException {
        return PomMuleProjectModel.create(InMemoryFile.createInMemoryFile((File)file));
    }

    @Deprecated
    private static IMuleProjectModel loadMuleProjectModel(InputStream stream) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MuleProjectDescriptor.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            MuleProjectDescriptor unmarshalled = (MuleProjectDescriptor)unmarshaller.unmarshal(stream);
            return unmarshalled;
        }
        catch (JAXBException e) {
            MuleCorePlugin.logError("Error trying to load mule project form project xml", e);
            return null;
        }
    }

    public static String getCleanFileName(IFile file) {
        String flowFilename = file.getName();
        int index = flowFilename.lastIndexOf(46) != -1 ? flowFilename.lastIndexOf(46) : flowFilename.length();
        return flowFilename.substring(0, index);
    }

    public static boolean isSameFile(IFile file, IFile editorFile) {
        return file.equals((Object)editorFile);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document getDocument(IFile resource) {
        IFile resourceAsFile = resource;
        Document muleDoc = null;
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream contents = resourceAsFile.getContents();){
                if (contents.available() == 0) {
                    return null;
                }
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                muleDoc = documentBuilder.parse(contents);
                if (muleDoc == null) return null;
                String rootNodeName = muleDoc.getFirstChild().getNodeName();
                if (!MuleResourceUtils.isBegginingOfMuleConfigFile(rootNodeName)) return null;
                return muleDoc;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            MuleCorePlugin.logError("Error opening resource " + String.valueOf(resource) + " as XML document", e);
            return null;
        }
    }

    public static List<String> getResourceDeltaFlags(IResourceDelta delta) {
        ArrayList<String> translatedFlags = new ArrayList<String>();
        Field[] fieldArray = IResourceDelta.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            int i = 0;
            try {
                i = delta.getFlags() & (Integer)field.get(IResourceDelta.class);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (i != 0) {
                translatedFlags.add(field.getName());
            }
            ++n2;
        }
        return translatedFlags;
    }

    public static void zipDirectory(File directory, File destZipFile) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destZipFile)));){
            MuleResourceUtils.addFiles(directory, "", out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void addFiles(File baseFile, String zipEntryPath, ZipOutputStream out) throws IOException {
        String[] files;
        String[] stringArray = files = baseFile.list();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            File file = new File(baseFile, filePath);
            String entryName = MuleResourceUtils.formEntryName(zipEntryPath, filePath);
            if (file.isDirectory()) {
                out.putNextEntry(new ZipEntry(entryName + "/"));
                MuleResourceUtils.addFiles(file, entryName, out);
            } else {
                MuleResourceUtils.writeFileToZip(out, entryName, file);
            }
            ++n2;
        }
    }

    private static String formEntryName(String zipEntryPath, String filePath) {
        if (StringUtils.isNotBlank((String)zipEntryPath)) {
            return zipEntryPath + "/" + filePath;
        }
        return filePath;
    }

    private static void writeFileToZip(ZipOutputStream out, String entryName, File file) throws IOException {
        byte[] data = new byte[2048];
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file), 2048);){
            int count;
            ZipEntry entry = new ZipEntry(entryName);
            out.putNextEntry(entry);
            while ((count = origin.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File zipProject(IProject project) throws IOException, CoreException {
        File destinationFile = MuleResourceUtils.createTemporalZipPath(project);
        MuleResourceUtils.zipProject(project, destinationFile);
        return destinationFile;
    }

    private static void zipProject(IProject project, File destinationFile) throws IOException, CoreException {
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("create", "true");
        URI zipFileUri = URI.create("jar:" + destinationFile.toURI().toString());
        project.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        Files.deleteIfExists(Paths.get(destinationFile.getAbsolutePath(), new String[0]));
        Throwable throwable = null;
        Object var5_6 = null;
        try (FileSystem zipfs = FileSystems.newFileSystem(zipFileUri, env);){
            final java.nio.file.Path rootPath = zipfs.getPath("/", new String[0]);
            Files.createDirectories(rootPath, new FileAttribute[0]);
            final IPath outputLocation = project.getLocation().append(JavaCore.create((IProject)project).getOutputLocation().removeFirstSegments(1));
            final String projectName = project.getName();
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    boolean isContainer = resource instanceof IContainer;
                    boolean isOutputLocation = outputLocation.equals((Object)resource.getLocation());
                    boolean shouldInclude = this.shouldBeIncluded(resource);
                    if (!isOutputLocation && shouldInclude) {
                        try {
                            if (isContainer) {
                                IPath path = new Path(projectName).append(resource.getProjectRelativePath());
                                java.nio.file.Path folderPathInZip = rootPath.resolveSibling(path.toString());
                                Files.createDirectory(folderPathInZip, new FileAttribute[0]);
                            } else {
                                String projectRelativePath = resource.getProjectRelativePath().toString();
                                String projectRelativeParentPath = projectRelativePath.contains("/") ? "/" + projectRelativePath.substring(0, projectRelativePath.lastIndexOf(47)) : "";
                                String resourceAbsolutePath = resource.getLocation().toString();
                                java.nio.file.Path basePath = rootPath.resolveSibling(projectName + projectRelativeParentPath);
                                MuleResourceUtils.copy(resourceAbsolutePath, resource.getName(), basePath);
                            }
                        }
                        catch (IOException e) {
                            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.core", e.getMessage(), (Throwable)e));
                        }
                    }
                    return isContainer && !isOutputLocation;
                }

                private boolean shouldBeIncluded(IResource resource) {
                    return !BLOCK_LIST.contains(resource.getName());
                }
            }, 2, 8);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static File createTemporalZipPath(IProject muleProject) {
        String name = muleProject.getName();
        return MuleResourceUtils.createTemporalZipPath(name);
    }

    public static File createTemporalZipPath(String name) {
        File baseExportTempDir = MuleResourceUtils.createRandomTemporalDirectory();
        return new File(baseExportTempDir, (String)(name.endsWith(".jar") ? name : name + ".jar"));
    }

    public static File createRandomTemporalDirectory() {
        File baseExportTempDir = new File(SystemUtils.getJavaIoTmpDir(), UUID.randomUUID().toString());
        if (!baseExportTempDir.exists()) {
            baseExportTempDir.mkdirs();
        }
        baseExportTempDir.deleteOnExit();
        return baseExportTempDir;
    }

    public static void copy(String filePath, String fileName, java.nio.file.Path basePath) throws IOException {
        FileSystem fileSystem = basePath.getFileSystem();
        java.nio.file.Path sourcePath = Paths.get(filePath, new String[0]);
        java.nio.file.Path destPath = fileSystem.getPath(basePath.toString(), fileName);
        Files.copy(sourcePath, destPath, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyMembers(IContainer folder, java.nio.file.Path basePath) throws CoreException, IOException {
        IResource[] members;
        IResource[] iResourceArray = members = folder.members();
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IResource member = iResourceArray[n2];
            MuleResourceUtils.copy(member.getLocation().toString(), member.getName(), basePath);
            if (member instanceof IFolder) {
                IResource[] subMembers = ((IFolder)member).members();
                java.nio.file.Path subBasePath = basePath.resolve(member.getName());
                IResource[] iResourceArray2 = subMembers;
                int n3 = subMembers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IResource subMember = iResourceArray2[n4];
                    MuleResourceUtils.copy(subMember.getLocation().toString(), subMember.getName(), subBasePath);
                    ++n4;
                }
                MuleResourceUtils.copyMembers((IContainer)((IFolder)member), subBasePath);
            }
            ++n2;
        }
    }

    public static boolean checkConnectorBelongsToDomain(IMuleProject project, String connectorName) throws CoreException {
        GlobalElement domainGlobalElement;
        IMuleDomain domain;
        IMuleApplicationProject applicationProject;
        boolean connectorBelongsToDomain = false;
        if (MuleProjectKind.APPLICATION.classifies(project) && !(applicationProject = MuleProjectKind.APPLICATION.adapt(project)).hasDefaultDomain() && applicationProject.getDomain() != null && (domain = applicationProject.getDomain()) instanceof IMuleDomainProject && (domainGlobalElement = CoreUtils.retrieveGlobalElement((IMuleDomainProject)domain, connectorName)) != null) {
            connectorBelongsToDomain = true;
        }
        return connectorBelongsToDomain;
    }

    public static boolean isValidDomainName(String text) {
        return text.matches("[a-zA-Z0-9_\\-.]+");
    }

    public static void createFile(IProject project, IFolder folder, URL file, String fileName) throws CoreException {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (InputStream contents = file.openStream();){
                folder.getFile(fileName).create(contents, true, null);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            try {
                String message = MessageFormat.format("Falling back to creating {0} in {1} natively due to: {2}: {3}", file, project, e.getClass().getName(), e.getMessage());
                MuleCorePlugin.logWarning(message);
                MuleResourceUtils.createFileNatively(project, folder, fileName, file);
            }
            catch (IOException e1) {
                String message = MessageFormat.format("There was an error creating {0} in {1} natively due to: {2}: {3}", file, project, e1.getClass().getName(), e1.getMessage());
                throw new CoreException(MuleCorePlugin.createStatus(4, message, e1));
            }
        }
    }

    public static void createFile(IProject project, IFolder folder, String contents, String fileName) throws CoreException {
        try {
            folder.getFile(fileName).create((InputStream)new ByteArrayInputStream(contents.getBytes()), true, null);
        }
        catch (CoreException e) {
            try {
                String message = MessageFormat.format("Falling back to creating file in {0} natively due to: {1}: {2}", project, ((Object)((Object)e)).getClass().getName(), e.getMessage());
                MuleCorePlugin.logWarning(message);
                MuleResourceUtils.createFileNatively(project, folder, fileName, contents);
            }
            catch (IOException e1) {
                String message = MessageFormat.format("There was an error creating file in {0} natively due to: {1}: {2}", project, e1.getClass().getName(), e1.getMessage());
                throw new CoreException(MuleCorePlugin.createStatus(4, message, e1));
            }
        }
    }

    public static void createFile(IFolder folder, String fileName, InputStream content) throws CoreException {
        IFile file = folder.getFile(fileName);
        file.create(content, true, null);
    }

    public static void create(IResource resource) throws CoreException {
        if (resource == null || resource.exists()) {
            return;
        }
        if (!resource.getParent().exists()) {
            MuleResourceUtils.create((IResource)resource.getParent());
        }
        switch (resource.getType()) {
            case 1: {
                ((IFile)resource).create((InputStream)new ByteArrayInputStream(new byte[0]), true, null);
                break;
            }
            case 2: {
                ((IFolder)resource).create(0, true, null);
                break;
            }
            case 4: {
                ((IProject)resource).create(null);
                ((IProject)resource).open(null);
            }
        }
    }

    public static void saveOrUpdate(IFile file, InputStream content) throws CoreException {
        if (file.exists()) {
            file.setContents(content, true, false, null);
        } else {
            file.create(content, true, null);
        }
    }

    public static void createFileNatively(IProject project, IFolder folder, String fileName, String contents) throws IOException, CoreException {
        try {
            IPath folderPath = folder.getFullPath();
            File folderFile = project.getLocation().append(folderPath.removeFirstSegments(1)).toFile();
            folderFile.mkdirs();
            File targetFile = new File(folderFile, fileName);
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileOutputStream fileOutputStream = new FileOutputStream(targetFile);){
                IOUtils.copy((InputStream)new ByteArrayInputStream(contents.getBytes()), (OutputStream)fileOutputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            folder.refreshLocal(1, null);
        }
    }

    public static void createFileNatively(IProject project, IFolder folder, String fileName, URL file) throws IOException, CoreException {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (InputStream contents = file.openStream();){
                IPath folderPath = folder.getFullPath();
                File folderFile = project.getLocation().append(folderPath.removeFirstSegments(1)).toFile();
                folderFile.mkdirs();
                File targetFile = new File(folderFile, fileName);
                Files.copy(contents, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            folder.refreshLocal(1, null);
        }
    }

    public static void executeVelocityTemplate(ClassLoader classLoader, Reader templateReader, Writer targetWriter, Object ... contextKeyValues) throws IOException {
        ClassLoader oldClassloader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        try {
            try {
                Velocity.init();
            }
            catch (Exception e) {
                throw new VelocityException((Throwable)e);
            }
            VelocityContext context = new VelocityContext();
            int i = 0;
            int j = 1;
            while (j < contextKeyValues.length) {
                if (!(contextKeyValues[i] instanceof String)) {
                    String message = MessageFormat.format("Keys passed to this method must be Strings, offending parameter at index {0} with value {1}", i, contextKeyValues[i]);
                    throw new IllegalArgumentException(message);
                }
                context.put((String)contextKeyValues[i], contextKeyValues[j]);
                i += 2;
                j += 2;
            }
            boolean evaluate = Velocity.evaluate((Context)context, (Writer)targetWriter, (String)"velocity rendering", (Reader)templateReader);
            if (!evaluate) {
                throw new VelocityException("Evaluation of the template failed.");
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassloader);
        }
    }

    public static long getLastModificationTimeStamp(IJavaProject javaProject) throws CoreException {
        IClasspathEntry[] rawClasspath = javaProject.getRawClasspath();
        HashSet<IPath> filteredLocations = new HashSet<IPath>();
        IClasspathEntry[] iClasspathEntryArray = rawClasspath;
        int n = rawClasspath.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            IPath outputLocation = entry.getOutputLocation();
            if (outputLocation != null) {
                filteredLocations.add(outputLocation);
            }
            ++n2;
        }
        filteredLocations.add(javaProject.getOutputLocation());
        filteredLocations.add(javaProject.getProject().getFile(".settings").getFullPath());
        filteredLocations.add(javaProject.getProject().getFile("target").getFullPath());
        return MuleResourceUtils.getLastModificationTimeStamp((IContainer)javaProject.getProject(), filteredLocations, 0L);
    }

    private static long getLastModificationTimeStamp(IContainer container, Set<IPath> filteredLocations, long maxModificationStamp) throws CoreException {
        IResource[] members;
        if (!filteredLocations.contains(container.getFullPath()) && (members = container.members()) != null && members.length != 0) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                long memberMaxStamp;
                IResource member = iResourceArray[n2];
                if (member instanceof IContainer) {
                    IContainer containerMember = (IContainer)member;
                    memberMaxStamp = MuleResourceUtils.getLastModificationTimeStamp(containerMember, filteredLocations, maxModificationStamp);
                } else {
                    long resourceStamp = member.getLocalTimeStamp();
                    memberMaxStamp = resourceStamp == -1L ? -1L : resourceStamp;
                }
                maxModificationStamp = Math.max(memberMaxStamp, maxModificationStamp);
                ++n2;
            }
        }
        return maxModificationStamp;
    }

    /*
     * Exception decompiling
     */
    public static String getConfigApi(IResource configFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static Pair<String, String> getApiName(IResource configFile) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [14[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void unzip(java.nio.file.Path zipPath, java.nio.file.Path outputPath) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File entryDestination = new File(outputPath.toFile(), entry.getName());
                if (entry.isDirectory()) {
                    entryDestination.mkdirs();
                    continue;
                }
                entryDestination.getParentFile().mkdirs();
                Throwable throwable2 = null;
                Object var9_12 = null;
                try (InputStream in = zipFile.getInputStream(entry);){
                    Files.copy(in, entryDestination.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    public static String getUniqueFileName(File parent, String filename) {
        return MuleResourceUtils.getUniqueFile(parent, filename).getName();
    }

    public static File getUniqueFile(File parent, String filename) {
        int counter = 1;
        String baseName = FilenameUtils.getBaseName((String)filename);
        String extension = FilenameUtils.getExtension((String)filename);
        File currentFile = new File(parent, filename);
        while (currentFile.exists()) {
            currentFile = new File(parent, baseName + "-" + counter++ + "." + extension);
        }
        return currentFile;
    }

    public static Optional<File> getConfigurationFileInDeploymentFolder(IResource configurationFile, File deploymentFolder, IMuleProject muleProject) {
        IPath configFilePath = configurationFile.getProjectRelativePath();
        return MuleResourceUtils.getMuleConfigPaths().stream().filter(path -> path.isPrefixOf(configFilePath)).map(path -> configFilePath.makeRelativeTo(path)).findFirst().map(relativePath -> {
            java.nio.file.Path xmlFile = Paths.get(deploymentFolder.toURI());
            String[] stringArray = relativePath.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                xmlFile = xmlFile.resolve(segment);
                ++n2;
            }
            return xmlFile.toFile();
        });
    }

    public static boolean isLog4jRelatedFile(IResource resource) {
        String fileName = resource.getName();
        return MuleResourceUtils.isLog4jRelatedFile(fileName);
    }

    public static boolean isLog4jRelatedFile(String fileName) {
        return "log4j2.xml".equals(fileName) || "log4j2-test.xml".equals(fileName) || "log4j.xml".equals(fileName) || "log4j-test.xml".equals(fileName) || "log4j.properties".equals(fileName);
    }

    public static Charset getCharset(IFile xmlConfigFile) {
        String fileCharset = MuleResourceUtils.doGetCharset(xmlConfigFile);
        Charset charset = fileCharset != null && Charset.isSupported(fileCharset) ? Charset.forName(fileCharset) : IMuleResources.DEFAULT_CHARSET;
        return charset;
    }

    private static String doGetCharset(IFile xmlConfigFile) {
        String fileCharset;
        try {
            fileCharset = xmlConfigFile.getCharset();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem obtaining the charset for file: " + String.valueOf(xmlConfigFile), e);
            fileCharset = "UTF-8";
        }
        return fileCharset;
    }

    public static String readContents(IFile toRead) throws IOException, CoreException {
        return MuleResourceUtils.readContents((IStorage)toRead, toRead.getCharset());
    }

    public static String readContents(IStorage toRead, String charset) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = toRead.getContents();){
            return IOUtils.toString((InputStream)inputStream, (String)charset);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readContents(IStorage toRead, Charset charset) throws IOException, CoreException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream inputStream = toRead.getContents();){
            return IOUtils.toString((InputStream)inputStream, (Charset)charset);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readContentsUsingDefaultCharset(IStorage toRead) throws IOException, CoreException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream inputStream = toRead.getContents();){
            return IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static boolean resourcesAffectsTypeCatalog(IMuleProject muleProject, IResource file) {
        return muleProject.getProject().equals((Object)file.getProject()) && "java".equals(file.getFileExtension());
    }

    public static void cleanDirectory(java.nio.file.Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                FileUtils.cleanDirectory((File)path.toFile());
            }
        }
        catch (IOException e) {
            MuleCorePlugin.logWarning("Cannot delete " + String.valueOf(path), e);
        }
    }

    public static InputStream skipBOM(InputStream content) {
        return new BOMInputStream(content, new ByteOrderMark[]{ByteOrderMark.UTF_8});
    }
}

