/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.io;

import java.text.MessageFormat;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.Scope;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;

public class EditingScope {
    public static final EditingScope APP = new EditingScope("app", Scope.Visibility.GLOBAL.getValue());
    public static final EditingScope TEST = new EditingScope("test", Scope.Visibility.LOCAL.getValue());
    @ExtensionAttribute(optional=true)
    private String parentScope;
    @ExtensionAttribute
    private String name;
    @ExtensionAttribute(optional=true)
    private String visibility = Scope.Visibility.GLOBAL.getValue();

    public static EditingScope getCurrent() {
        return MuleCorePlugin.getDesignContext().getEditingScope();
    }

    public static EditingScope getRootScope(EditingScope editingScope) {
        return editingScope.belongsTo(APP) ? APP : TEST;
    }

    public EditingScope() {
    }

    public EditingScope(String scopeName, String visibility) {
        this.name = scopeName;
        this.visibility = visibility;
    }

    public String getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(String parentScope) {
        this.parentScope = parentScope;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public boolean belongsTo(EditingScope scope) {
        EditingScope currentScope = this;
        while (!currentScope.equals(scope) && currentScope.getParentScope() != null) {
            String currentParentScope = currentScope.getParentScope();
            String currentParentName = currentScope.getName();
            currentScope = ProjectStructureContributionManager.getDefault().getScope(currentParentScope).orElseGet(() -> {
                this.logInvalidScope(currentParentScope, currentParentName);
                return APP;
            });
        }
        return currentScope.equals(scope);
    }

    private void logInvalidScope(String currentParentScope, String currentParentName) {
        String message = MessageFormat.format("Non existent parent editing scope {0} for scope {1}. Using default scope {2}", currentParentScope, currentParentName, APP.getName());
        MuleCorePlugin.logError(message, new IllegalArgumentException().fillInStackTrace());
    }

    public String toString() {
        return "EditingScope [name=" + this.name + "]";
    }
}

