/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.io;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class CopyFileVisitor
extends SimpleFileVisitor<Path> {
    private static final long FILE_COPY_BUFFER_SIZE = 0x1E00000L;
    private Path sourcePath;
    private Path destinationPath;
    private List<Path> excludedPaths;

    public CopyFileVisitor(Path destinationPath) throws IOException {
        this(destinationPath, Lists.newArrayList());
    }

    public CopyFileVisitor(Path destinationPath, List<Path> excludedPaths) throws IOException {
        this.destinationPath = destinationPath;
        this.excludedPaths = excludedPaths;
        CopyFileVisitor.createDirectories(destinationPath);
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
        if (this.sourcePath == null) {
            this.sourcePath = dir;
        } else {
            CopyFileVisitor.createDirectories(this.destinationPath.resolve(this.sourcePath.relativize(dir)));
        }
        return !this.excludedPaths.contains(dir) ? FileVisitResult.CONTINUE : FileVisitResult.SKIP_SUBTREE;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (!this.excludedPaths.contains(file)) {
            Path fileDestinationPath = this.sourcePath == null ? this.destinationPath : this.destinationPath.resolve(this.sourcePath.relativize(file));
            CopyFileVisitor.doCopyFile(file, fileDestinationPath);
        }
        return FileVisitResult.CONTINUE;
    }

    private static void doCopyFile(Path file, Path fileDestinationPath) throws IOException {
        try {
            FileUtils.copyFile((File)file.toFile(), (File)fileDestinationPath.toFile());
        }
        catch (Exception exception) {
            CopyFileVisitor.doCopyFile(file.toFile(), fileDestinationPath.toFile());
        }
    }

    private static void createDirectories(Path path) throws IOException {
        if (path == null) {
            return;
        }
        File file = path.toFile();
        if (file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtils.createParentDirectories((File)path.resolve("dummy.txt").toFile());
        } else {
            FileUtils.createParentDirectories((File)file);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void doCopyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException(String.valueOf(destFile) + "' is a directory");
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream fis = new FileInputStream(srcFile);
            try {
                block26: {
                    FileChannel input = fis.getChannel();
                    try {
                        block25: {
                            FileOutputStream fos = new FileOutputStream(destFile);
                            try {
                                try (FileChannel output = fos.getChannel();){
                                    long remain;
                                    long bytesCopied;
                                    long size = input.size();
                                    long pos = 0L;
                                    long count = 0L;
                                    while (pos < size && (bytesCopied = output.transferFrom(input, pos, count = Math.min(remain = size - pos, 0x1E00000L))) != 0L) {
                                        pos += bytesCopied;
                                    }
                                }
                                if (fos == null) break block25;
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                if (fos == null) throw throwable;
                                fos.close();
                                throw throwable;
                            }
                            fos.close();
                        }
                        if (input == null) break block26;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (input == null) throw throwable;
                        input.close();
                        throw throwable;
                    }
                    input.close();
                }
                if (fis == null) return;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
            return;
        }
        catch (Throwable throwable5) {
            if (throwable == null) {
                throwable = throwable5;
                throw throwable;
            }
            if (throwable == throwable5) throw throwable;
            throwable.addSuppressed(throwable5);
            throw throwable;
        }
    }
}

