/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.impl.model.ProjectDependenciesReconciler;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.IMuleProjectModel;

public final class SynchronizeMuleProjectWithClasspathJob
extends Job {
    public static final String familyName = "SynchronizeMuleProjectWithClasspathJob";
    private BaseMuleProject muleProject;

    SynchronizeMuleProjectWithClasspathJob(BaseMuleProject muleProjectImpl, IMuleProjectModel initializingModel) {
        super("Synchronizing project's classpath...");
        this.muleProject = muleProjectImpl;
    }

    protected IStatus run(IProgressMonitor monitor) {
        MultiStatus multiStatus = new MultiStatus("org.mule.tooling.core", 0, "Dependency Reconciling", null);
        try {
            if (this.muleProject.isAccessible()) {
                ProjectDependenciesReconciler projectDependenciesReconciler = new ProjectDependenciesReconciler();
                this.reconcileProjectClasspathWithMuleProject(multiStatus, this.muleProject.getJavaProject().getRawClasspath(), projectDependenciesReconciler);
                IStatus status = projectDependenciesReconciler.reconcileMuleProjectWithClasspath(this.muleProject.getJavaProject(), this.muleProject);
                multiStatus.add(status);
            } else {
                multiStatus.add(Status.CANCEL_STATUS);
            }
        }
        catch (CoreException coreException) {
            return new Status(8, "org.mule.tooling.core", "There was a problem retrieving the raw classpath for project: " + this.muleProject.getName());
        }
        return multiStatus;
    }

    private void reconcileProjectClasspathWithMuleProject(MultiStatus multiStatus, IClasspathEntry[] rawClasspath, ProjectDependenciesReconciler projectDependenciesReconciler) {
        try {
            IClasspathEntry[] iClasspathEntryArray = rawClasspath;
            int n = rawClasspath.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (CoreUtils.isMuleExtensionContainer(entry.getPath())) {
                    IStatus status = projectDependenciesReconciler.reconcileClasspathWithMuleProject(entry.getPath(), this.muleProject);
                    multiStatus.add(status);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            multiStatus.add((IStatus)new Status(8, "org.mule.tooling.core", "There was a problem reconciling dependencies", (Throwable)e));
        }
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family) || familyName.equals(family);
    }
}

