/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.impl.model.BaseMuleProject;

final class ProjectModelLoaderResourceListener
implements IResourceChangeListener {
    private BaseMuleProject muleProject;

    public ProjectModelLoaderResourceListener(BaseMuleProject baseMuleProject) {
        this.muleProject = baseMuleProject;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                ProjectModelDeltaVisitor visitor = new ProjectModelDeltaVisitor();
                delta.accept((IResourceDeltaVisitor)visitor);
                if (visitor.pomFile != null) {
                    ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
                    this.muleProject.getMuleProjectModel();
                }
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was an error processing workspace events: " + e.getMessage(), e);
        }
    }

    private static final class ProjectModelDeltaVisitor
    implements IResourceDeltaVisitor {
        private static final IPath PROJECT_MODEL_FILE_PATH = new Path("pom.xml");
        public IResource pomFile;

        private ProjectModelDeltaVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta.getAffectedChildren().length == 0) {
                if (delta.getResource() != null && delta.getResource().getProjectRelativePath().equals((Object)PROJECT_MODEL_FILE_PATH)) {
                    this.pomFile = delta.getResource();
                }
                return false;
            }
            return true;
        }
    }
}

