/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.Callback;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.core.runtime.ApiSpecClasspathContainer;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.ExternalMuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.model.project.MuleExtension;

public class ProjectDependenciesReconciler {
    public IStatus reconcileClasspathWithMuleProject(IPath containerPath, BaseMuleProject muleProject) throws CoreException {
        IJavaProject javaProject = muleProject.getJavaProject();
        String targetExtensionName = MuleUserLibraryClasspathContainer.getCoordinatesFromPath(containerPath);
        List<MuleExtension> muleProjectExtensions = muleProject.getDeclaredExtensions();
        MuleExtension declaredExtension = muleProjectExtensions.stream().filter(ext -> ext.getQualifier().equals(targetExtensionName)).findFirst().orElse(null);
        if (declaredExtension == null) {
            this.removeFromClasspath(containerPath, javaProject);
        }
        return Status.OK_STATUS;
    }

    public IStatus reconcileMuleProjectWithClasspath(IJavaProject javaProject, BaseMuleProject muleProject) {
        List<MuleExtension> muleExtensions = muleProject.getDeclaredExtensions();
        List<MavenDependency> dependencies = muleProject.getDeclaredDependencies();
        return this.reconcileMuleProjectWithClasspath(javaProject, muleProject, muleExtensions, dependencies);
    }

    public IStatus reconcileMuleProjectWithClasspath(IJavaProject javaProject, BaseMuleProject muleProject, List<MuleExtension> muleExtensions, List<MavenDependency> dependencies) {
        try {
            List<MavenDependency> dependenciesToResolve = this.filterDependencies(javaProject, dependencies);
            this.resolveApiDependencyClasspath(muleProject, dependenciesToResolve);
        }
        catch (CoreException coreException) {
            return Status.CANCEL_STATUS;
        }
        for (MuleExtension muleExtension : muleExtensions) {
            try {
                if (ProjectClasspathUtils.isClasspathEntryInProject(ExternalMuleUserLibraryClasspathContainer.getContainerPath(muleExtension.getQualifier()), javaProject)) continue;
                ArtifactResolvingRunnerFactory.asyncInstance().runResolvingExtension(muleProject, MavenUtils.getDependency(muleExtension), SingleExtensionCallback.builder().onSuccess(muleProject::addMuleExtensionToProject).onErrorLog().build(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError(this.getClasspathErrorMessage(muleExtension.getQualifier()), e);
                return Status.CANCEL_STATUS;
            }
        }
        return Status.OK_STATUS;
    }

    private List<MavenDependency> filterDependencies(IJavaProject javaProject, List<MavenDependency> dependencies) throws CoreException {
        ArrayList dependenciesToResolve = Lists.newArrayList();
        for (MavenDependency dep : dependencies) {
            try {
                if (ProjectClasspathUtils.isClasspathEntryInProject(ApiSpecClasspathContainer.getContainerPath(dep), javaProject)) continue;
                dependenciesToResolve.add(dep);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError(this.getClasspathErrorMessage(dep.toString()), e);
                throw e;
            }
        }
        return dependenciesToResolve;
    }

    private String getClasspathErrorMessage(String dep) {
        return "Error while resolving " + dep + " to classpath";
    }

    private void resolveApiDependencyClasspath(BaseMuleProject muleProject, List<MavenDependency> dependencies) {
        Callback<Map<MavenDependency, File>> dependencyCallback = DependenciesCallback.builder().onSuccess(resolvedArtifacts -> {
            for (MavenDependency dep : resolvedArtifacts.keySet()) {
                if (!dep.getClassifier().map(classifier -> CoreUtils.isAnyAPITypeClassifier(classifier)).orElse(false).booleanValue()) continue;
                muleProject.addAPISpecDependency(dep);
            }
        }).onErrorLog().build();
        ArtifactResolvingRunnerFactory.asyncInstance().runResolvingDependencies(muleProject, dependencies, dependencyCallback, (IProgressMonitor)new NullProgressMonitor());
    }

    private void removeFromClasspath(final IPath containerPath, final IJavaProject javaProject) {
        Job job = new Job("Removing erroneous classpath entry"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    ProjectClasspathUtils.removeClasspathEntry(containerPath, javaProject, 4);
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError("Unable to remove entry " + String.valueOf(containerPath) + " from classpath", e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        job.setPriority(50);
        job.schedule();
    }
}

