/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.cache.internal.CompositeConfigurationsCache;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.dependencymanagement.EclipseDependencyManager;
import org.mule.tooling.core.deployer.MuleApplicationDeployment;
import org.mule.tooling.core.event.DomainChangedEvent;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.impl.model.DomainMavenDependencyComparator;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.impl.model.ExternalMuleDomainReferenceManager;
import org.mule.tooling.core.impl.model.InvalidExternalMuleDomainReference;
import org.mule.tooling.core.impl.model.MuleProjectModelListenerAdapter;
import org.mule.tooling.core.io.ProjectStructureContribution;
import org.mule.tooling.core.m2.dependency.MavenCoordinates;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IExternalDomain;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectVisitor;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.JobUtils;
import org.mule.tooling.core.utils.ProjectStructureContributionManager;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public class MuleProject
extends BaseMuleProject
implements IMuleApplicationProject {
    private static final String SYNC_DOMAIN_CLASSPATH_COUNT = "org.mule.tooling.domain.threadCount";
    public static final int SYNC_WITH_DOMAIN_CLASSPATH_COUNT = Integer.parseInt(System.getProperty("org.mule.tooling.domain.threadCount", "8"));
    private static final JobGroup SYNC_WITH_DOMAIN_CLASSPATH_JOB_GROUP = JobUtils.createJobGroup("Domain classpath synchronization job", SYNC_WITH_DOMAIN_CLASSPATH_COUNT);
    private IMuleDomain currentDomain;
    protected volatile DomainProjectModelListener domainListener = new DomainProjectModelListener(this);

    public MuleProject(IJavaProject javaProject) {
        super(javaProject);
    }

    @Override
    public IFolder getMuleTestResourcesFolder() {
        return this.getFolder("src/test/resources");
    }

    @Override
    public IFolder getMuleAppsFolder() {
        return this.getFolder("src/main/mule");
    }

    @Override
    public IFolder getDataMappingsFolder() {
        return this.getFolder("mappings");
    }

    @Override
    public IFolder getApisFolder() {
        return this.getFolder("src/main/resources/api");
    }

    @Override
    public IFolder getTestSourceFolder() {
        return this.getFolder("src/test/java");
    }

    @Override
    public IFolder getTestResourcesFolder() {
        return this.getFolder("src/test/resources");
    }

    public MuleProjectKind<IMuleApplicationProject> getKind() {
        return MuleProjectKind.APPLICATION;
    }

    @Override
    protected void initializeFilesAndFolders(IProject project) throws CoreException {
        CoreUtils.prepareMuleProjectFolders(project);
        MuleApplicationDeployment.updateDeploymentDescriptor(this);
        ProjectClasspathUtils.ensureFolderIsASourceFolder(this, this.getMuleAppsFolder());
        ProjectClasspathUtils.setResourceAsDerived((IResource)this.getTargetFolder());
    }

    @Override
    public List<IClasspathEntry> getSourceFolderEntries() {
        ArrayList<IClasspathEntry> sourceFolders = new ArrayList<IClasspathEntry>();
        IFolder muleAppsFolder = this.getMuleAppsFolder();
        IClasspathEntry appsEntry = JavaCore.newSourceEntry((IPath)muleAppsFolder.getFullPath());
        sourceFolders.add(appsEntry);
        IFolder muleSourceFolder = this.getMuleSourceFolder();
        IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)muleSourceFolder.getFullPath());
        sourceFolders.add(srcEntry);
        IFolder muleResourcesFolder = this.getMuleResourcesFolder();
        IClasspathEntry srcResEntry = JavaCore.newSourceEntry((IPath)muleResourcesFolder.getFullPath());
        sourceFolders.add(srcResEntry);
        IPath testOutputPath = this.getJavaProject().getPath().append("target").append("test-classes");
        IFolder testSourceFolder = this.getTestSourceFolder();
        IClasspathEntry testSrcEntry = JavaCore.newSourceEntry((IPath)testSourceFolder.getFullPath(), (IPath[])new IPath[0], (IPath)testOutputPath);
        sourceFolders.add(testSrcEntry);
        IFolder testResourcesFolder = this.getTestResourcesFolder();
        IClasspathEntry testResEntry = JavaCore.newSourceEntry((IPath)testResourcesFolder.getFullPath(), (IPath[])new IPath[0], (IPath)testOutputPath);
        sourceFolders.add(testResEntry);
        IFolder contributedSourceFolder = null;
        IClasspathEntry contributedSourceFolderEntry = null;
        for (ProjectStructureContribution contribution : ProjectStructureContributionManager.getDefault().getContributions()) {
            String folderPath = contribution.getFolderPath();
            File file = this.getFolder(folderPath).getRawLocation().toFile();
            boolean sourceFolder = contribution.isSourceFolder();
            if (!file.exists() || !file.isDirectory() || !sourceFolder) continue;
            contributedSourceFolder = this.getFolder(folderPath);
            contributedSourceFolderEntry = JavaCore.newSourceEntry((IPath)contributedSourceFolder.getFullPath());
            sourceFolders.add(contributedSourceFolderEntry);
        }
        return sourceFolders;
    }

    @Override
    public String getDomainName() {
        return this.getDomainCoordinates().map(MavenCoordinates::getArtifactId).orElse("default");
    }

    @Override
    public IMuleConfigurationsCache getConfigurationsCache() {
        if (this.hasDefaultDomain()) {
            return super.getConfigurationsCache();
        }
        IMuleDomain domain = this.getDomain();
        if (domain instanceof IMuleDomainProject && ((IMuleDomainProject)domain).isAccessible()) {
            IMuleConfigurationsCache domainCache = ((IMuleDomainProject)domain).getConfigurationsCache();
            return new CompositeConfigurationsCache(super.getConfigurationsCache(), domainCache);
        }
        return super.getConfigurationsCache();
    }

    @Override
    public void setDomain(Optional<MavenDependency> domainCoordinates) throws CoreException {
        this.setDomain(domainCoordinates, (IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    public void setDomain(Optional<MavenDependency> domainCoordinates, IProgressMonitor monitor) throws CoreException {
        Optional<MavenDependency> previousDomainCoordinates = this.getDomainCoordinates();
        if (!DomainMavenDependencyComparator.correspondsTo(previousDomainCoordinates, domainCoordinates)) {
            this.getMuleProjectModel().setDomainDependency(domainCoordinates);
        }
    }

    @Override
    public void postInitialize() throws CoreException {
        this.doSetDomain(this.getDomainCoordinates(), (IProgressMonitor)new NullProgressMonitor());
        super.postInitialize();
    }

    private void doSetDomain(Optional<MavenDependency> newCoordinates, IProgressMonitor monitor) throws CoreException {
        Optional<IMuleDomain> maybeDomain = Optional.ofNullable(this.currentDomain);
        this.updateProjectClasspathWith(maybeDomain, newCoordinates.flatMap(DomainUtils::findDomainProjectSafely).map(IMuleDomain.class::cast));
        maybeDomain.ifPresent(domain -> domain.getMuleProjectModel().removeModelListener(this.domainListener));
        if (newCoordinates.isPresent()) {
            MavenDependency newDomainDependency = newCoordinates.get();
            Optional<IMuleDomainProject> domainProject = DomainUtils.findDomainProject(newDomainDependency);
            if (domainProject.isPresent()) {
                IMuleDomain newDomain = domainProject.get();
                this.notifyDomainChangedSuccessfully(maybeDomain, newDomain);
            } else {
                IMuleDomain newDomain = this.resolveExternalDomain(maybeDomain, newDomainDependency);
            }
        } else if (maybeDomain.isPresent()) {
            IMuleDomain newDomain = null;
            this.notifyDomainChangedSuccessfully(maybeDomain, newDomain);
        }
        DomainUtils.validateDomainExtensions(this);
        this.setChanged();
        this.notifyObservers("prop_domain");
    }

    private IMuleDomain resolveExternalDomain(Optional<IMuleDomain> maybeDomain, MavenDependency newDomainDependency) {
        IMuleDomain newDomain;
        try {
            DomainResolutionJob job = new DomainResolutionJob(newDomainDependency, maybeDomain);
            job.schedule();
            job.join();
            newDomain = job.getDomain();
        }
        catch (InterruptedException e) {
            MuleCorePlugin.logError("Error while resolving domain " + MavenUtils.getGAV(newDomainDependency), e);
            InvalidExternalMuleDomainReference domainReference = new InvalidExternalMuleDomainReference(newDomainDependency);
            newDomain = domainReference;
            this.notifyDomainChangedFailed(Optional.of(domainReference));
        }
        return newDomain;
    }

    @Override
    protected void extensionsAddedToModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
        if (projectModel.equals(this.getMuleProjectModel())) {
            super.extensionsAddedToModel(projectModel, this.extensionsNotInDomain(extensions));
        } else if (!this.hasDefaultDomain() && this.currentDomain != null && projectModel.equals(this.currentDomain.getMuleProjectModel())) {
            this.restartModuleManager();
        }
    }

    @Override
    protected void extensionsRemovedFromModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
        if (projectModel.equals(this.getMuleProjectModel())) {
            super.extensionsRemovedFromModel(projectModel, this.extensionsNotInDomain(extensions));
        } else if (!this.hasDefaultDomain() && this.currentDomain != null && projectModel.equals(this.currentDomain.getMuleProjectModel())) {
            this.restartModuleManager();
        }
    }

    private List<MuleExtension> extensionsNotInDomain(List<MuleExtension> extensions) {
        List domainExtensions = this.currentDomain != null ? this.currentDomain.getMuleExtensions() : Collections.emptyList();
        return extensions.stream().filter(extension -> !this.isDeclaredInDomain(domainExtensions, (MuleExtension)extension)).collect(Collectors.toList());
    }

    private Consumer<IExternalDomain> notifyDomainChangedFailed(Optional<IMuleDomain> previousDomain) {
        return invalidDomain -> {
            this.setCurrentDomain((IMuleDomain)invalidDomain);
            this.onDomainChanged(previousDomain);
            MuleCorePlugin.getEventBus().fireEvent(DomainChangedEvent.changedFailed(this, invalidDomain.getMavenCoordinates()));
        };
    }

    private Consumer<IExternalDomain> onExternalDomainResolved(Optional<IMuleDomain> previousDomain) {
        return newDomain -> {
            if (newDomain.isValid()) {
                MavenDependency mavenCoordinates = newDomain.getMavenCoordinates();
                this.updateDependencies(mavenCoordinates, (IMuleProject)this);
            }
            this.notifyDomainChangedSuccessfully(previousDomain, (IMuleDomain)newDomain);
        };
    }

    private void setCurrentDomain(IMuleDomain currentDomain) {
        this.currentDomain = currentDomain;
    }

    private void notifyDomainChangedSuccessfully(Optional<IMuleDomain> previousDomain, IMuleDomain newDomain) {
        this.setCurrentDomain(newDomain);
        Optional.ofNullable(newDomain).ifPresent(dom -> dom.getMuleProjectModel().addModelListener(this.domainListener));
        this.onDomainChanged(previousDomain);
        MuleCorePlugin.getEventBus().fireEvent(DomainChangedEvent.changedSuccessfully(this, newDomain));
    }

    private void onDomainChanged(Optional<IMuleDomain> previousDomain) {
        previousDomain.filter(IMuleDomain::isExternal).ifPresent(domain -> {
            MavenDependency mavenCoordinates = domain.getMavenCoordinates();
            this.updateDependencies(mavenCoordinates, (IMuleProject)this);
        });
        this.restartModuleManager();
    }

    private void updateProjectClasspathWith(final Optional<IMuleDomain> previousDomain, final Optional<IMuleDomain> newDomain) throws CoreException {
        WorkspaceJob syncJob = new WorkspaceJob("Synchronize domain with project"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                boolean changingToDomainProject;
                EclipseDependencyManager dependencyManager = new EclipseDependencyManager();
                boolean isLinkedToDomainProject = previousDomain.map(IMuleDomain::isExternal).orElse(true) == false;
                boolean bl = changingToDomainProject = newDomain.map(IMuleDomain::isExternal).orElse(true) == false;
                if (isLinkedToDomainProject && changingToDomainProject) {
                    dependencyManager.replaceDependency(MuleProject.this.getProjectName(previousDomain), MuleProject.this.getProjectName(newDomain), MuleProject.this);
                } else if (!isLinkedToDomainProject && changingToDomainProject) {
                    dependencyManager.addDependency(MuleProject.this.getProjectName(newDomain), MuleProject.this);
                } else if (isLinkedToDomainProject && !changingToDomainProject) {
                    dependencyManager.removeDependency(MuleProject.this.getProjectName(previousDomain), MuleProject.this);
                }
                return Status.OK_STATUS;
            }
        };
        syncJob.setPriority(20);
        syncJob.setUser(false);
        syncJob.setJobGroup(SYNC_WITH_DOMAIN_CLASSPATH_JOB_GROUP);
        syncJob.schedule();
    }

    private String getProjectName(Optional<IMuleDomain> domain) {
        if (domain.isPresent()) {
            return domain.get().getDomainName();
        }
        return "";
    }

    @Override
    public boolean belongsToDomain(IMuleDomainProject muleDomain) {
        if (!this.hasDefaultDomain()) {
            MavenDependency domainCoordinates = this.getDomain().getMavenCoordinates();
            MavenDependency otherCoordinates = muleDomain.getMavenCoordinates();
            return domainCoordinates.equals(otherCoordinates);
        }
        return muleDomain.isDefault();
    }

    @Override
    public boolean hasDefaultDomain() {
        return !this.getDomainCoordinates().isPresent();
    }

    @Override
    public void accept(IMuleProjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public IMuleDomain getDomain() {
        return this.currentDomain;
    }

    @Override
    public List<MavenDependency> getDeclaredDependencies() {
        ArrayList<MavenDependency> declaredDependencies = new ArrayList<MavenDependency>();
        declaredDependencies.addAll(super.getDeclaredDependencies());
        if (this.currentDomain != null && this.currentDomain.isExternal() && this.currentDomain.isValid()) {
            declaredDependencies.add(this.getMuleProjectModel().getDomainDependency().get());
        }
        declaredDependencies.addAll(this.getMuleProjectModel().getAPISpecDependencies());
        declaredDependencies.addAll(this.getMuleProjectModel().getAsyncAPISpecDependencies());
        return declaredDependencies;
    }

    @Override
    public List<MuleExtension> getDeclaredExtensions() {
        List<MuleExtension> declaredExtensions = super.getDeclaredExtensions();
        IMuleDomain domain = this.getDomain();
        if (domain != null) {
            List<MuleExtension> domainExtensions = domain.getMuleExtensions();
            ArrayList result = Lists.newArrayList(domainExtensions);
            declaredExtensions.forEach(declaredExtension -> {
                if (!this.isDeclaredInDomain(domainExtensions, (MuleExtension)declaredExtension)) {
                    result.add(declaredExtension);
                }
            });
            return result;
        }
        return declaredExtensions;
    }

    private boolean isDeclaredInDomain(List<MuleExtension> domainExtensions, MuleExtension declaredExtension) {
        return domainExtensions.stream().anyMatch(domainExtension -> {
            MavenDependency domainDependency = MavenUtils.getDependency(domainExtension);
            MavenDependency declaredDependency = MavenUtils.getDependency(declaredExtension);
            return domainDependency.getArtifactId().equals(declaredDependency.getArtifactId()) && domainDependency.getGroupId().equals(declaredDependency.getGroupId());
        });
    }

    public String toString() {
        return "[Mule Project] Name: " + this.getName() + " - Domain: " + this.getDomainName();
    }

    @Override
    public boolean isTestResource(IResource resource) {
        boolean isTestResource = false;
        if (resource != null) {
            IPath resourceRelativePath = resource.getProjectRelativePath();
            IPath testResourcesPath = this.getTestResourcesFolder().getProjectRelativePath();
            IPath testSourcesPath = this.getTestSourceFolder().getProjectRelativePath();
            isTestResource = testResourcesPath.isPrefixOf(resourceRelativePath) ? true : (testSourcesPath.isPrefixOf(resourceRelativePath) ? true : this.isTestResource(resourceRelativePath));
        }
        return isTestResource;
    }

    private boolean isTestResource(IPath resourceRelativePath) {
        for (ProjectStructureContribution contribution : ProjectStructureContributionManager.getDefault().getContributions()) {
            IPath folderPath = Path.EMPTY.append(contribution.getFolderPath());
            if (!contribution.isTestFolder() || !folderPath.isPrefixOf(resourceRelativePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<MavenDependency> getDomainCoordinates() {
        return this.getMuleProjectModel().getDomainDependency();
    }

    @Override
    protected void registerDefinitiveListeners(IMuleProjectModel model, EventBusHelper eventBusHelper) {
        model.addModelListener(new ApplicationExtensionsValidator(this));
        model.addModelListener(new RuntimeChangeListener(this));
        model.addModelListener(new DomainChangeListener(this));
        super.registerDefinitiveListeners(model, eventBusHelper);
    }

    @Override
    public Map<File, Set<String>> getReferencedExternalConfigurations(Collection<MuleConfiguration> configurations) {
        IMuleDomain domain;
        Map<File, Set<String>> referencedConfigs = super.getReferencedExternalConfigurations(configurations);
        if (!this.hasDefaultDomain() && (domain = this.getDomain()) != null && domain.isExternal() && domain.isValid()) {
            File domainJar = ((IExternalDomain)domain).getArtifactFile();
            Map<File, List<String>> externalConfigs = this.getClasspathMuleConfigurations();
            List<String> domainConfigs = externalConfigs.get(domainJar);
            if (domainConfigs != null) {
                referencedConfigs.put(domainJar, new HashSet<String>(domainConfigs));
            }
        }
        return referencedConfigs;
    }

    private static class ApplicationExtensionsValidator
    extends MuleProjectModelListenerAdapter {
        private final MuleProject project;

        public ApplicationExtensionsValidator(MuleProject project) {
            this.project = project;
        }

        @Override
        public void extensionsAddedToModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            DomainUtils.validateDomainExtensions(this.project);
        }

        @Override
        public void extensionsRemovedFromModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            DomainUtils.validateDomainExtensions(this.project);
        }
    }

    private static class DomainChangeListener
    extends MuleProjectModelListenerAdapter {
        private final MuleProject muleProject;

        public DomainChangeListener(MuleProject muleProject) {
            this.muleProject = muleProject;
        }

        @Override
        public void domainDependencyChangedInModel(IMuleProjectModel projectModel, Optional<MavenDependency> previous, Optional<MavenDependency> current) {
            try {
                if (this.isDomainChangeApplicable(previous, current)) {
                    this.muleProject.doSetDomain(current, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error while setting domain", e);
            }
        }

        private boolean isDomainChangeApplicable(Optional<MavenDependency> previous, Optional<MavenDependency> current) throws CoreException {
            boolean equalDepedencies = previous.equals(current);
            if (!equalDepedencies) {
                return true;
            }
            if (!current.isPresent()) {
                return false;
            }
            Optional<IMuleDomainProject> domainProject = DomainUtils.findDomainProject(current.get());
            IMuleDomain currentDomain = this.muleProject.getDomain();
            return !(domainProject.isPresent() ^ (currentDomain != null && currentDomain.isExternal()));
        }
    }

    private static class DomainProjectModelListener
    extends MuleProjectModelListenerAdapter {
        private final MuleProject muleProject;

        public DomainProjectModelListener(MuleProject muleProject) {
            this.muleProject = muleProject;
        }

        @Override
        public void extensionsAddedToModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            this.muleProject.extensionsAddedToModel(projectModel, extensions);
        }

        @Override
        public void extensionsRemovedFromModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            this.muleProject.extensionsRemovedFromModel(projectModel, extensions);
        }

        @Override
        public void coordinatesChangedInModel(IMuleProjectModel projectModel, MavenDependency previous, MavenDependency current) {
            try {
                this.muleProject.doSetDomain(this.muleProject.getDomainCoordinates(), (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error while updating domain coordinates for project " + String.valueOf(this.muleProject), e);
            }
        }
    }

    private final class DomainResolutionJob
    extends Job {
        private final MavenDependency domainDependency;
        private final Optional<IMuleDomain> maybeDomain;
        private IMuleDomain newDomain;

        private DomainResolutionJob(MavenDependency domainDependency, Optional<IMuleDomain> maybeDomain) {
            super("Domain Resolution Job for " + MavenUtils.getGAV(domainDependency));
            this.domainDependency = domainDependency;
            this.maybeDomain = maybeDomain;
        }

        public IMuleDomain getDomain() {
            return this.newDomain;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.newDomain = ExternalMuleDomainReferenceManager.syncCreate(this.domainDependency, MuleProject.this, MuleProject.this.onExternalDomainResolved(this.maybeDomain), MuleProject.this.notifyDomainChangedFailed(this.maybeDomain), monitor);
            return Status.OK_STATUS;
        }
    }

    private static class RuntimeChangeListener
    extends MuleProjectModelListenerAdapter {
        private final MuleProject muleProject;

        public RuntimeChangeListener(MuleProject muleProject) {
            this.muleProject = muleProject;
        }

        @Override
        public void runtimeQualifierChangedInModel(IMuleProjectModel projectModel, Optional<String> previous, Optional<String> current) {
            current.ifPresent(qualifier -> {
                Display display = Optional.of(Display.getCurrent()).orElse(Display.getDefault());
                if (display == null) {
                    IWorkbench workbench;
                    if (PlatformUI.isWorkbenchRunning() && (workbench = PlatformUI.getWorkbench()) != null && workbench.getDisplay() != null) {
                        display = workbench.getDisplay();
                    }
                    if (display == null) {
                        MuleCorePlugin.logError("Could not find display", new RuntimeException());
                        return;
                    }
                }
                display.syncExec(() -> {
                    try {
                        this.muleProject.changeRuntime((String)qualifier, true, true);
                    }
                    catch (CoreException e) {
                        MuleCorePlugin.logError("Error while changing runtime for project " + String.valueOf(this.muleProject) + " to " + qualifier, e);
                    }
                });
            });
        }
    }
}

