/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.impl.model.BaseMuleProject;
import org.mule.tooling.core.impl.model.DomainUtils;
import org.mule.tooling.core.impl.model.MuleProjectModelListenerAdapter;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProjectVisitor;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.utils.eventbus.EventBusHelper;

public class MuleDomainProject
extends BaseMuleProject
implements IMuleDomainProject {
    public MuleDomainProject(IJavaProject javaProject) {
        super(javaProject);
    }

    @Override
    public IFolder getMuleAppsFolder() {
        return this.getProject().getFolder("src/main/mule");
    }

    public MuleProjectKind<IMuleDomainProject> getKind() {
        return MuleProjectKind.DOMAIN;
    }

    @Override
    protected void initializeFilesAndFolders(IProject project) throws CoreException {
        CoreUtils.prepareMuleDomainProjectFolders(project);
        ProjectClasspathUtils.ensureFolderIsASourceFolder(this, this.getMuleAppsFolder());
        ProjectClasspathUtils.setResourceAsDerived((IResource)this.getTargetFolder());
    }

    @Override
    public List<IClasspathEntry> getSourceFolderEntries() {
        ArrayList<IClasspathEntry> sourceFolders = new ArrayList<IClasspathEntry>();
        IFolder muleAppsFolder = this.getMuleAppsFolder();
        IClasspathEntry appsEntry = JavaCore.newSourceEntry((IPath)muleAppsFolder.getFullPath());
        sourceFolders.add(appsEntry);
        IFolder muleSourceFolder = this.getMuleSourceFolder();
        IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)muleSourceFolder.getFullPath());
        sourceFolders.add(srcEntry);
        IFolder muleResourcesFolder = this.getMuleResourcesFolder();
        IClasspathEntry srcResEntry = JavaCore.newSourceEntry((IPath)muleResourcesFolder.getFullPath());
        sourceFolders.add(srcResEntry);
        return sourceFolders;
    }

    @Override
    public void accept(IMuleProjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void beforeChangingRuntime(String beforeId, String newId) {
        super.beforeChangingRuntime(newId, beforeId);
        try {
            List childProjects = this.getChildProjects();
            for (IMuleApplicationProject childProject : childProjects) {
                childProject.changeRuntime(newId);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem updating child projects of domain " + this.getName() + " to runtime " + newId, e);
        }
    }

    @Override
    public String getDomainName() {
        return this.getMuleProjectModel().getProperty("app.domain").orElse(this.getProject().getName());
    }

    @Override
    public void setDomainName(String id) {
        if (!this.getDomainName().equals(id)) {
            this.doSetDomainName(id);
        }
    }

    private void doSetDomainName(String id) {
        this.getMuleProjectModel().setProperty("app.domain", id);
        this.setChanged();
        this.notifyObservers("prop_domain_name");
    }

    public String toString() {
        return "[Mule Domain] Name: " + this.getName();
    }

    @Override
    public PojoMavenDependency getMavenCoordinates() {
        IMuleProjectModel model = this.getMuleProjectModel();
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(model.getGroupId())).withArtifactId(model.getArtifactId())).withVersion(model.getVersion())).withClassifier("mule-domain")).build();
    }

    @Override
    public List<MuleExtension> getMuleExtensions() {
        return this.getMuleProjectModel().getMuleExtensions();
    }

    @Override
    protected void registerDefinitiveListeners(IMuleProjectModel model, EventBusHelper eventBusHelper) {
        model.addModelListener(new DomainExtensionsValidator(this));
        super.registerDefinitiveListeners(model, eventBusHelper);
    }

    private static class DomainExtensionsValidator
    extends MuleProjectModelListenerAdapter {
        private final MuleDomainProject domainProject;

        public DomainExtensionsValidator(MuleDomainProject domainProject) {
            this.domainProject = domainProject;
        }

        @Override
        public void extensionsAddedToModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            DomainUtils.validateChildrenApplicationExtensions(this.domainProject);
        }

        @Override
        public void extensionsRemovedFromModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            DomainUtils.validateChildrenApplicationExtensions(this.domainProject);
        }

        @Override
        public void coordinatesChangedInModel(IMuleProjectModel projectModel, MavenDependency previous, MavenDependency current) {
            try {
                this.domainProject.getChildProjects().forEach(childProject -> {
                    PomMuleProjectModel pomModel = (PomMuleProjectModel)childProject.getMuleProjectModel();
                    pomModel.compareAndNotifyDomain(Optional.ofNullable(previous), Optional.ofNullable(current));
                });
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error while retrieving child projects for domain " + String.valueOf(this.domainProject), e);
            }
        }
    }
}

