/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.impl.model.ExternalMuleDomainReference;
import org.mule.tooling.core.impl.model.InvalidExternalMuleDomainReference;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.m2.DependencyResolutionConfiguration;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.model.IExternalDomain;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.DependenciesCallback;
import org.mule.tooling.core.module.runner.IArtifactResolvingRunner;
import org.mule.tooling.utils.ObjectHolder;

public class ExternalMuleDomainReferenceManager {
    private final Map<MavenDependency, ExternalMuleDomainReference> domainArtifacts;
    private final Object lock = new Object();

    private static ExternalMuleDomainReferenceManager instance() {
        return Singleton.instance;
    }

    private ExternalMuleDomainReferenceManager() {
        this.domainArtifacts = new HashMap<MavenDependency, ExternalMuleDomainReference>();
    }

    public static IMuleDomain syncCreate(MavenDependency domainDependency, IMuleApplicationProject applicationProject, Consumer<IExternalDomain> onSuccessCallback, Consumer<IExternalDomain> onFailCallback, IProgressMonitor monitor) {
        return ExternalMuleDomainReferenceManager.instance().create(domainDependency, applicationProject, onSuccessCallback, onFailCallback, ArtifactResolvingRunnerFactory.syncInstance(), monitor);
    }

    public static void asyncCreate(MavenDependency domainDependency, IMuleApplicationProject applicationProject, Consumer<IExternalDomain> onSuccessCallback, Consumer<IExternalDomain> onFailCallback, IProgressMonitor monitor) {
        ExternalMuleDomainReferenceManager.instance().create(domainDependency, applicationProject, onSuccessCallback, onFailCallback, ArtifactResolvingRunnerFactory.asyncInstance(), monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMuleDomain create(MavenDependency domainDependency, IMuleApplicationProject applicationProject, Consumer<IExternalDomain> onSuccessCallback, Consumer<IExternalDomain> onFailCallback, IArtifactResolvingRunner artifactResolvingRunner, IProgressMonitor monitor) {
        IExternalDomain domainReference = this.domainArtifacts.get(domainDependency);
        if (domainReference == null) {
            Object object = this.lock;
            synchronized (object) {
                domainReference = this.domainArtifacts.get(domainDependency);
                if (domainReference == null) {
                    PojoMavenDependency toBeDownloaded = ((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.copyFrom(domainDependency).withClassifier("mule-domain")).build();
                    ObjectHolder domainReferenceHolder = new ObjectHolder();
                    artifactResolvingRunner.runResolvingDependencies(applicationProject, Arrays.asList(toBeDownloaded), DependenciesCallback.builder().onSuccess(this.onSuccess(toBeDownloaded, (ObjectHolder<IExternalDomain>)domainReferenceHolder, onSuccessCallback, onFailCallback)).onError(this.onError(onFailCallback, (ObjectHolder<IExternalDomain>)domainReferenceHolder, toBeDownloaded)).build(), DependencyResolutionConfiguration.createDefault().includeProvidedScope(), monitor);
                    domainReference = (IExternalDomain)domainReferenceHolder.get();
                } else {
                    onSuccessCallback.accept(domainReference);
                }
            }
        } else {
            onSuccessCallback.accept(domainReference);
        }
        return domainReference;
    }

    private Consumer<Map<MavenDependency, List<Exception>>> onError(Consumer<IExternalDomain> onFailCallback, ObjectHolder<IExternalDomain> domainReferenceHolder, PojoMavenDependency toBeDownloaded) {
        return dependencyExceptions -> this.notifyInvalidExternalDomain(toBeDownloaded, domainReferenceHolder, onFailCallback);
    }

    private Consumer<Map<MavenDependency, File>> onSuccess(MavenDependency toBeDownloaded, ObjectHolder<IExternalDomain> holder, Consumer<IExternalDomain> successCallback, Consumer<IExternalDomain> onFailCallback) {
        return dependencyFiles -> {
            try {
                File artifactFile = (File)dependencyFiles.get(toBeDownloaded);
                if (artifactFile == null) {
                    this.notifyInvalidExternalDomain(toBeDownloaded, holder, onFailCallback);
                    return;
                }
                String pomFileName = toBeDownloaded.getArtifactId() + "-" + toBeDownloaded.getVersion() + ".pom";
                File pomFile = new File(artifactFile.getParentFile(), pomFileName);
                PomMuleProjectModel pomModel = PomMuleProjectModel.create(pomFile, (ProjectInitializationData)ProjectInitializationData.EmptyData.instance());
                ExternalMuleDomainReference domainReference = new ExternalMuleDomainReference(toBeDownloaded, pomModel, artifactFile);
                this.domainArtifacts.put(toBeDownloaded, domainReference);
                holder.set((Object)domainReference);
                successCallback.accept(domainReference);
            }
            catch (IOException e) {
                MuleCorePlugin.logError("Error while reading domain model", e);
            }
        };
    }

    private void notifyInvalidExternalDomain(MavenDependency toBeDownloaded, ObjectHolder<IExternalDomain> holder, Consumer<IExternalDomain> onFailCallback) {
        InvalidExternalMuleDomainReference invalidDomainReference = new InvalidExternalMuleDomainReference(toBeDownloaded);
        holder.set((Object)invalidDomainReference);
        onFailCallback.accept(invalidDomainReference);
    }

    private static class Singleton {
        private static final ExternalMuleDomainReferenceManager instance = new ExternalMuleDomainReferenceManager();

        private Singleton() {
        }
    }
}

