/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import java.io.File;
import java.util.List;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.impl.model.DomainMavenDependencyComparator;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IExternalDomain;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;

public class ExternalMuleDomainReference
implements IExternalDomain {
    private final MavenDependency domainDependency;
    private final PomMuleProjectModel pomModel;
    private final File artifactFile;

    protected ExternalMuleDomainReference(MavenDependency domainDependency, PomMuleProjectModel pomModel, File artifactFile) {
        this.domainDependency = domainDependency;
        this.pomModel = pomModel;
        this.artifactFile = artifactFile;
    }

    @Override
    public String getDomainName() {
        return DomainMavenDependencyComparator.toGavString(this.domainDependency);
    }

    @Override
    public MavenDependency getMavenCoordinates() {
        return this.domainDependency;
    }

    @Override
    public IServerDefinition getServerDefinition() {
        String runtimeQualifier = this.pomModel.getRuntimeQualifier().orElse(CoreUtils.getDefaultServerRuntimeId());
        return MuleCorePlugin.getServerManager().getServerDefinition(runtimeQualifier);
    }

    @Override
    public List<MuleExtension> getMuleExtensions() {
        return this.pomModel.getMuleExtensions();
    }

    @Override
    public File getArtifactFile() {
        return this.artifactFile;
    }

    @Override
    public IMuleProjectModel getMuleProjectModel() {
        return this.pomModel;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

