/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.model.project.MuleExtension;

public class DomainValidationUtils {
    public static void validateChildrenApplicationExtensions(IMuleDomainProject domainProject) {
        try {
            for (IMuleApplicationProject childProject : domainProject.getChildProjects()) {
                DomainValidationUtils.validateDomainExtensions(childProject);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while retrieving all child projects for domain " + domainProject.getName(), e);
        }
    }

    public static void validateDomainExtensions(IMuleApplicationProject project) {
        try {
            List<MuleExtension> projectExtensions = project.getMuleProjectModel().getMuleExtensions();
            final IMuleDomain domain = project.getDomain();
            List<Object> domainExtensions = domain == null ? Collections.emptyList() : domain.getMuleExtensions();
            final IFile pomFile = project.getMuleProjectDescriptorFile();
            IMarker[] markers = pomFile.findMarkers("org.mule.tooling.maven.pomError", true, 2);
            final Stream<IMarker> markersToDelete = Arrays.stream(markers).filter(marker -> marker.getAttribute("pomErrorKind", "other").equals("conflictingExtension"));
            final Stream<MuleExtension> conflictingExtensions = projectExtensions.stream().filter(domainExtensions::contains);
            WorkspaceJob validationJob = new WorkspaceJob("Refresh POM validation markers"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    conflictingExtensions.forEach(extension -> {
                        try {
                            DomainValidationUtils.createPomMarker(pomFile, extension, domain);
                        }
                        catch (CoreException e) {
                            MuleCorePlugin.logError("Error when creating marker for resource " + String.valueOf(pomFile), e);
                        }
                    });
                    markersToDelete.forEach(marker -> {
                        try {
                            marker.delete();
                        }
                        catch (CoreException e) {
                            MuleCorePlugin.logError("Error when deleting marker for resource " + String.valueOf(marker.getResource()), e);
                        }
                    });
                    return Status.OK_STATUS;
                }
            };
            validationJob.setPriority(20);
            validationJob.schedule();
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while retrieving domain for project " + project.getName(), e);
        }
    }

    public static void validateExtensions(IMuleProject project) {
        if (MuleProjectKind.APPLICATION.classifies(project)) {
            DomainValidationUtils.validateDomainExtensions(MuleProjectKind.APPLICATION.adapt(project));
        } else if (MuleProjectKind.DOMAIN.classifies(project)) {
            DomainValidationUtils.validateChildrenApplicationExtensions(MuleProjectKind.DOMAIN.adapt(project));
        }
    }

    private static IMarker createPomMarker(IFile pomFile, MuleExtension extension, IMuleDomain domain) throws CoreException {
        IMarker marker = pomFile.createMarker("org.mule.tooling.maven.pomError");
        marker.setAttribute("severity", 1);
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("pomErrorKind", (Object)"conflictingExtension");
        marker.setAttribute("message", (Object)("There is a multiple definition both in application and linked domain (" + domain.getDomainName() + ") of module " + extension.getName() + ". Right-click for a quick fix."));
        return marker;
    }
}

