/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.deployer.DefaultPackagingRequest;
import org.mule.tooling.core.event.DomainChangedEventHandler;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.impl.model.DomainMavenDependencyComparator;
import org.mule.tooling.core.m2.PomMuleProjectModel;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IExternalDomain;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomain;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.packageManager.IExportPackageManager;
import org.mule.tooling.core.packageManager.MuleExportStatus;
import org.mule.tooling.core.packageManager.PackagingOptions;
import org.mule.tooling.core.utils.JobUtils;
import org.mule.tooling.core.utils.StudioFileUtils;
import org.mule.tooling.model.project.MuleExtension;

public class DomainUtils {
    private static final String PROP_DOMAIN_VALIDATION_THREAD_COUNT = "org.mule.tooling.domain.validation.threadCount";
    public static final int DOMAIN_VALIDATION_THREAD_COUNT = Integer.parseInt(System.getProperty("org.mule.tooling.domain.validation.threadCount", "8"));
    private static final JobGroup DOMAIN_VALIDATION_JOB_GROUP = JobUtils.createJobGroup("Domain validation", DOMAIN_VALIDATION_THREAD_COUNT);
    public static final Set<String> GLOBAL_ELEMENTS_BLOCK_LIST = Sets.newHashSet((Object[])new String[]{"http://www.mulesoft.org/schema/mule/api-gateway/autodiscovery", "http://www.mulesoft.org/schema/mule/ee/core/object-store-caching-strategy"});

    public static String getDeployableArtifactName(IMuleProject muleProject) {
        return PomMuleProjectModel.create(muleProject.getMuleProjectDescriptorFile()).getArtifactFinalName(PackagingOptions.DEFAULT, new Properties());
    }

    public static Optional<IMuleDomainProject> findDomainProject(MavenDependency dependency2) throws CoreException {
        List<IMuleDomainProject> domainProjects = MuleRuntime.getMuleProjects(MuleProjectKind.DOMAIN);
        return domainProjects.stream().filter(domainProject -> DomainMavenDependencyComparator.correspondsTo(dependency2, domainProject.getMavenCoordinates())).findAny();
    }

    public static Optional<IMuleDomainProject> findDomainProjectSafely(MavenDependency dependency2) {
        try {
            return DomainUtils.findDomainProject(dependency2);
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while fetching domain project for dependency" + DomainMavenDependencyComparator.toGavString(dependency2), e);
            return Optional.empty();
        }
    }

    public static File buildDomainArtifactIfNeeded(IMuleDomain domain, IProgressMonitor monitor) {
        File outputFile = null;
        Optional<IMuleDomainProject> maybeDomainProject = DomainUtils.findDomainProjectSafely(domain.getMavenCoordinates());
        if (maybeDomainProject.isPresent()) {
            IMuleDomainProject domainProject = maybeDomainProject.get();
            String deployableArtifactName = DomainUtils.getDeployableArtifactName(domainProject);
            DefaultPackagingRequest packagingRequest = DefaultPackagingRequest.builder(domainProject).outputFile(new File(StudioFileUtils.getTempDirectory(), deployableArtifactName + ".jar")).build();
            MuleExportStatus exportStatus = IExportPackageManager.get().export(packagingRequest, monitor);
            if (exportStatus.isOk().booleanValue()) {
                outputFile = exportStatus.getExportedProject().get();
            }
        } else {
            IExternalDomain externalDomain = (IExternalDomain)domain;
            outputFile = externalDomain.getArtifactFile();
        }
        return outputFile;
    }

    public static MavenDependency toDomainDependencyCoordinates(MavenDependency domainCoordinates) {
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.copyFrom(domainCoordinates).withClassifier("mule-domain")).withScope(MavenDependency.Scope.PROVIDED)).build();
    }

    public static void validateChildrenApplicationExtensions(IMuleDomainProject domainProject) {
        try {
            for (IMuleApplicationProject childProject : domainProject.getChildProjects()) {
                DomainUtils.validateDomainExtensions(childProject);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("Error while retrieving all child projects for domain " + domainProject.getName(), e);
        }
    }

    public static void validateDomainExtensions(final IMuleApplicationProject project) {
        WorkspaceJob validationJob = new WorkspaceJob("Refresh POM validation markers"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (project.getProject().isAccessible()) {
                    IMuleDomain domain = project.getDomain();
                    IFile pomFile = project.getMuleProjectDescriptorFile();
                    if (pomFile.isAccessible()) {
                        IMarker[] markers = pomFile.findMarkers("org.mule.tooling.maven.moduleConflict", true, 2);
                        Stream<IMarker> markersToDelete = Arrays.stream(markers).filter(marker -> marker.getAttribute("pomErrorKind", "other").equals("conflictingExtension"));
                        Stream<MuleExtension> conflictingExtensions = DomainUtils.findConflictingExtensions(project, domain);
                        conflictingExtensions.forEach(extension -> {
                            try {
                                IMarker marker = DomainUtils.createPomMarker(pomFile, "conflictingExtension", "There is a multiple definition both in application and linked domain (" + domain.getDomainName() + ") of module " + extension.getName() + ". Right-click for a quick fix.", 1);
                                marker.setAttribute("conflictingMuleExtensionName", (Object)extension.getName());
                                marker.setAttribute("conflictingMuleExtensionScope", (Object)extension.getScope());
                            }
                            catch (CoreException e) {
                                MuleCorePlugin.logError("Error when creating marker for resource " + String.valueOf(pomFile), e);
                            }
                        });
                        markersToDelete.forEach(marker -> {
                            try {
                                marker.delete();
                            }
                            catch (CoreException e) {
                                MuleCorePlugin.logError("Error when deleting marker for resource " + String.valueOf(marker.getResource()), e);
                            }
                        });
                    }
                }
                return Status.OK_STATUS;
            }
        };
        validationJob.setRule((ISchedulingRule)project.getProject());
        validationJob.setPriority(20);
        validationJob.schedule();
    }

    public static Stream<MuleExtension> findConflictingExtensions(IMuleProject project, IMuleDomain domain) {
        List<MuleExtension> projectExtensions = project.getMuleProjectModel().getMuleExtensions();
        List<Object> domainExtensions = domain == null ? Collections.emptyList() : domain.getMuleExtensions();
        return projectExtensions.stream().filter(extension -> domainExtensions.stream().anyMatch(domainExtension -> DomainUtils.correspondingExtension(extension, domainExtension)));
    }

    private static boolean correspondingExtension(MuleExtension extension1, MuleExtension extension2) {
        MavenDependency dependency1 = MavenUtils.getDependency(extension1);
        MavenDependency dependency2 = MavenUtils.getDependency(extension2);
        return dependency1.getArtifactId().equals(dependency2.getArtifactId()) && dependency1.getGroupId().equals(dependency2.getGroupId());
    }

    public static void validateExtensions(IMuleProject project) {
        if (MuleProjectKind.APPLICATION.classifies(project)) {
            DomainUtils.validateDomainExtensions(MuleProjectKind.APPLICATION.adapt(project));
        } else if (MuleProjectKind.DOMAIN.classifies(project)) {
            DomainUtils.validateChildrenApplicationExtensions(MuleProjectKind.DOMAIN.adapt(project));
        }
    }

    public static void validateAllApplicationProjects() throws CoreException {
        List<IMuleApplicationProject> applicationProjects = MuleRuntime.getMuleApplicationProjects();
        for (IMuleApplicationProject applicationProject : applicationProjects) {
            DomainUtils.validateDomainExtensions(applicationProject);
        }
    }

    private static IMarker createPomMarker(IFile pomFile, String pomErrorKind, String message, int severity) throws CoreException {
        IMarker marker = pomFile.createMarker("org.mule.tooling.maven.moduleConflict");
        marker.setAttribute("severity", severity);
        marker.setAttribute("lineNumber", 1);
        marker.setAttribute("pomErrorKind", (Object)pomErrorKind);
        marker.setAttribute("message", (Object)message);
        return marker;
    }

    public static class DomainExtensionsValidator
    implements IMuleProjectEventListener {
        @Override
        public void onMuleProjectOpened(IProject project) {
            this.validateProjectExtensions(project);
        }

        @Override
        public void onMuleProjectClosed(IProject project) {
        }

        private void validateProjectExtensions(IProject project) {
            Job validateExtensionsJob = Job.createSystem((String)"Validating domain extensions", monitor -> {
                try {
                    Object muleProject = MuleRuntime.create(project);
                    if (muleProject == null) {
                        DomainUtils.validateAllApplicationProjects();
                    } else {
                        DomainUtils.validateExtensions(muleProject);
                    }
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError("Error while validating domain extensions", e);
                }
            });
            validateExtensionsJob.setJobGroup(DOMAIN_VALIDATION_JOB_GROUP);
            validateExtensionsJob.schedule();
        }

        @Override
        public void onMuleProjectPreClose(IMuleProject muleProject) {
            Job.createSystem((String)"Validating domain extensions", monitor -> DomainUtils.validateExtensions(muleProject)).schedule();
        }
    }

    public static class DomainResolutionValidator
    implements DomainChangedEventHandler {
        @Override
        public void onDomainChangedSuccessfully(IMuleApplicationProject applicationProject, IMuleDomain domain) {
            final IFile muleProjectDescriptorFile = applicationProject.getMuleProjectDescriptorFile();
            WorkspaceJob validationJob = new WorkspaceJob("Domain not found marker creation"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    Optional<IMarker> domainNotFoundMarker = this.findDomainNotFoundMarker(muleProjectDescriptorFile);
                    if (domainNotFoundMarker.isPresent()) {
                        IMarker marker = domainNotFoundMarker.get();
                        marker.delete();
                    }
                    return Status.OK_STATUS;
                }
            };
            validationJob.setPriority(20);
            validationJob.setJobGroup(DOMAIN_VALIDATION_JOB_GROUP);
            validationJob.schedule();
        }

        @Override
        public void onDomainChangedFailed(IMuleApplicationProject applicationProject, MavenDependency domainDependency) {
            final String domainGav = DomainMavenDependencyComparator.toGavString(domainDependency);
            final IFile muleProjectDescriptorFile = applicationProject.getMuleProjectDescriptorFile();
            WorkspaceJob validationJob = new WorkspaceJob("Domain not found marker creation"){

                public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                    Optional<IMarker> existingMarker = this.findDomainNotFoundMarker(muleProjectDescriptorFile);
                    if (existingMarker.isPresent()) {
                        existingMarker.get().delete();
                    }
                    DomainUtils.createPomMarker(muleProjectDescriptorFile, "domainNotFound", "Could not retrieve domain " + domainGav, 2);
                    return Status.OK_STATUS;
                }
            };
            validationJob.setJobGroup(DOMAIN_VALIDATION_JOB_GROUP);
            validationJob.setPriority(20);
            validationJob.schedule();
        }

        private Optional<IMarker> findDomainNotFoundMarker(IFile muleProjectDescriptorFile) throws CoreException {
            if (!muleProjectDescriptorFile.exists()) {
                muleProjectDescriptorFile.getParent().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
            }
            IMarker[] markers = muleProjectDescriptorFile.findMarkers("org.mule.tooling.maven.pomError", true, 0);
            Optional<IMarker> domainNotFoundMarker = Arrays.stream(markers).filter(marker -> marker.getAttribute("pomErrorKind", "other").equals("domainNotFound")).findAny();
            return domainNotFoundMarker;
        }
    }
}

