/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.core.impl.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.action.ProjectLifecycleAction;
import org.mule.tooling.core.analytics.AnalyticsRecordsFactory;
import org.mule.tooling.core.analytics.Events;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.cache.internal.MuleConfigurationsCache;
import org.mule.tooling.core.classloader.ProjectClasspathUtils;
import org.mule.tooling.core.dependencymanagement.EclipseDependencyManager;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.IClasspathEventListener;
import org.mule.tooling.core.event.IMuleProjectEventListener;
import org.mule.tooling.core.event.MuleModuleManagerRestartedEvent;
import org.mule.tooling.core.event.MuleProjectModifiedEvent;
import org.mule.tooling.core.event.MuleRuntimeChangedEvent;
import org.mule.tooling.core.externalNames.ExternalConfigsManagementUtils;
import org.mule.tooling.core.impl.model.MuleProjectModelListenerAdapter;
import org.mule.tooling.core.impl.model.ProjectInitializationData;
import org.mule.tooling.core.impl.model.ProjectModelLoaderResourceListener;
import org.mule.tooling.core.impl.model.SynchronizeMuleProjectWithClasspathJob;
import org.mule.tooling.core.io.EditingScope;
import org.mule.tooling.core.io.MuleResourceUtils;
import org.mule.tooling.core.io.ProjectModelLoadingResult;
import org.mule.tooling.core.m2.Repository;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.dependency.PojoMavenDependencyBuilder;
import org.mule.tooling.core.m2.internal.MavenCore;
import org.mule.tooling.core.m2.internal.markers.ExtensionResolutionRule;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.IMuleProjectComponent;
import org.mule.tooling.core.model.MuleProjectComponentManager;
import org.mule.tooling.core.model.ProjectModelState;
import org.mule.tooling.core.module.ExternalContributionMuleModule;
import org.mule.tooling.core.module.IMuleModuleManager;
import org.mule.tooling.core.module.MuleModuleManagerFactory;
import org.mule.tooling.core.module.internal.ILinkableModuleManager;
import org.mule.tooling.core.module.internal.LinkedModuleManager;
import org.mule.tooling.core.module.internal.SingleExtensionModuleManager;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.core.runtime.MuleClasspathContainer;
import org.mule.tooling.core.runtime.server.ISchemaLocationLookup;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ProjectSchemaLocationLookup;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.core.utils.MuleUserLibraryClasspathContainer;
import org.mule.tooling.core.utils.WorkspaceResourceJob;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.project.IMuleProjectModel;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.tooling.model.project.ObjectFactory;
import org.mule.tooling.utils.LazyValue;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;
import org.mule.tooling.utils.job.SequentialJobScheduler;

public abstract class BaseMuleProject
extends Observable
implements IMuleProject,
IClasspathEventListener {
    public static final String ADD_DEPENDENCY_JOB_TITLE = "Adding %s dependencies to the project classpath...";
    public static final String REMOVE_DEPENDENCY_JOB_TITLE = "Removing %s dependencies from the project classpath...";
    public static final String UPDATE_DEPENDENCIES_JOB_TITLE = "Updating %s dependencies in the project classpath...";
    private volatile ProjectModelLoadingResult modelLoadingResult = null;
    private final SequentialJobScheduler sequentialJobScheduler;
    private volatile LinkedModuleManager rootModuleManager;
    protected final IJavaProject javaProject;
    private final EventBusHelper eventBusHelper = new EventBusHelper();
    private final EclipseDependencyManager dependencyManager;
    private final Map<File, List<String>> classpathMuleConfigurations;
    protected MuleConfigurationsCache cache;
    private final LazyValue<ISchemaLocationLookup> schemaLocationLookup;
    private final Observer projectObserver;
    private IResourceChangeListener afterSaveListener;

    public BaseMuleProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
        this.cache = new MuleConfigurationsCache(this);
        this.dependencyManager = new EclipseDependencyManager();
        this.classpathMuleConfigurations = new ConcurrentHashMap<File, List<String>>();
        this.sequentialJobScheduler = new SequentialJobScheduler();
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_JAR_ADDED, (IEventHandler)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_JAR_REMOVED, (IEventHandler)this);
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_API_SPEC_REMOVED, (IEventHandler)this);
        this.projectObserver = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                MuleCorePlugin.getEventBus().fireEvent((IEvent)new MuleProjectModifiedEvent(BaseMuleProject.this, String.valueOf(arg)));
            }
        };
        this.addObserver(this.projectObserver);
        this.schemaLocationLookup = new LazyValue(() -> new ProjectSchemaLocationLookup(this));
    }

    @Override
    public IFolder getMuleSourceFolder() {
        return this.getFolder("src/main/java");
    }

    @Override
    public ProjectModelState getProjectModelState() {
        return this.getMuleProjectModel().getModelState();
    }

    @Override
    public IMuleProjectModel getMuleProjectModel() {
        return this.getMuleProjectModel(ProjectInitializationData.EmptyData.instance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IMuleProjectModel getMuleProjectModel(ProjectInitializationData initData) {
        ProjectModelLoadingResult result = this.modelLoadingResult;
        if (result == null || !result.isDefinitive()) {
            BaseMuleProject baseMuleProject = this;
            synchronized (baseMuleProject) {
                result = this.modelLoadingResult;
                if (result == null || !result.isDefinitive()) {
                    ProjectModelLoadingResult modelResult = this.loadMuleProjectModel(initData);
                    IMuleProjectModel model = modelResult.getModel();
                    if (modelResult.isDefinitive()) {
                        this.registerDefinitiveListeners(model, this.eventBusHelper);
                    } else {
                        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new ProjectModelLoaderResourceListener(this));
                    }
                    this.modelLoadingResult = result = modelResult;
                }
            }
        }
        return result.getModel();
    }

    protected ProjectModelLoadingResult loadMuleProjectModel(ProjectInitializationData initData) {
        return MuleResourceUtils.loadMuleProjectModel(this.getProject(), initData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restartModuleManager() {
        BaseMuleProject baseMuleProject = this;
        synchronized (baseMuleProject) {
            this.rootModuleManager = null;
            this.getModuleManager();
            this.synchronizeProjectClasspath(this.getMuleProjectModel());
        }
    }

    protected void registerDefinitiveListeners(IMuleProjectModel model, EventBusHelper eventBusHelper) {
        model.addModelListener(new DependenciesProjectModelListener(this));
        model.addModelListener(new ExtensionsProjectModelListener(this));
        model.addModelListener(new APISpecDependenciesModelListener(this));
        this.synchronizeProjectClasspath(model);
    }

    private void initializeModuleManager(Optional<String> runtimeQualifier, List<MuleExtension> extensions) {
        String runtimeId = runtimeQualifier.orElseGet(CoreUtils::getDefaultServerRuntimeId);
        IServerDefinition serverDefinition = Optional.ofNullable(MuleCorePlugin.getServerManager().getServerDefinition(runtimeId)).orElseGet(CoreUtils::getDefaultServer);
        LinkedModuleManager coreModuleManager = new LinkedModuleManager((ILinkableModuleManager)((Object)serverDefinition.getModuleManager()));
        this.rootModuleManager = new LinkedModuleManager(coreModuleManager);
        extensions.stream().filter(ext -> !ext.getScope().equals(MavenDependency.Scope.TEST.asString())).forEach(ext -> this.resolveAndAppendModuleManager(coreModuleManager, (MuleExtension)ext));
        extensions.stream().filter(ext -> ext.getScope().equals(MavenDependency.Scope.TEST.asString())).forEach(ext -> this.resolveAndAppendModuleManager(this.rootModuleManager, (MuleExtension)ext));
    }

    protected void setRuntimeInClasspath(String beforeId, String newId) throws CoreException {
        IJavaProject javaProject = this.getJavaProject();
        ProjectClasspathUtils.removeClasspathEntry(MuleClasspathContainer.getContainerPath(), javaProject, 1);
        if (!MuleClasspathContainer.hasMuleClasspathContainer(javaProject, newId)) {
            MuleClasspathContainer.addMuleClasspathContainer(javaProject, newId);
        }
    }

    protected void synchronizeProjectClasspath(IMuleProjectModel initializingModel) {
        SynchronizeMuleProjectWithClasspathJob synchronizeJob = this.getSynchronizeJob(initializingModel);
        synchronizeJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                BaseMuleProject.this.registerAsExtensionEventsListener();
            }
        });
        synchronizeJob.schedule();
    }

    private SynchronizeMuleProjectWithClasspathJob getSynchronizeJob(IMuleProjectModel initializingModel) {
        SynchronizeMuleProjectWithClasspathJob synchronizeJob = new SynchronizeMuleProjectWithClasspathJob(this, initializingModel);
        synchronizeJob.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        synchronizeJob.setPriority(50);
        synchronizeJob.setUser(false);
        synchronizeJob.setSystem(true);
        return synchronizeJob;
    }

    public void initialize(ProjectInitializationData initData) {
        this.cache.initialize();
    }

    public void postInitialize() throws CoreException {
        this.initializeProjectStructure();
        this.onPostInitialize();
    }

    protected void initializeProjectStructure() throws CoreException {
        IProject project = this.getProject();
        this.afterSaveListener = new AfterSaveListener(project);
        if (!project.getWorkspace().isTreeLocked()) {
            this.initializeFilesAndFolders(project);
        } else {
            project.getWorkspace().addResourceChangeListener(this.afterSaveListener, 16);
        }
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ResourceEvents.ON_MULE_PROJECT_EVENT, (IEventHandler)new IMuleProjectEventListener(){

            @Override
            public void onMuleProjectOpened(IProject project) {
            }

            @Override
            public void onMuleProjectClosed(IProject project) {
                if (project.equals((Object)BaseMuleProject.this.getProject())) {
                    BaseMuleProject.this.close();
                }
            }
        });
    }

    public void close() {
        this.unregisterListeners();
        this.cache = null;
        this.deleteObserver(this.projectObserver);
        if (this.afterSaveListener != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.afterSaveListener);
        }
    }

    public Map<File, Set<String>> getReferencedExternalConfigurations(Collection<MuleConfiguration> newConfigurations) {
        HashMap<File, Set<String>> referencedExternalConfigurations = new HashMap<File, Set<String>>();
        Set<String> importedFileNames = ExternalConfigsManagementUtils.getImportedConfigurations(newConfigurations);
        for (Map.Entry<File, List<String>> entry : this.getClasspathMuleConfigurations().entrySet()) {
            HashSet importedFilesInJar = new HashSet(entry.getValue());
            importedFilesInJar.retainAll(importedFileNames);
            if (importedFileNames.isEmpty()) continue;
            referencedExternalConfigurations.put(entry.getKey(), importedFilesInJar);
        }
        return referencedExternalConfigurations;
    }

    protected abstract void initializeFilesAndFolders(IProject var1) throws CoreException;

    protected void registerAsExtensionEventsListener() {
        this.eventBusHelper.registerListener(MuleCorePlugin.getEventBus(), CoreEventTypes.ON_EXTENSION_REMOVED, (IEventHandler)this);
    }

    protected void onPostInitialize() {
        List<ProjectLifecycleAction> postInitActions = CoreUtils.getExtensionPointObjects("org.mule.tooling.core.postProjectInitActions", ProjectLifecycleAction.class);
        for (ProjectLifecycleAction postInitAction : postInitActions) {
            try {
                postInitAction.execute(this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (Throwable t) {
                MuleCorePlugin.logError("Error while executing ProjectLifecycleAction..." + postInitAction.getClass().toString(), t);
            }
        }
    }

    @Override
    public IMuleModuleManager getModuleManager() {
        return this.getModuleManager(EditingScope.getCurrent());
    }

    @Override
    public IMuleModuleManager getModuleManager(EditingScope scope) {
        if (scope.belongsTo(EditingScope.TEST)) {
            return this.getRootModuleManager();
        }
        return this.getNonTestModuleManager();
    }

    private IMuleModuleManager getNonTestModuleManager() {
        return (IMuleModuleManager)((Object)this.getRootModuleManager().getInnerManager());
    }

    @Override
    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    @Override
    public IMuleConfigurationsCache getConfigurationsCache() {
        return this.cache;
    }

    @Override
    public String getName() {
        return this.getProject().getName();
    }

    @Override
    public String getLabel() {
        return this.getMuleProjectModel().getName();
    }

    @Override
    public void setLabel(String name) {
        this.getMuleProjectModel().setName(name);
        this.setChanged();
        this.notifyObservers("name");
    }

    @Override
    public String getDescription() {
        return this.getMuleProjectModel().getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.getMuleProjectModel().setDescription(description);
    }

    @Override
    public String getRuntimeId() {
        String realRuntimeId = this.getMuleProjectModel().getRuntimeQualifier().orElse(CoreUtils.getDefaultServerRuntimeId());
        return CoreUtils.isServerAvailable(realRuntimeId) ? realRuntimeId : CoreUtils.getDefaultServerRuntimeId();
    }

    public void setRuntimeId(String id) {
        this.getMuleProjectModel().setRuntimeQualifier(id);
    }

    @Override
    public IServerDefinition getServerDefinition() {
        return MuleCorePlugin.getServerManager().getServerDefinition(this.getRuntimeId());
    }

    @Override
    public void changeRuntime(String newId) throws CoreException {
        this.changeRuntime(newId, true);
    }

    public void changeRuntime(String newId, boolean actOnClassPath) throws CoreException {
        this.changeRuntime(newId, actOnClassPath, false);
    }

    public void changeRuntime(String newId, boolean actOnClassPath, boolean force) throws CoreException {
        String beforeId = this.getMuleProjectModel().getRuntimeQualifier().orElse("");
        if (beforeId.equals(newId) && !force) {
            return;
        }
        this.beforeChangingRuntime(beforeId, newId);
        if (!beforeId.equals(newId)) {
            this.setRuntimeId(newId);
        }
        List<MuleExtension> declaredExtensions = this.getDeclaredExtensions();
        this.initializeModuleManager(Optional.of(newId), declaredExtensions);
        this.clearConfigurationsCache();
        if (actOnClassPath) {
            this.setRuntimeInClasspath(beforeId, newId);
        }
        this.afterChangingRuntime(beforeId, newId);
    }

    protected void afterChangingRuntime(String newId, String beforeId) {
        MuleCorePlugin.getEventBus().fireEvent((IEvent)MuleRuntimeChangedEvent.createAfterRuntimeChangeEvent(beforeId, newId, this));
    }

    protected void beforeChangingRuntime(String newId, String beforeId) {
        MuleCorePlugin.getEventBus().fireEvent((IEvent)MuleRuntimeChangedEvent.createBeforeRuntimeChangeEvent(beforeId, newId, this));
    }

    @Override
    public IFolder getFolder(String folderPath) {
        return this.getProject().getFolder(folderPath);
    }

    @Override
    public IFolder getMuleResourcesFolder() {
        return this.getFolder("src/main/resources");
    }

    @Override
    public IFolder getMuleResourcesFolder(EditingScope scope) {
        String resource = scope.belongsTo(EditingScope.APP) ? "src/main/resources" : "src/test/resources";
        return this.getFolder(resource);
    }

    @Override
    public abstract IFolder getMuleAppsFolder();

    @Override
    public IFolder getTargetFolder() {
        return this.getFolder("target");
    }

    @Override
    public IFile getMuleProjectDescriptorFile() {
        return this.getFile("pom.xml");
    }

    @Override
    public IFolder getProjectRootFolder() {
        return this.getFolder("/" + this.getName());
    }

    @Override
    public IFile getClasspathFile() {
        return this.getFile("/.classpath");
    }

    @Override
    public IFile getProjectFile() {
        return this.getFile("/.project");
    }

    @Override
    public void save() throws CoreException {
    }

    @Override
    public IFile getFile(String path) {
        return this.getProject().getFile(path);
    }

    @Override
    public IFile getFile(IPath path) {
        return this.getProject().getFile(path);
    }

    @Override
    public IFile getMuleArtifactFile() {
        return this.getFile("/mule-artifact.json");
    }

    protected void dependenciesAddedToModel(IMuleProjectModel projectModel, List<MavenDependency> dependencies) {
        if (projectModel == this.getMuleProjectModel()) {
            this.updateDependencies(dependencies, (IMuleProject)this);
        }
    }

    protected void dependenciesRemovedFromModel(IMuleProjectModel projectModel, List<MavenDependency> dependencies) {
        if (projectModel == this.getMuleProjectModel()) {
            this.updateDependencies(dependencies, (IMuleProject)this);
        }
    }

    protected void apiSpecDependenciesRemovedFromModel(IMuleProjectModel projectModel, List<MavenDependency> dependencies) {
        if (projectModel == this.getMuleProjectModel()) {
            dependencies.forEach(dep -> this.removeAPISpecDependency((MavenDependency)dep, this));
        }
    }

    protected void apiSpecDependenciesAddedToModel(IMuleProjectModel projectModel, List<MavenDependency> dependencies) {
        if (projectModel == this.getMuleProjectModel()) {
            dependencies.forEach(dep -> this.addAPISpecDependency((MavenDependency)dep, this));
        }
    }

    protected void extensionsAddedToModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
        if (projectModel == this.getMuleProjectModel()) {
            for (MuleExtension extension : extensions) {
                IMuleModuleManager moduleManagerToAppendTo = this.getModuleManagerForExtension(extension);
                if (moduleManagerToAppendTo.containsExtension(extension)) continue;
                this.resolveAndAppendModuleManager(moduleManagerToAppendTo, extension);
            }
        }
    }

    private void handleDependencyResolutionProblems(MuleExtension extension, Map<MavenDependency, List<Exception>> depToExceptions) {
        try {
            ExtensionResolutionRule.withErrors(extension, depToExceptions).apply(this.getProject());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem creating error markers for extension resolution. Extension: " + extension.getQualifier() + " Project: " + this.getProject().getName(), e);
        }
    }

    private void appendModuleManager(IMuleModuleManager baseModuleManager, ILinkableModuleManager moduleManager) {
        if (!(baseModuleManager instanceof LinkedModuleManager)) {
            throw new IllegalArgumentException(String.valueOf(baseModuleManager) + " not an instance of " + LinkedModuleManager.class.getSimpleName());
        }
        LinkedModuleManager linkedModuleManager = (LinkedModuleManager)baseModuleManager;
        linkedModuleManager.append(moduleManager);
        this.postModuleManagerModified();
    }

    private void postModuleManagerModified() {
        this.clearConfigurationsCache();
        MuleCorePlugin.getEventBus().fireEvent((IEvent)new MuleModuleManagerRestartedEvent(this.getModuleManager()));
        this.updateSchemaLookupIfRequired();
    }

    private void updateSchemaLookupIfRequired() {
        if (this.getSchemaLocationLookup() instanceof ProjectSchemaLocationLookup) {
            ((ProjectSchemaLocationLookup)this.getSchemaLocationLookup()).updateIfRequired(this.getModuleManager());
        }
    }

    private void clearConfigurationsCache() {
        this.cache = new MuleConfigurationsCache(this.cache);
        this.initialize(ProjectInitializationData.EmptyData.instance());
    }

    private void detachModuleManager(ILinkableModuleManager moduleManager) {
        this.getRootModuleManager().detach(moduleManager);
        this.postModuleManagerModified();
    }

    protected void extensionsRemovedFromModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
        if (projectModel == this.getMuleProjectModel()) {
            extensions.forEach(extension -> {
                this.removeExtension((MuleExtension)extension);
                this.clearErrorMarkers((MuleExtension)extension);
            });
        }
    }

    private void clearErrorMarkers(MuleExtension extension) {
        try {
            ExtensionResolutionRule.withValidResult(extension).apply(this.getProject());
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem clearing error markers for extension resolution. Extension: " + extension.getQualifier() + " Project: " + this.getProject().getName(), e);
        }
    }

    private void removeExtension(MuleExtension extension) {
        this.removeConnectorDependency(extension, this);
        Optional<ILinkableModuleManager> extensionManager = this.getRootModuleManager().getManagerContaining(extension);
        extensionManager.map(m -> ((SingleExtensionModuleManager)m).getExternalModule()).ifPresent(module -> this.detachModuleManager((ILinkableModuleManager)extensionManager.get()));
    }

    @Override
    public void onExtensionRemovedFromClasspath(MuleExtension removedExtension, IMuleProject muleProject) {
        try {
            if (muleProject == this) {
                this.internalRemoveExtension(removedExtension);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem removing an extension responding to a classpath event", e);
        }
    }

    @Override
    public void onApiRemovedFromClasspath(MavenDependency removedExtension, IMuleProject muleProject) {
        try {
            if (muleProject == this) {
                this.internalRemoveApi(removedExtension);
            }
        }
        catch (CoreException e) {
            MuleCorePlugin.logError("There was a problem removing an extension responding to a classpath event", e);
        }
    }

    private void internalRemoveApi(MavenDependency removedApiDependency) throws CoreException {
        boolean projectContainsExtension;
        boolean isEventExpected = this.isEventExpected(removedApiDependency);
        if (!isEventExpected && (projectContainsExtension = this.containsDependency(removedApiDependency))) {
            this.removeApiDependencyFromProjectModel(removedApiDependency);
        }
    }

    private void removeApiDependencyFromProjectModel(MavenDependency removedExtension) {
        this.getMuleProjectModel().removeMavenDependency(removedExtension);
    }

    private boolean containsDependency(MavenDependency mavenDependency) {
        return this.getMuleProjectModel().getAllAPIDependencies().stream().anyMatch(dep -> MavenUtils.getGAVCT(mavenDependency).equals(MavenUtils.getGAVCT(dep)));
    }

    private void internalRemoveExtension(MuleExtension removedExtension) throws CoreException {
        boolean projectContainsExtension;
        boolean isEventExpected = this.isEventExpected(removedExtension);
        if (!isEventExpected && (projectContainsExtension = this.containsExtension(removedExtension))) {
            this.removeMuleExtensionFromModel(removedExtension);
        }
    }

    private boolean isEventExpected(MuleExtension removedExtension) {
        return this.getDependencyManager().consumeExpectedRemoveEvent(EclipseDependencyManager.IdSupplier.of(removedExtension));
    }

    private boolean isEventExpected(MavenDependency removedDependency) {
        return this.getDependencyManager().consumeExpectedRemoveEvent(EclipseDependencyManager.IdSupplier.of(removedDependency));
    }

    private boolean containsExtension(MuleExtension extension) {
        return this.getMuleProjectModel().getMuleExtensions().stream().anyMatch(ext -> ext.getQualifier().equals(extension.getQualifier()) && ext.getScope().equals(extension.getScope()));
    }

    @Override
    public void addMuleExtension(ExternalContributionMuleModule module) throws CoreException {
        this.addMuleExtension(module, false);
    }

    private void addMuleExtension(ExternalContributionMuleModule module, boolean isTest) throws CoreException {
        this.addMuleExtensionToModel(module, isTest);
        this.setChanged();
        this.notifyObservers("extensions");
        AnalyticsRecordsFactory.single(Events.EXTENSION_ADDED, this).withMuleModuleCoordinates(module).track();
    }

    public void addMuleExtensionToModel(ExternalContributionMuleModule module, boolean isTest) throws CoreException {
        if (this.getMuleProjectModel().getMuleExtensions().stream().noneMatch(m -> m.getQualifier().equals(module.getId()))) {
            this.onJarAddedToClasspath(module.getContributionJarFile(), this);
            MuleExtension muleExtension = new ObjectFactory().createMuleExtension();
            muleExtension.setName(module.getName());
            muleExtension.setQualifier(module.getId());
            if (isTest) {
                muleExtension.setScope(MavenDependency.Scope.TEST.asString());
            }
            this.addMuleExtensionToModel(muleExtension);
        }
    }

    @Override
    public void addMuleTestExtension(ExternalContributionMuleModule muleModule) throws CoreException {
        this.addMuleExtension(muleModule, true);
    }

    private void addMuleExtensionToModel(MuleExtension muleExtension) {
        this.getMuleProjectModel().addMuleExtension(muleExtension);
    }

    private IMuleModuleManager getModuleManagerForExtension(MuleExtension muleExtension) {
        return muleExtension.getScope().equals(MavenDependency.Scope.TEST.asString()) ? this.getRootModuleManager() : this.getNonTestModuleManager();
    }

    private void resolveAndAppendModuleManager(IMuleModuleManager baseModuleManager, MuleExtension muleExtension) {
        MavenDependency dependency2 = MavenUtils.getDependency(muleExtension);
        String mavenCoords = MavenCore.getCoords(dependency2);
        Optional<ExternalContributionMuleModule> externalModule = MuleCorePlugin.getModuleContributionManager().getExternalModule(this.getServerDefinition(), mavenCoords);
        if (externalModule.isPresent()) {
            this.doAppendModuleManager(baseModuleManager, muleExtension, externalModule.get());
        } else {
            ArtifactResolvingRunnerFactory.asyncInstance().runResolvingExtension(this, dependency2, SingleExtensionCallback.builder().onSuccess(resolvedModule -> this.doAppendModuleManager(baseModuleManager, muleExtension, (ExternalContributionMuleModule)resolvedModule)).onError(exceptions -> this.handleDependencyResolutionProblems(muleExtension, (Map<MavenDependency, List<Exception>>)exceptions)).build(), (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private void doAppendModuleManager(IMuleModuleManager baseModuleManager, MuleExtension muleExtension, ExternalContributionMuleModule resolvedModule) {
        SingleExtensionModuleManager moduleManager = MuleModuleManagerFactory.createMuleModuleManager(this, resolvedModule, this.getServerDefinition(), muleExtension);
        this.addDependency(resolvedModule, this);
        this.appendModuleManager(baseModuleManager, moduleManager);
        this.clearErrorMarkers(muleExtension);
    }

    protected void addMuleExtensionToProject(ExternalContributionMuleModule module) {
        this.addDependency(module, this);
    }

    private void addDependency(ExternalContributionMuleModule module, IMuleProject muleProject) {
        MuleCorePlugin.debugTracer().traceEntry("/debug/mule-project");
        MuleCorePlugin.debugTracer().traceDumpStack("/debug/mule-project-trace");
        String messageText = String.format(ADD_DEPENDENCY_JOB_TITLE, module.getName());
        if (!this.isModuleOnClasspath(module)) {
            this.scheduleClasspathModificationJob(muleProject, messageText, () -> {
                try {
                    this.getDependencyManager().addConnectorToClasspath(module, this.getJavaProject());
                }
                catch (CoreException e) {
                    MuleCorePlugin.logError("Error trying to add " + String.valueOf(module) + " to the classpath of: " + String.valueOf(muleProject), e);
                }
            });
        }
        this.onJarAddedToClasspath(module.getContributionJarFile(), this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isModuleOnClasspath(ExternalContributionMuleModule module) {
        try {
            String id = module.getId();
            IClasspathEntry[] iClasspathEntryArray = this.getJavaProject().getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                String coordinatesFromPath;
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (CoreUtils.isMuleExtensionContainer(entry.getPath()) && id.equals(coordinatesFromPath = MuleUserLibraryClasspathContainer.getCoordinatesFromPath(entry.getPath()))) {
                    return true;
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            MuleCorePlugin.debugTracer().trace("/debug/mule-project", e.getMessage());
        }
        return false;
    }

    protected void updateDependencies(MavenDependency dependency2, IMuleProject muleProject) {
        this.updateDependencies(Collections.singleton(dependency2), muleProject);
    }

    public void updateDependencies(Collection<MavenDependency> dependency2, IMuleProject muleProject) {
        MuleCorePlugin.debugTracer().traceEntry("/debug/mule-project");
        MuleCorePlugin.debugTracer().traceDumpStack("/debug/mule-project-trace");
        String messageText = String.format(UPDATE_DEPENDENCIES_JOB_TITLE, dependency2.stream().map(MavenUtils::getGAV).collect(Collectors.joining(", ")));
        this.scheduleClasspathModificationJob(muleProject, messageText, () -> {
            try {
                this.getDependencyManager().updateDependencies(this.getJavaProject());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error trying to update project dependencies for: " + String.valueOf(muleProject), e);
            }
        });
    }

    public void addAPISpecDependency(MavenDependency dependency2) {
        this.addAPISpecDependency(dependency2, this);
    }

    protected void addAPISpecDependency(MavenDependency dependency2, IMuleProject muleProject) {
        String messageText = String.format(ADD_DEPENDENCY_JOB_TITLE, dependency2.getGroupId() + ":" + dependency2.getArtifactId() + ":" + dependency2.getVersion());
        this.scheduleClasspathModificationJob(muleProject, messageText, () -> {
            try {
                this.getDependencyManager().addAPISpecDependency(dependency2, this.getJavaProject());
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error trying to add " + String.valueOf(dependency2) + " to the classpath of: " + String.valueOf(muleProject), e);
            }
        });
    }

    public void removeConnectorDependency(MuleExtension extension, IMuleProject muleProject) {
        String messageText = String.format(REMOVE_DEPENDENCY_JOB_TITLE, extension.getName());
        this.scheduleClasspathModificationJob(muleProject, messageText, () -> {
            try {
                this.getDependencyManager().removeConnectorDependencyEntry(muleProject, extension);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error trying to remove " + String.valueOf(extension) + " from the classpath of: " + String.valueOf(muleProject), e);
            }
        });
    }

    public void removeAPISpecDependency(MavenDependency dependency2, IMuleProject muleProject) {
        String messageText = String.format(REMOVE_DEPENDENCY_JOB_TITLE, dependency2.getArtifactId());
        this.scheduleClasspathModificationJob(muleProject, messageText, () -> {
            try {
                this.getDependencyManager().removeApisSpecDependencyEntry(muleProject, dependency2);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error trying to remove " + String.valueOf(dependency2) + " from the classpath of: " + String.valueOf(muleProject), e);
            }
        });
    }

    private void scheduleClasspathModificationJob(IMuleProject muleProject, final String jobTitle, final Runnable runnable) {
        WorkspaceResourceJob changeClasspathJob = new WorkspaceResourceJob((IResource)muleProject.getProject(), jobTitle){

            @Override
            public IStatus runWorkspaceJob(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask(jobTitle, 100);
                runnable.run();
                return Status.OK_STATUS;
            }
        };
        changeClasspathJob.setUser(false);
        changeClasspathJob.setPriority(20);
        this.sequentialJobScheduler.schedule((Job)changeClasspathJob);
    }

    @Override
    public void removeMuleExtension(ExternalContributionMuleModule module) throws CoreException {
        this.removeMuleExtensionFromModel(module);
        this.setChanged();
        this.notifyObservers("extensions");
    }

    public void removeMuleExtension(MuleExtension extension) throws CoreException {
        this.removeMuleExtensionFromModel(extension);
        this.setChanged();
        this.notifyObservers("extensions");
    }

    protected void removeMuleExtensionFromModel(ExternalContributionMuleModule module) {
        MuleExtension muleExtension = CoreUtils.getMuleExtensionFromModule(module, false);
        this.removeMuleExtensionFromModel(muleExtension);
    }

    private void removeMuleExtensionFromModel(MuleExtension muleExtension) {
        MuleCorePlugin.debugTracer().traceEntry("/debug/mule-project");
        MuleCorePlugin.debugTracer().traceDumpStack("/debug/mule-project-trace");
        this.getMuleProjectModel().removeMuleExtension(muleExtension);
        this.getRootModuleManager().getManagerContaining(muleExtension).ifPresent(this::detachModuleManager);
    }

    public EclipseDependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    @Override
    public List<MuleExtension> getDeclaredExtensions() {
        return new ArrayList<MuleExtension>(this.getMuleProjectModel().getMuleExtensions());
    }

    @Override
    public List<MavenDependency> getDeclaredDependencies() {
        return new ArrayList<MavenDependency>(this.getMuleProjectModel().getDependencies());
    }

    @Override
    public List<Repository> getProjectRepositories() {
        return new ArrayList<Repository>(this.getMuleProjectModel().getRepositories());
    }

    @Override
    public File getFolder(String relativePath, boolean createIfNotExists) {
        File projectFile = this.getProject().getLocation().toFile();
        File folder = new File(projectFile, relativePath);
        if (createIfNotExists && !folder.exists()) {
            folder.mkdirs();
            try {
                CoreUtils.refreshProject(this, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                throw new RuntimeException(e);
            }
        }
        return folder;
    }

    @Override
    public IPath getLocation() {
        return this.getProject().getLocation();
    }

    @Override
    public void refresh() {
        this.refresh((IProgressMonitor)new NullProgressMonitor(), 2);
    }

    @Override
    public void refresh(IProgressMonitor monitor) {
        this.refresh(monitor, 2);
    }

    protected Map<File, List<String>> getClasspathMuleConfigurations() {
        return this.classpathMuleConfigurations;
    }

    private void unregisterListeners() {
        this.eventBusHelper.unregister();
    }

    @Override
    public void refresh(IProgressMonitor monitor, int depth) {
        try {
            IProject project = this.getProject();
            if (project != null) {
                project.refreshLocal(depth, monitor);
            }
        }
        catch (CoreException e) {
            throw new RuntimeException("Error refreshing project", e);
        }
    }

    @Override
    public void onJarAddedToClasspath(File file, IMuleProject muleProject) {
        List<String> configFileNames;
        if (muleProject == this && CoreUtils.isJarFile(file) && !(configFileNames = ExternalConfigsManagementUtils.getConfigFileNames(file)).isEmpty()) {
            this.classpathMuleConfigurations.put(file, configFileNames);
        }
    }

    @Override
    public void onJarRemovedFromClasspath(File file, IMuleProject muleProject) {
        if (muleProject == this && CoreUtils.isJarFile(file)) {
            this.classpathMuleConfigurations.remove(file);
        }
    }

    public abstract List<IClasspathEntry> getSourceFolderEntries();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedModuleManager getRootModuleManager() {
        if (this.rootModuleManager == null) {
            BaseMuleProject baseMuleProject = this;
            synchronized (baseMuleProject) {
                if (this.rootModuleManager == null) {
                    this.initializeModuleManager(Optional.of(this.getRuntimeId()), this.getDeclaredExtensions());
                }
            }
        }
        return this.rootModuleManager;
    }

    @Override
    public MavenDependency getProjectDependency() {
        IMuleProjectModel projectModel = this.getMuleProjectModel();
        return ((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)((PojoMavenDependencyBuilder)PojoMavenDependencyBuilder.newInstance().withGroupId(projectModel.getGroupId())).withArtifactId(projectModel.getArtifactId())).withVersion(projectModel.getVersion())).build();
    }

    @Override
    public void modifyClasspath(Consumer<List<IClasspathEntry>> modifyClasspathFunction, IProgressMonitor monitor) throws JavaModelException {
        MuleCorePlugin.debugTracer().traceEntry("/debug/mule-project");
        MuleCorePlugin.debugTracer().traceDumpStack("/debug/mule-project-trace");
        this.getDependencyManager().modifyClasspath(this.getJavaProject(), modifyClasspathFunction, monitor);
    }

    @Override
    public boolean isAccessible() {
        return this.getProject().isAccessible();
    }

    @Override
    public IProject getProject() {
        return this.javaProject.getProject();
    }

    @Override
    public ISchemaLocationLookup getSchemaLocationLookup() {
        return (ISchemaLocationLookup)this.schemaLocationLookup.getOrCompute();
    }

    @Override
    public <T extends IMuleProjectComponent> T getProjectComponent(Class<T> componentClass) {
        return MuleProjectComponentManager.getInstance().getComponent(this, componentClass);
    }

    private static class APISpecDependenciesModelListener
    extends MuleProjectModelListenerAdapter {
        private final BaseMuleProject project;

        private APISpecDependenciesModelListener(BaseMuleProject project) {
            this.project = project;
        }

        @Override
        public void apiSpecDependenciesAddedToModel(IMuleProjectModel projectModel, List<MavenDependency> dependencies) {
            this.project.apiSpecDependenciesAddedToModel(projectModel, dependencies);
        }

        @Override
        public void apiSpecDependenciesRemovedFromModel(IMuleProjectModel projectModel, List<MavenDependency> dependencies) {
            this.project.apiSpecDependenciesRemovedFromModel(projectModel, dependencies);
        }

        @Override
        public void modelChanged(IMuleProjectModel projectModel, String key, Object value) {
        }
    }

    private final class AfterSaveListener
    implements IResourceChangeListener {
        private final IProject project;

        private AfterSaveListener(IProject project) {
            this.project = project;
        }

        public void resourceChanged(IResourceChangeEvent event) {
            this.project.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            try {
                if (this.project.isAccessible()) {
                    BaseMuleProject.this.initializeFilesAndFolders(this.project);
                    this.project.touch((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (CoreException e) {
                MuleCorePlugin.logError("Error trying to refresh classpath container", e);
            }
        }
    }

    private static class DependenciesProjectModelListener
    extends MuleProjectModelListenerAdapter {
        private final BaseMuleProject project;

        private DependenciesProjectModelListener(BaseMuleProject project) {
            this.project = project;
        }

        @Override
        public void dependenciesAddedToModel(IMuleProjectModel projectModel, List<MavenDependency> extensions) {
            this.project.dependenciesAddedToModel(projectModel, extensions);
        }

        @Override
        public void dependenciesRemovedFromModel(IMuleProjectModel projectModel, List<MavenDependency> extensions) {
            this.project.dependenciesRemovedFromModel(projectModel, extensions);
        }

        @Override
        public void modelChanged(IMuleProjectModel projectModel, String key, Object value) {
        }
    }

    private static class ExtensionsProjectModelListener
    extends MuleProjectModelListenerAdapter {
        private final BaseMuleProject project;

        private ExtensionsProjectModelListener(BaseMuleProject project) {
            this.project = project;
        }

        @Override
        public void extensionsAddedToModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            this.project.extensionsAddedToModel(projectModel, extensions);
        }

        @Override
        public void extensionsRemovedFromModel(IMuleProjectModel projectModel, List<MuleExtension> extensions) {
            this.project.extensionsRemovedFromModel(projectModel, extensions);
        }
    }
}

